/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.analytics.channel;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.microsoft.appcenter.analytics.ingestion.models.StartSessionLog;
import com.microsoft.appcenter.channel.AbstractChannelListener;
import com.microsoft.appcenter.channel.Channel;
import com.microsoft.appcenter.ingestion.models.Log;
import com.microsoft.appcenter.ingestion.models.StartServiceLog;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.context.SessionContext;
import java.util.Date;
import java.util.UUID;

public class SessionTracker
extends AbstractChannelListener {
    private static final long SESSION_TIMEOUT = 20000L;
    private final Channel mChannel;
    private boolean isManualSessionTrackerEnabled = false;
    private final String mGroupName;
    private UUID mSid;
    private long mLastQueuedLogTime;
    private Long mLastResumedTime;
    private Long mLastPausedTime;

    public SessionTracker(Channel channel, String groupName) {
        this.mChannel = channel;
        this.mGroupName = groupName;
    }

    public void onPreparingLog(@NonNull Log log, @NonNull String groupName) {
        if (log instanceof StartSessionLog || log instanceof StartServiceLog) {
            return;
        }
        Date timestamp = log.getTimestamp();
        if (timestamp != null) {
            SessionContext.SessionInfo pastSession = SessionContext.getInstance().getSessionAt(timestamp.getTime());
            if (pastSession != null) {
                log.setSid(pastSession.getSessionId());
            }
        } else {
            log.setSid(this.mSid);
            if (!this.isManualSessionTrackerEnabled) {
                this.mLastQueuedLogTime = SystemClock.elapsedRealtime();
            }
        }
    }

    @WorkerThread
    private void sendStartSessionIfNeeded() {
        if (this.mSid == null || this.hasSessionTimedOut()) {
            this.mLastQueuedLogTime = SystemClock.elapsedRealtime();
            this.sendStartSession();
        }
    }

    private void sendStartSession() {
        this.mSid = UUID.randomUUID();
        SessionContext.getInstance().addSession(this.mSid);
        StartSessionLog startSessionLog = new StartSessionLog();
        startSessionLog.setSid(this.mSid);
        this.mChannel.enqueue((Log)startSessionLog, this.mGroupName, 1);
    }

    @WorkerThread
    public void onActivityResumed() {
        if (this.isManualSessionTrackerEnabled) {
            AppCenterLog.verbose((String)"AppCenterAnalytics", (String)"Manual session tracker is enabled. Skip tracking a session status request after resumed activity.");
            return;
        }
        AppCenterLog.debug((String)"AppCenterAnalytics", (String)"onActivityResumed");
        this.mLastResumedTime = SystemClock.elapsedRealtime();
        this.sendStartSessionIfNeeded();
    }

    @WorkerThread
    public void onActivityPaused() {
        if (this.isManualSessionTrackerEnabled) {
            AppCenterLog.verbose((String)"AppCenterAnalytics", (String)"Manual session tracker is enabled. Skip tracking a session status request after paused activity.");
            return;
        }
        AppCenterLog.debug((String)"AppCenterAnalytics", (String)"onActivityPaused");
        this.mLastPausedTime = SystemClock.elapsedRealtime();
    }

    public void clearSessions() {
        SessionContext.getInstance().clearSessions();
    }

    public void enableManualSessionTracker() {
        this.isManualSessionTrackerEnabled = true;
        AppCenterLog.debug((String)"AppCenterAnalytics", (String)"Manual session tracker is enabled.");
    }

    public void startSession() {
        if (!this.isManualSessionTrackerEnabled) {
            AppCenterLog.debug((String)"AppCenterAnalytics", (String)"Manual session tracker is disabled. Skip start a new session request.");
            return;
        }
        this.sendStartSession();
        AppCenterLog.debug((String)"AppCenterAnalytics", (String)String.format("Started a new session with id: %s.", this.mSid));
    }

    private boolean hasSessionTimedOut() {
        if (this.mLastPausedTime == null) {
            return false;
        }
        long now = SystemClock.elapsedRealtime();
        boolean noLogSentForLong = now - this.mLastQueuedLogTime >= 20000L;
        boolean wasBackgroundForLong = this.mLastResumedTime - Math.max(this.mLastPausedTime, this.mLastQueuedLogTime) >= 20000L;
        AppCenterLog.debug((String)"AppCenterAnalytics", (String)("noLogSentForLong=" + noLogSentForLong + " wasBackgroundForLong=" + wasBackgroundForLong));
        return noLogSentForLong && wasBackgroundForLong;
    }
}

