/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.analytics;

import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.HashUtils;
import com.microsoft.appcenter.utils.TicketCache;
import java.util.Date;

public class AuthenticationProvider {
    private static final long REFRESH_THRESHOLD = 600000L;
    private final Type mType;
    private final String mTicketKey;
    private final String mTicketKeyHash;
    private final TokenProvider mTokenProvider;
    private AuthenticationCallback mCallback;
    private Date mExpiryDate;

    public AuthenticationProvider(Type type, String ticketKey, TokenProvider tokenProvider) {
        this.mType = type;
        this.mTicketKey = ticketKey;
        this.mTicketKeyHash = ticketKey == null ? null : HashUtils.sha256((String)ticketKey);
        this.mTokenProvider = tokenProvider;
    }

    Type getType() {
        return this.mType;
    }

    String getTicketKey() {
        return this.mTicketKey;
    }

    String getTicketKeyHash() {
        return this.mTicketKeyHash;
    }

    TokenProvider getTokenProvider() {
        return this.mTokenProvider;
    }

    synchronized void acquireTokenAsync() {
        if (this.mCallback != null) {
            return;
        }
        AppCenterLog.debug((String)"AppCenterAnalytics", (String)("Calling token provider=" + (Object)((Object)this.mType) + " callback."));
        this.mCallback = new AuthenticationCallback(){

            @Override
            public void onAuthenticationResult(String token, Date expiryDate) {
                AuthenticationProvider.this.handleTokenUpdate(token, expiryDate, this);
            }
        };
        this.mTokenProvider.acquireToken(this.mTicketKey, this.mCallback);
    }

    private synchronized void handleTokenUpdate(String token, Date expiryDate, AuthenticationCallback callback) {
        if (this.mCallback != callback) {
            AppCenterLog.debug((String)"AppCenterAnalytics", (String)("Ignore duplicate authentication callback calls, provider=" + (Object)((Object)this.mType)));
            return;
        }
        this.mCallback = null;
        AppCenterLog.debug((String)"AppCenterAnalytics", (String)("Got result back from token provider=" + (Object)((Object)this.mType)));
        if (token == null) {
            AppCenterLog.error((String)"AppCenterAnalytics", (String)("Authentication failed for ticketKey=" + this.mTicketKey));
            return;
        }
        if (expiryDate == null) {
            AppCenterLog.error((String)"AppCenterAnalytics", (String)("No expiry date provided for ticketKey=" + this.mTicketKey));
            return;
        }
        TicketCache.putTicket((String)this.mTicketKeyHash, (String)(this.mType.mTokenPrefix + token));
        this.mExpiryDate = expiryDate;
    }

    synchronized void checkTokenExpiry() {
        if (this.mExpiryDate != null && this.mExpiryDate.getTime() <= System.currentTimeMillis() + 600000L) {
            this.acquireTokenAsync();
        }
    }

    public static interface AuthenticationCallback {
        public void onAuthenticationResult(String var1, Date var2);
    }

    public static interface TokenProvider {
        public void acquireToken(String var1, AuthenticationCallback var2);
    }

    public static enum Type {
        MSA_COMPACT("p"),
        MSA_DELEGATE("d");

        private static final String TOKEN_PREFIX_SEPARATOR = ":";
        private final String mTokenPrefix;

        private Type(String tokenPrefix) {
            this.mTokenPrefix = tokenPrefix + TOKEN_PREFIX_SEPARATOR;
        }
    }
}

