/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.analytics;

import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.microsoft.appcenter.analytics.Analytics;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.async.AppCenterFuture;
import com.microsoft.appcenter.utils.async.DefaultAppCenterFuture;
import com.microsoft.appcenter.utils.storage.StorageHelper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;

public class AnalyticsTransmissionTarget {
    private final String mTransmissionTargetToken;
    private final AnalyticsTransmissionTarget mParentTarget;
    private final Map<String, AnalyticsTransmissionTarget> mChildrenTargets = new HashMap<String, AnalyticsTransmissionTarget>();
    private final Map<String, String> mEventProperties = new HashMap<String, String>();

    AnalyticsTransmissionTarget(@NonNull String transmissionTargetToken, AnalyticsTransmissionTarget parentTarget) {
        this.mTransmissionTargetToken = transmissionTargetToken;
        this.mParentTarget = parentTarget;
    }

    public void trackEvent(String name) {
        this.trackEvent(name, null);
    }

    public void trackEvent(String name, Map<String, String> properties) {
        HashMap<String, String> mergedProperties = new HashMap<String, String>();
        AnalyticsTransmissionTarget target = this;
        while (target != null) {
            target.mergeEventProperties(mergedProperties);
            target = target.mParentTarget;
        }
        if (properties != null) {
            mergedProperties.putAll(properties);
        } else if (mergedProperties.isEmpty()) {
            mergedProperties = null;
        }
        Analytics.trackEvent(name, mergedProperties, this);
    }

    private synchronized void mergeEventProperties(Map<String, String> mergedProperties) {
        for (Map.Entry<String, String> property : this.mEventProperties.entrySet()) {
            String key = property.getKey();
            if (mergedProperties.containsKey(key)) continue;
            mergedProperties.put(key, property.getValue());
        }
    }

    public synchronized void setEventProperty(String key, String value) {
        this.mEventProperties.put(key, value);
    }

    public synchronized void removeEventProperty(String key) {
        this.mEventProperties.remove(key);
    }

    public synchronized AnalyticsTransmissionTarget getTransmissionTarget(String transmissionTargetToken) {
        AnalyticsTransmissionTarget childTarget = this.mChildrenTargets.get(transmissionTargetToken);
        if (childTarget == null) {
            childTarget = new AnalyticsTransmissionTarget(transmissionTargetToken, this);
            this.mChildrenTargets.put(transmissionTargetToken, childTarget);
        }
        return childTarget;
    }

    public AppCenterFuture<Boolean> isEnabledAsync() {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        Analytics.getInstance().postCommand(new Runnable(){

            @Override
            public void run() {
                future.complete((Object)AnalyticsTransmissionTarget.this.isEnabled());
            }
        }, future, false);
        return future;
    }

    public AppCenterFuture<Void> setEnabledAsync(final boolean enabled) {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        Analytics.getInstance().postCommand(new Runnable(){

            @Override
            public void run() {
                if (AnalyticsTransmissionTarget.this.areAncestorsEnabled()) {
                    LinkedList<AnalyticsTransmissionTarget> descendantTargets = new LinkedList<AnalyticsTransmissionTarget>();
                    descendantTargets.add(AnalyticsTransmissionTarget.this);
                    while (!descendantTargets.isEmpty()) {
                        ListIterator<AnalyticsTransmissionTarget> descendantIterator = descendantTargets.listIterator();
                        while (descendantIterator.hasNext()) {
                            AnalyticsTransmissionTarget descendantTarget = (AnalyticsTransmissionTarget)descendantIterator.next();
                            descendantIterator.remove();
                            StorageHelper.PreferencesStorage.putBoolean((String)descendantTarget.getEnabledPreferenceKey(), (boolean)enabled);
                            for (AnalyticsTransmissionTarget childTarget : descendantTarget.mChildrenTargets.values()) {
                                descendantIterator.add(childTarget);
                            }
                        }
                    }
                } else {
                    AppCenterLog.error((String)"AppCenterAnalytics", (String)"One of the parent transmission target is disabled, cannot change state.");
                }
                future.complete(null);
            }
        }, future, null);
        return future;
    }

    String getTransmissionTargetToken() {
        return this.mTransmissionTargetToken;
    }

    @NonNull
    private String getEnabledPreferenceKey() {
        return Analytics.getInstance().getEnabledPreferenceKeyPrefix() + this.mTransmissionTargetToken.split("-")[0];
    }

    @WorkerThread
    private boolean isEnabledInStorage() {
        return StorageHelper.PreferencesStorage.getBoolean((String)this.getEnabledPreferenceKey(), (boolean)true);
    }

    @WorkerThread
    private boolean areAncestorsEnabled() {
        AnalyticsTransmissionTarget target = this.mParentTarget;
        while (target != null) {
            if (!target.isEnabledInStorage()) {
                return false;
            }
            target = target.mParentTarget;
        }
        return true;
    }

    @WorkerThread
    boolean isEnabled() {
        return this.areAncestorsEnabled() && this.isEnabledInStorage();
    }
}

