/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.analytics;

import android.content.ContentResolver;
import android.provider.Settings;
import android.support.annotation.NonNull;
import com.microsoft.appcenter.analytics.Analytics;
import com.microsoft.appcenter.analytics.AnalyticsTransmissionTarget;
import com.microsoft.appcenter.analytics.EventProperties;
import com.microsoft.appcenter.channel.AbstractChannelListener;
import com.microsoft.appcenter.ingestion.models.Log;
import com.microsoft.appcenter.ingestion.models.one.AppExtension;
import com.microsoft.appcenter.ingestion.models.one.CommonSchemaLog;
import com.microsoft.appcenter.ingestion.models.one.DeviceExtension;
import com.microsoft.appcenter.ingestion.models.one.UserExtension;
import com.microsoft.appcenter.ingestion.models.properties.TypedProperty;
import com.microsoft.appcenter.utils.UserIdContext;
import java.util.Date;
import java.util.Map;

public class PropertyConfigurator
extends AbstractChannelListener {
    private static final String ANDROID_DEVICE_ID_PREFIX = "a:";
    private String mAppName;
    private String mAppVersion;
    private String mAppLocale;
    private String mUserId;
    private boolean mDeviceIdEnabled;
    private final AnalyticsTransmissionTarget mTransmissionTarget;
    private final EventProperties mEventProperties = new EventProperties();

    PropertyConfigurator(AnalyticsTransmissionTarget transmissionTarget) {
        this.mTransmissionTarget = transmissionTarget;
    }

    public void onPreparingLog(@NonNull Log log, @NonNull String groupName) {
        if (this.shouldOverridePartAProperties(log)) {
            AnalyticsTransmissionTarget target;
            AppExtension app = ((CommonSchemaLog)log).getExt().getApp();
            UserExtension user = ((CommonSchemaLog)log).getExt().getUser();
            DeviceExtension device = ((CommonSchemaLog)log).getExt().getDevice();
            if (this.mAppName != null) {
                app.setName(this.mAppName);
            } else {
                target = this.mTransmissionTarget.mParentTarget;
                while (target != null) {
                    String parentAppName = target.getPropertyConfigurator().getAppName();
                    if (parentAppName != null) {
                        app.setName(parentAppName);
                        break;
                    }
                    target = target.mParentTarget;
                }
            }
            if (this.mAppVersion != null) {
                app.setVer(this.mAppVersion);
            } else {
                target = this.mTransmissionTarget.mParentTarget;
                while (target != null) {
                    String parentAppVersion = target.getPropertyConfigurator().getAppVersion();
                    if (parentAppVersion != null) {
                        app.setVer(parentAppVersion);
                        break;
                    }
                    target = target.mParentTarget;
                }
            }
            if (this.mAppLocale != null) {
                app.setLocale(this.mAppLocale);
            } else {
                target = this.mTransmissionTarget.mParentTarget;
                while (target != null) {
                    String parentAppLocale = target.getPropertyConfigurator().getAppLocale();
                    if (parentAppLocale != null) {
                        app.setLocale(parentAppLocale);
                        break;
                    }
                    target = target.mParentTarget;
                }
            }
            if (this.mUserId != null) {
                user.setLocalId(this.mUserId);
            } else {
                target = this.mTransmissionTarget.mParentTarget;
                while (target != null) {
                    String parentUserId = target.getPropertyConfigurator().getUserId();
                    if (parentUserId != null) {
                        user.setLocalId(parentUserId);
                        break;
                    }
                    target = target.mParentTarget;
                }
            }
            if (this.mDeviceIdEnabled) {
                String androidId = Settings.Secure.getString((ContentResolver)this.mTransmissionTarget.mContext.getContentResolver(), (String)"android_id");
                device.setLocalId(ANDROID_DEVICE_ID_PREFIX + androidId);
            }
        }
    }

    private boolean shouldOverridePartAProperties(@NonNull Log log) {
        return log instanceof CommonSchemaLog && log.getTag() == this.mTransmissionTarget && this.mTransmissionTarget.isEnabled();
    }

    private String getAppName() {
        return this.mAppName;
    }

    public void setAppName(final String appName) {
        Analytics.getInstance().postCommandEvenIfDisabled(new Runnable(){

            @Override
            public void run() {
                PropertyConfigurator.this.mAppName = appName;
            }
        });
    }

    private String getAppVersion() {
        return this.mAppVersion;
    }

    public void setAppVersion(final String appVersion) {
        Analytics.getInstance().postCommandEvenIfDisabled(new Runnable(){

            @Override
            public void run() {
                PropertyConfigurator.this.mAppVersion = appVersion;
            }
        });
    }

    private String getAppLocale() {
        return this.mAppLocale;
    }

    public void setAppLocale(final String appLocale) {
        Analytics.getInstance().postCommandEvenIfDisabled(new Runnable(){

            @Override
            public void run() {
                PropertyConfigurator.this.mAppLocale = appLocale;
            }
        });
    }

    private String getUserId() {
        return this.mUserId;
    }

    public void setUserId(final String userId) {
        if (UserIdContext.checkUserIdValidForOneCollector((String)userId)) {
            Analytics.getInstance().postCommandEvenIfDisabled(new Runnable(){

                @Override
                public void run() {
                    PropertyConfigurator.this.mUserId = UserIdContext.getPrefixedUserId((String)userId);
                }
            });
        }
    }

    public synchronized void setEventProperty(String key, boolean value) {
        this.mEventProperties.set(key, value);
    }

    public synchronized void setEventProperty(String key, Date value) {
        this.mEventProperties.set(key, value);
    }

    public synchronized void setEventProperty(String key, double value) {
        this.mEventProperties.set(key, value);
    }

    public synchronized void setEventProperty(String key, long value) {
        this.mEventProperties.set(key, value);
    }

    public synchronized void setEventProperty(String key, String value) {
        this.mEventProperties.set(key, value);
    }

    public synchronized void removeEventProperty(String key) {
        this.mEventProperties.getProperties().remove(key);
    }

    public void collectDeviceId() {
        Analytics.getInstance().postCommandEvenIfDisabled(new Runnable(){

            @Override
            public void run() {
                PropertyConfigurator.this.mDeviceIdEnabled = true;
            }
        });
    }

    synchronized void mergeEventProperties(EventProperties mergedProperties) {
        for (Map.Entry<String, TypedProperty> property : this.mEventProperties.getProperties().entrySet()) {
            String key = property.getKey();
            if (mergedProperties.getProperties().containsKey(key)) continue;
            mergedProperties.getProperties().put(key, property.getValue());
        }
    }
}

