/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import androidx.annotation.NonNull;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.AuthorityValidationMetadataCache;
import com.microsoft.aad.adal.CacheEvent;
import com.microsoft.aad.adal.CacheKey;
import com.microsoft.aad.adal.CoreAdapter;
import com.microsoft.aad.adal.DefaultTokenCacheStore;
import com.microsoft.aad.adal.DelegatingCache;
import com.microsoft.aad.adal.Discovery;
import com.microsoft.aad.adal.ITokenCacheStore;
import com.microsoft.aad.adal.InstanceDiscoveryMetadata;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.Telemetry;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.TokenEntryType;
import com.microsoft.aad.adal.UrlExtensions;
import com.microsoft.aad.adal.UserInfo;
import com.microsoft.identity.common.adal.internal.cache.ADALOAuth2TokenCache;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.components.AndroidPlatformComponentsFactory;
import com.microsoft.identity.common.java.cache.CacheKeyValueDelegate;
import com.microsoft.identity.common.java.cache.IAccountCredentialAdapter;
import com.microsoft.identity.common.java.cache.IAccountCredentialCache;
import com.microsoft.identity.common.java.cache.ICacheKeyValueDelegate;
import com.microsoft.identity.common.java.cache.MicrosoftStsAccountCredentialAdapter;
import com.microsoft.identity.common.java.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.java.cache.SharedPreferencesAccountCredentialCache;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryOAuth2Configuration;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryOAuth2Strategy;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryTokenResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class TokenCacheAccessor {
    private static final String TAG = TokenCacheAccessor.class.getSimpleName();
    private final Context mContext;
    private final ITokenCacheStore mTokenCacheStore;
    private String mAuthority;
    private final String mTelemetryRequestId;
    private boolean mUseCommonCache = false;
    private ADALOAuth2TokenCache mCommonCache = null;
    private boolean mValidateAuthorityHost = true;

    TokenCacheAccessor(Context appContext, ITokenCacheStore tokenCacheStore, String authority, String telemetryRequestId) {
        if (tokenCacheStore == null) {
            throw new IllegalArgumentException("tokenCacheStore");
        }
        if (StringExtensions.isNullOrBlank((String)authority)) {
            throw new IllegalArgumentException("authority");
        }
        if (StringExtensions.isNullOrBlank((String)telemetryRequestId)) {
            throw new IllegalArgumentException("requestId");
        }
        this.mContext = appContext;
        this.mTokenCacheStore = tokenCacheStore;
        this.mAuthority = authority;
        this.mTelemetryRequestId = telemetryRequestId;
        ArrayList<MsalOAuth2TokenCache> sharedSSOCaches = new ArrayList<MsalOAuth2TokenCache>();
        MsalOAuth2TokenCache msalOAuth2TokenCache = TokenCacheAccessor.getMsalOAuth2TokenCache(appContext);
        sharedSSOCaches.add(msalOAuth2TokenCache);
        this.mCommonCache = new ADALOAuth2TokenCache(AndroidPlatformComponentsFactory.createFromContext((Context)appContext), sharedSSOCaches);
        if (this.mTokenCacheStore instanceof DelegatingCache) {
            ITokenCacheStore delegate = ((DelegatingCache)this.mTokenCacheStore).getDelegateCache();
            this.mUseCommonCache = delegate instanceof DefaultTokenCacheStore;
        }
    }

    static MsalOAuth2TokenCache getMsalOAuth2TokenCache(@NonNull Context appContext) {
        IPlatformComponents components = AndroidPlatformComponentsFactory.createFromContext((Context)appContext);
        SharedPreferencesAccountCredentialCache accountCredentialCache = new SharedPreferencesAccountCredentialCache((ICacheKeyValueDelegate)new CacheKeyValueDelegate(), components.getEncryptedNameValueStore("com.microsoft.identity.client.account_credential_cache", components.getStorageEncryptionManager(), String.class));
        return new MsalOAuth2TokenCache(components, (IAccountCredentialCache)accountCredentialCache, (IAccountCredentialAdapter)new MicrosoftStsAccountCredentialAdapter());
    }

    public boolean isValidateAuthorityHost() {
        return this.mValidateAuthorityHost;
    }

    public void setValidateAuthorityHost(boolean mValidateAuthorityHost) {
        this.mValidateAuthorityHost = mValidateAuthorityHost;
    }

    TokenCacheItem getATFromCache(String resource, String clientId, String user) throws AuthenticationException {
        TokenCacheItem accessTokenItem;
        String methodName = ":getATFromCache";
        try {
            accessTokenItem = this.getRegularRefreshTokenCacheItem(resource, clientId, user);
        }
        catch (MalformedURLException ex) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL, ex.getMessage(), ex);
        }
        if (accessTokenItem == null) {
            Logger.v(TAG + ":getATFromCache", "No access token exists.");
            return null;
        }
        this.throwIfMultipleATExisted(clientId, resource, user);
        if (!StringExtensions.isNullOrBlank((String)accessTokenItem.getAccessToken())) {
            if (TokenCacheItem.isTokenExpired(accessTokenItem.getExpiresOn())) {
                Logger.v(TAG + ":getATFromCache", "Access token exists, but already expired.");
                return null;
            }
            if (this.isUserMisMatch(user, accessTokenItem)) {
                throw new AuthenticationException(ADALError.AUTH_FAILED_USER_MISMATCH);
            }
        }
        return accessTokenItem;
    }

    TokenCacheItem getRegularRefreshTokenCacheItem(String resource, String clientId, String user) throws MalformedURLException {
        CacheEvent cacheEvent = this.startCacheTelemetryRequest("Microsoft.ADAL.rt");
        String cacheKey = CacheKey.createCacheKeyForRTEntry((String)this.getAuthorityUrlWithPreferredCache(), (String)resource, (String)clientId, (String)user);
        TokenCacheItem item = this.mTokenCacheStore.getItem(cacheKey);
        if (item == null) {
            item = this.performAdditionalCacheLookup(resource, clientId, null, user, TokenEntryType.REGULAR_TOKEN_ENTRY);
        }
        if (item != null) {
            cacheEvent.setTokenTypeRT(true);
            cacheEvent.setSpeRing(item.getSpeRing());
        }
        Telemetry.getInstance().stopEvent(this.mTelemetryRequestId, cacheEvent, "Microsoft.ADAL.token_cache_lookup");
        return item;
    }

    TokenCacheItem getMRRTItem(String clientId, String user) throws MalformedURLException {
        CacheEvent cacheEvent = this.startCacheTelemetryRequest("Microsoft.ADAL.mrrt");
        String cacheKey = CacheKey.createCacheKeyForMRRT((String)this.getAuthorityUrlWithPreferredCache(), (String)clientId, (String)user);
        TokenCacheItem item = this.mTokenCacheStore.getItem(cacheKey);
        if (item == null) {
            item = this.performAdditionalCacheLookup(null, clientId, null, user, TokenEntryType.MRRT_TOKEN_ENTRY);
        }
        if (item != null) {
            cacheEvent.setTokenTypeMRRT(true);
            cacheEvent.setTokenTypeFRT(item.isFamilyToken());
        }
        Telemetry.getInstance().stopEvent(this.mTelemetryRequestId, cacheEvent, "Microsoft.ADAL.token_cache_lookup");
        return item;
    }

    TokenCacheItem getFRTItem(String familyClientId, String user) throws MalformedURLException {
        CacheEvent cacheEvent = this.startCacheTelemetryRequest("Microsoft.ADAL.frt");
        if (StringExtensions.isNullOrBlank((String)user)) {
            Telemetry.getInstance().stopEvent(this.mTelemetryRequestId, cacheEvent, "Microsoft.ADAL.token_cache_lookup");
            return null;
        }
        String cacheKey = CacheKey.createCacheKeyForFRT((String)this.getAuthorityUrlWithPreferredCache(), (String)familyClientId, (String)user);
        TokenCacheItem item = this.mTokenCacheStore.getItem(cacheKey);
        if (item == null) {
            item = this.performAdditionalCacheLookup(null, null, familyClientId, user, TokenEntryType.FRT_TOKEN_ENTRY);
        }
        if (item != null) {
            cacheEvent.setTokenTypeFRT(true);
        }
        Telemetry.getInstance().stopEvent(this.mTelemetryRequestId, cacheEvent, "Microsoft.ADAL.token_cache_lookup");
        return item;
    }

    TokenCacheItem getStaleToken(AuthenticationRequest authRequest) throws AuthenticationException {
        TokenCacheItem accessTokenItem;
        String methodName = ":getStaleToken";
        try {
            accessTokenItem = this.getRegularRefreshTokenCacheItem(authRequest.getResource(), authRequest.getClientId(), authRequest.getUserFromRequest());
        }
        catch (MalformedURLException ex) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL, ex.getMessage(), ex);
        }
        if (accessTokenItem != null && !StringExtensions.isNullOrBlank((String)accessTokenItem.getAccessToken()) && accessTokenItem.getExtendedExpiresOn() != null && !TokenCacheItem.isTokenExpired(accessTokenItem.getExtendedExpiresOn())) {
            this.throwIfMultipleATExisted(authRequest.getClientId(), authRequest.getResource(), authRequest.getUserFromRequest());
            Logger.i(TAG + ":getStaleToken", "The stale access token is returned.", "");
            return accessTokenItem;
        }
        Logger.i(TAG + ":getStaleToken", "The stale access token is not found.", "");
        return null;
    }

    void updateCachedItemWithResult(AuthenticationRequest request, AuthenticationResult result, TokenCacheItem cachedItem) throws AuthenticationException {
        String methodName = ":updateCachedItemWithResult";
        if (result == null) {
            Logger.v(TAG + ":updateCachedItemWithResult", "AuthenticationResult is null, cannot update cache.");
            throw new IllegalArgumentException("result");
        }
        if (!StringExtensions.isNullOrBlank((String)result.getAuthority())) {
            this.mAuthority = result.getAuthority();
        }
        if (result.getStatus() == AuthenticationResult.AuthenticationStatus.Succeeded) {
            Logger.v(TAG + ":updateCachedItemWithResult", "Save returned AuthenticationResult into cache.");
            if (cachedItem != null && cachedItem.getUserInfo() != null && result.getUserInfo() == null) {
                result.setUserInfo(cachedItem.getUserInfo());
                result.setIdToken(cachedItem.getRawIdToken());
                result.setTenantId(cachedItem.getTenantId());
            }
            try {
                if (this.mUseCommonCache && !UrlExtensions.isADFSAuthority(new URL(this.mAuthority))) {
                    this.updateTokenCacheUsingCommonCache(request, result);
                }
                this.updateTokenCache(request, result);
            }
            catch (MalformedURLException e) {
                throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL, e.getMessage(), e);
            }
            catch (ClientException e) {
                throw ADALError.fromCommon((BaseException)e);
            }
        } else if ("invalid_grant".equalsIgnoreCase(result.getErrorCode())) {
            Logger.v(TAG + ":updateCachedItemWithResult", "Received INVALID_GRANT error code, remove existing cache entry.");
            this.removeTokenCacheItem(cachedItem, request.getResource());
        }
    }

    void updateTokenCache(AuthenticationRequest request, AuthenticationResult result) throws MalformedURLException, AuthenticationException, ClientException {
        if (result == null || StringExtensions.isNullOrBlank((String)result.getAccessToken())) {
            return;
        }
        if (!StringExtensions.isNullOrBlank((String)result.getAuthority()) && !result.getAuthority().equals(this.mAuthority)) {
            this.mAuthority = result.getAuthority();
        }
        if (this.mUseCommonCache && !UrlExtensions.isADFSAuthority(new URL(this.mAuthority))) {
            this.updateTokenCacheUsingCommonCache(request, result);
            return;
        }
        if (result.getUserInfo() != null) {
            if (!StringExtensions.isNullOrBlank((String)result.getUserInfo().getDisplayableId())) {
                this.setItemToCacheForUser(request.getResource(), request.getClientId(), result, result.getUserInfo().getDisplayableId());
            }
            if (!StringExtensions.isNullOrBlank((String)result.getUserInfo().getUserId())) {
                this.setItemToCacheForUser(request.getResource(), request.getClientId(), result, result.getUserInfo().getUserId());
            }
        }
        this.setItemToCacheForUser(request.getResource(), request.getClientId(), result, null);
    }

    void updateTokenCacheUsingCommonCache(AuthenticationRequest request, AuthenticationResult result) throws MalformedURLException, AuthenticationException, ClientException {
        AzureActiveDirectory ad = new AzureActiveDirectory();
        AzureActiveDirectoryTokenResponse tokenResponse = CoreAdapter.asAadTokenResponse(result);
        AzureActiveDirectoryOAuth2Configuration config = new AzureActiveDirectoryOAuth2Configuration();
        config.setAuthorityHostValidationEnabled(this.isValidateAuthorityHost());
        if (null != this.mAuthority) {
            config.setAuthorityUrl(new URL(this.mAuthority));
        }
        AzureActiveDirectoryOAuth2Strategy strategy = null;
        try {
            strategy = ad.createOAuth2Strategy(config, AndroidPlatformComponentsFactory.createFromContext((Context)this.mContext));
            AzureActiveDirectoryAuthorizationRequest.Builder aadAuthRequestBuilder = new AzureActiveDirectoryAuthorizationRequest.Builder();
            ((AzureActiveDirectoryAuthorizationRequest.Builder)((AzureActiveDirectoryAuthorizationRequest.Builder)((AzureActiveDirectoryAuthorizationRequest.Builder)((AzureActiveDirectoryAuthorizationRequest.Builder)aadAuthRequestBuilder.setClientId(request.getClientId())).setResource(request.getResource()).setScope(request.getResource())).setRedirectUri(request.getRedirectUri())).setLoginHint(request.getLoginHint())).setCorrelationId(request.getCorrelationId());
            if (null != this.mAuthority) {
                aadAuthRequestBuilder.setAuthority(new URL(this.mAuthority));
            }
            this.mCommonCache.save(strategy, aadAuthRequestBuilder.build(), tokenResponse);
        }
        catch (ClientException e) {
            throw ADALError.fromCommon((BaseException)e);
        }
    }

    void removeTokenCacheItem(TokenCacheItem tokenCacheItem, String resource) throws AuthenticationException {
        List<String> keys;
        String methodName = ":removeTokenCacheItem";
        CacheEvent cacheEvent = new CacheEvent("Microsoft.ADAL.token_cache_delete");
        cacheEvent.setRequestId(this.mTelemetryRequestId);
        Telemetry.getInstance().startEvent(this.mTelemetryRequestId, "Microsoft.ADAL.token_cache_delete");
        TokenEntryType tokenEntryType = tokenCacheItem.getTokenEntryType();
        switch (tokenEntryType) {
            case REGULAR_TOKEN_ENTRY: {
                cacheEvent.setTokenTypeRT(true);
                Logger.v(TAG + ":removeTokenCacheItem", "Regular RT was used to get access token, remove entries for regular RT entries.");
                keys = this.getKeyListToRemoveForRT(tokenCacheItem);
                break;
            }
            case MRRT_TOKEN_ENTRY: {
                cacheEvent.setTokenTypeMRRT(true);
                Logger.v(TAG + ":removeTokenCacheItem", "MRRT was used to get access token, remove entries for both MRRT entries and regular RT entries.");
                keys = this.getKeyListToRemoveForMRRTOrFRT(tokenCacheItem, false);
                TokenCacheItem regularRTItem = new TokenCacheItem(tokenCacheItem);
                regularRTItem.setResource(resource);
                keys.addAll(this.getKeyListToRemoveForRT(regularRTItem));
                break;
            }
            case FRT_TOKEN_ENTRY: {
                cacheEvent.setTokenTypeFRT(true);
                Logger.v(TAG + ":removeTokenCacheItem", "FRT was used to get access token, remove entries for FRT entries.");
                keys = this.getKeyListToRemoveForMRRTOrFRT(tokenCacheItem, true);
                break;
            }
            default: {
                throw new AuthenticationException(ADALError.INVALID_TOKEN_CACHE_ITEM);
            }
        }
        for (String key : keys) {
            this.mTokenCacheStore.removeItem(key);
        }
        Telemetry.getInstance().stopEvent(this.mTelemetryRequestId, cacheEvent, "Microsoft.ADAL.token_cache_delete");
    }

    boolean isMultipleRTsMatchingGivenAppAndResource(String clientId, String resource) {
        Iterator<TokenCacheItem> allItems = this.mTokenCacheStore.getAll();
        ArrayList<TokenCacheItem> regularRTsMatchingRequest = new ArrayList<TokenCacheItem>();
        while (allItems.hasNext()) {
            TokenCacheItem tokenCacheItem = allItems.next();
            if (!this.mAuthority.equalsIgnoreCase(tokenCacheItem.getAuthority()) || !clientId.equalsIgnoreCase(tokenCacheItem.getClientId()) || !resource.equalsIgnoreCase(tokenCacheItem.getResource()) || tokenCacheItem.getIsMultiResourceRefreshToken()) continue;
            regularRTsMatchingRequest.add(tokenCacheItem);
        }
        return regularRTsMatchingRequest.size() > 1;
    }

    boolean isMultipleMRRTsMatchingGivenApp(String clientId) {
        Iterator<TokenCacheItem> allItems = this.mTokenCacheStore.getAll();
        ArrayList<TokenCacheItem> mrrtsMatchingRequest = new ArrayList<TokenCacheItem>();
        while (allItems.hasNext()) {
            TokenCacheItem tokenCacheItem = allItems.next();
            if (!tokenCacheItem.getAuthority().equalsIgnoreCase(this.mAuthority) || !tokenCacheItem.getClientId().equalsIgnoreCase(clientId) || !tokenCacheItem.getIsMultiResourceRefreshToken() && !StringExtensions.isNullOrBlank((String)tokenCacheItem.getResource())) continue;
            mrrtsMatchingRequest.add(tokenCacheItem);
        }
        return mrrtsMatchingRequest.size() > 1;
    }

    private void setItemToCacheForUser(String resource, String clientId, AuthenticationResult result, String userId) throws MalformedURLException {
        String methodName = ":setItemToCacheForUser";
        this.logReturnedToken(result);
        Logger.v(TAG + ":setItemToCacheForUser", "Save regular token into cache.");
        CacheEvent cacheEvent = new CacheEvent("Microsoft.ADAL.token_cache_write");
        cacheEvent.setRequestId(this.mTelemetryRequestId);
        Telemetry.getInstance().startEvent(this.mTelemetryRequestId, "Microsoft.ADAL.token_cache_write");
        this.mTokenCacheStore.setItem(CacheKey.createCacheKeyForRTEntry((String)this.getAuthorityUrlWithPreferredCache(), (String)resource, (String)clientId, (String)userId), TokenCacheItem.createRegularTokenCacheItem(this.getAuthorityUrlWithPreferredCache(), resource, clientId, result));
        cacheEvent.setTokenTypeRT(true);
        if (result.getIsMultiResourceRefreshToken()) {
            Logger.v(TAG + ":setItemToCacheForUser", "Save Multi Resource Refresh token to cache.");
            this.mTokenCacheStore.setItem(CacheKey.createCacheKeyForMRRT((String)this.getAuthorityUrlWithPreferredCache(), (String)clientId, (String)userId), TokenCacheItem.createMRRTTokenCacheItem(this.getAuthorityUrlWithPreferredCache(), clientId, result));
            cacheEvent.setTokenTypeMRRT(true);
        }
        if (!StringExtensions.isNullOrBlank((String)result.getFamilyClientId()) && !StringExtensions.isNullOrBlank((String)userId)) {
            Logger.v(TAG + ":setItemToCacheForUser", "Save Family Refresh token into cache.");
            TokenCacheItem familyTokenCacheItem = TokenCacheItem.createFRRTTokenCacheItem(this.getAuthorityUrlWithPreferredCache(), result);
            this.mTokenCacheStore.setItem(CacheKey.createCacheKeyForFRT((String)this.getAuthorityUrlWithPreferredCache(), (String)result.getFamilyClientId(), (String)userId), familyTokenCacheItem);
            cacheEvent.setTokenTypeFRT(true);
        }
        Telemetry.getInstance().stopEvent(this.mTelemetryRequestId, cacheEvent, "Microsoft.ADAL.token_cache_write");
    }

    private List<String> getKeyListToRemoveForRT(TokenCacheItem cachedItem) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        try {
            String preferredAuthority = this.getAuthorityUrlWithPreferredCache();
            if (preferredAuthority != null) {
                this.addDeletionKeysForRTEntry(preferredAuthority, cachedItem, keysToRemove);
            }
        }
        catch (MalformedURLException exception) {
            com.microsoft.identity.common.internal.logging.Logger.error((String)TAG, (String)"Authority from preferred cache is invalid", null);
            com.microsoft.identity.common.internal.logging.Logger.errorPII((String)TAG, (String)"Failed with exception", (Throwable)exception);
        }
        this.addDeletionKeysForRTEntry(this.mAuthority, cachedItem, keysToRemove);
        if (!this.mAuthority.equalsIgnoreCase(cachedItem.getAuthority())) {
            this.addDeletionKeysForRTEntry(cachedItem.getAuthority(), cachedItem, keysToRemove);
        }
        return keysToRemove;
    }

    private List<String> getKeyListToRemoveForMRRTOrFRT(TokenCacheItem cachedItem, final boolean isFRT) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        KeyMakerStrategy keymaker = new KeyMakerStrategy(){

            @Override
            public boolean isFrt() {
                return isFRT;
            }

            @Override
            public String makeKey(String authority, String clientId, String userId) {
                if (isFRT) {
                    return CacheKey.createCacheKeyForFRT((String)authority, (String)clientId, (String)userId);
                }
                return CacheKey.createCacheKeyForMRRT((String)authority, (String)clientId, (String)userId);
            }
        };
        try {
            String preferredAuthority = this.getAuthorityUrlWithPreferredCache();
            if (preferredAuthority != null) {
                this.addDeletionKeysForMRRTOrFRTEntry(preferredAuthority, cachedItem, keysToRemove, keymaker);
            }
        }
        catch (MalformedURLException exception) {
            com.microsoft.identity.common.internal.logging.Logger.error((String)TAG, (String)"Authority from preferred cache is invalid", null);
            com.microsoft.identity.common.internal.logging.Logger.errorPII((String)TAG, (String)"Failed with exception", (Throwable)exception);
        }
        this.addDeletionKeysForMRRTOrFRTEntry(this.mAuthority, cachedItem, keysToRemove, keymaker);
        if (!this.mAuthority.equalsIgnoreCase(cachedItem.getAuthority())) {
            this.addDeletionKeysForMRRTOrFRTEntry(cachedItem.getAuthority(), cachedItem, keysToRemove, keymaker);
        }
        return keysToRemove;
    }

    private void addDeletionKeysForRTEntry(String authority, TokenCacheItem item, List<String> keys) {
        String resource = item.getResource();
        String clientId = item.getClientId();
        UserInfo userInfo = item.getUserInfo();
        keys.add(CacheKey.createCacheKeyForRTEntry((String)authority, (String)resource, (String)clientId, null));
        if (userInfo != null) {
            if (userInfo.getDisplayableId() != null) {
                keys.add(CacheKey.createCacheKeyForRTEntry((String)authority, (String)resource, (String)clientId, (String)userInfo.getDisplayableId()));
            }
            if (userInfo.getUserId() != null) {
                keys.add(CacheKey.createCacheKeyForRTEntry((String)authority, (String)resource, (String)clientId, (String)userInfo.getUserId()));
                if (item.getTenantId() != null) {
                    String uniqueId = this.getUniqueIdentifierForCacheKey(userInfo.getUserId(), item.getTenantId());
                    keys.add(CacheKey.createCacheKeyForRTEntry((String)authority, (String)resource, (String)clientId, (String)uniqueId));
                }
            }
        }
    }

    private void addDeletionKeysForMRRTOrFRTEntry(String authority, TokenCacheItem item, List<String> keys, KeyMakerStrategy strategy) {
        UserInfo userInfo = item.getUserInfo();
        String clientId = item.getClientId();
        if (strategy.isFrt()) {
            clientId = item.getFamilyClientId();
        }
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(null);
        if (userInfo != null) {
            if (userInfo.getDisplayableId() != null) {
                userIds.add(userInfo.getDisplayableId());
            }
            if (userInfo.getUserId() != null) {
                userIds.add(userInfo.getUserId());
                if (item.getTenantId() != null) {
                    userIds.add(this.getUniqueIdentifierForCacheKey(userInfo.getUserId(), item.getTenantId()));
                }
            }
        }
        for (String userId : userIds) {
            this.addDeletionKeyForMRRTOrFRTEntry(keys, item, authority, clientId, userId, strategy);
        }
    }

    private void addDeletionKeyForMRRTOrFRTEntry(List<String> keysToRemove, TokenCacheItem deletionTarget, String authority, String clientId, String userId, KeyMakerStrategy strategy) {
        try {
            String keyToAdd = strategy.makeKey(authority, clientId, userId);
            if (strategy.isFrt()) {
                this.addDeletionKeyForFRTIfRTValueIsStale(keysToRemove, deletionTarget, keyToAdd);
            } else {
                keysToRemove.add(keyToAdd);
            }
        }
        catch (Exception e) {
            Logger.w(TAG, "Exception encountered during key generation.\nCacheItem client_id: " + deletionTarget.getClientId() + "\nCacheItem family_id: " + deletionTarget.getFamilyClientId());
        }
    }

    private void addDeletionKeyForFRTIfRTValueIsStale(List<String> keysToRemove, TokenCacheItem deletionTarget, String deletionCandidateKey) {
        TokenCacheItem fociCacheItem = this.mTokenCacheStore.getItem(deletionCandidateKey);
        if (null != fociCacheItem && deletionTarget.getRefreshToken().equalsIgnoreCase(fociCacheItem.getRefreshToken())) {
            keysToRemove.add(deletionCandidateKey);
        }
    }

    private String getUniqueIdentifierForCacheKey(String userId, String tenantId) {
        return StringExtensions.base64UrlEncodeToString((String)userId) + "." + StringExtensions.base64UrlEncodeToString((String)tenantId);
    }

    private boolean isUserMisMatch(String user, TokenCacheItem tokenCacheItem) {
        if (StringExtensions.isNullOrBlank((String)user) || tokenCacheItem.getUserInfo() == null) {
            return false;
        }
        return !user.equalsIgnoreCase(tokenCacheItem.getUserInfo().getDisplayableId()) && !user.equalsIgnoreCase(tokenCacheItem.getUserInfo().getUserId());
    }

    private void throwIfMultipleATExisted(String clientId, String resource, String user) throws AuthenticationException {
        if (StringExtensions.isNullOrBlank((String)user) && this.isMultipleRTsMatchingGivenAppAndResource(clientId, resource)) {
            throw new AuthenticationException(ADALError.AUTH_FAILED_USER_MISMATCH, "No user is provided and multiple access tokens exist for the given app and resource.");
        }
    }

    private void logReturnedToken(AuthenticationResult result) {
        if (result != null && result.getAccessToken() != null) {
            Logger.i(TAG, "Access tokenID and refresh tokenID returned. ", null);
        }
    }

    private CacheEvent startCacheTelemetryRequest(String tokenType) {
        CacheEvent cacheEvent = new CacheEvent("Microsoft.ADAL.token_cache_lookup");
        cacheEvent.setTokenType(tokenType);
        cacheEvent.setRequestId(this.mTelemetryRequestId);
        Telemetry.getInstance().startEvent(this.mTelemetryRequestId, "Microsoft.ADAL.token_cache_lookup");
        return cacheEvent;
    }

    private TokenCacheItem performAdditionalCacheLookup(String resource, String clientid, String familyClientId, String user, TokenEntryType type) throws MalformedURLException {
        TokenCacheItem item = this.getTokenCacheItemFromPassedInAuthority(resource, clientid, familyClientId, user, type);
        if (item == null) {
            item = this.getTokenCacheItemFromAliasedHost(resource, clientid, familyClientId, user, type);
        }
        return item;
    }

    private TokenCacheItem getTokenCacheItemFromPassedInAuthority(String resource, String clientId, String familyClientId, String user, TokenEntryType type) throws MalformedURLException {
        if (this.getAuthorityUrlWithPreferredCache().equalsIgnoreCase(this.mAuthority)) {
            return null;
        }
        String cacheKeyWithPassedInAuthority = this.getCacheKey(this.mAuthority, resource, clientId, user, familyClientId, type);
        return this.mTokenCacheStore.getItem(cacheKeyWithPassedInAuthority);
    }

    private TokenCacheItem getTokenCacheItemFromAliasedHost(String resource, String clientId, String familyClientId, String user, TokenEntryType type) throws MalformedURLException {
        InstanceDiscoveryMetadata instanceDiscoveryMetadata = this.getInstanceDiscoveryMetadata();
        if (instanceDiscoveryMetadata == null) {
            return null;
        }
        TokenCacheItem tokenCacheItemForAliasedHost = null;
        List<String> aliasHosts = instanceDiscoveryMetadata.getAliases();
        for (String aliasHost : aliasHosts) {
            String cacheKeyForAliasedHost;
            TokenCacheItem item;
            String authority = this.constructAuthorityUrl(aliasHost);
            if (authority.equalsIgnoreCase(this.mAuthority) || authority.equalsIgnoreCase(this.getAuthorityUrlWithPreferredCache()) || (item = this.mTokenCacheStore.getItem(cacheKeyForAliasedHost = this.getCacheKey(authority, resource, clientId, user, familyClientId, type))) == null) continue;
            tokenCacheItemForAliasedHost = item;
            break;
        }
        return tokenCacheItemForAliasedHost;
    }

    private String getCacheKey(String authority, String resource, String clientId, String user, String familyClientId, TokenEntryType type) {
        String cacheKey;
        switch (type) {
            case REGULAR_TOKEN_ENTRY: {
                cacheKey = CacheKey.createCacheKeyForRTEntry((String)authority, (String)resource, (String)clientId, (String)user);
                break;
            }
            case MRRT_TOKEN_ENTRY: {
                cacheKey = CacheKey.createCacheKeyForMRRT((String)authority, (String)clientId, (String)user);
                break;
            }
            case FRT_TOKEN_ENTRY: {
                cacheKey = CacheKey.createCacheKeyForFRT((String)authority, (String)familyClientId, (String)user);
                break;
            }
            default: {
                return null;
            }
        }
        return cacheKey;
    }

    String getAuthorityUrlWithPreferredCache() throws MalformedURLException {
        InstanceDiscoveryMetadata instanceDiscoveryMetadata = this.getInstanceDiscoveryMetadata();
        if (instanceDiscoveryMetadata == null || !instanceDiscoveryMetadata.isValidated()) {
            return this.mAuthority;
        }
        String preferredLocation = instanceDiscoveryMetadata.getPreferredCache();
        return this.constructAuthorityUrl(preferredLocation);
    }

    private String constructAuthorityUrl(String host) throws MalformedURLException {
        URL passedInAuthority = new URL(this.mAuthority);
        if (passedInAuthority.getHost().equalsIgnoreCase(host)) {
            return this.mAuthority;
        }
        return Discovery.constructAuthorityUrl(passedInAuthority, host).toString();
    }

    private InstanceDiscoveryMetadata getInstanceDiscoveryMetadata() throws MalformedURLException {
        URL passedInAuthority = new URL(this.mAuthority);
        return AuthorityValidationMetadataCache.getCachedInstanceDiscoveryMetadata(passedInAuthority);
    }

    static interface KeyMakerStrategy {
        public boolean isFrt();

        public String makeKey(String var1, String var2, String var3);
    }
}

