/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.CacheKey;
import com.microsoft.aad.adal.ITokenCacheStore;
import com.microsoft.aad.adal.ITokenStoreQuery;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StorageHelper;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import com.microsoft.identity.common.java.adal.cache.DateTimeAdapter;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultTokenCacheStore
implements ITokenCacheStore,
ITokenStoreQuery {
    private static final long serialVersionUID = 1L;
    private static final String SHARED_PREFERENCE_NAME = "com.microsoft.aad.adal.cache";
    private static final String TAG = "DefaultTokenCacheStore";
    private SharedPreferencesFileManager mPrefs;
    private Context mContext;
    private Gson mGson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTimeAdapter()).create();
    @SuppressLint(value={"StaticFieldLeak"})
    private static StorageHelper sHelper;
    private static final Object LOCK;
    private static final int TOKEN_VALIDITY_WINDOW = 10;

    @SuppressLint(value={"WrongConstant"})
    public DefaultTokenCacheStore(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context is null");
        }
        this.mContext = context;
        if (!StringExtensions.isNullOrBlank((String)AuthenticationSettings.INSTANCE.getSharedPrefPackageName())) {
            try {
                this.mContext = context.createPackageContext(AuthenticationSettings.INSTANCE.getSharedPrefPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new IllegalArgumentException("Package name:" + AuthenticationSettings.INSTANCE.getSharedPrefPackageName() + " is not found");
            }
        }
        this.mPrefs = SharedPreferencesFileManager.getSharedPreferences((Context)this.mContext, (String)SHARED_PREFERENCE_NAME, null);
        this.validateSecretKeySetting();
    }

    Context getContext() {
        return this.mContext.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StorageHelper getStorageHelper() {
        Object object = LOCK;
        synchronized (object) {
            if (sHelper == null) {
                Logger.v(TAG, "Started to initialize storage helper");
                sHelper = new StorageHelper(this.mContext);
                Logger.v(TAG, "Finished to initialize storage helper");
            }
        }
        return sHelper;
    }

    private String encrypt(String value) {
        try {
            return this.getStorageHelper().encrypt(value);
        }
        catch (IOException | GeneralSecurityException e) {
            Logger.e(TAG, "Encryption failure. ", "", ADALError.ENCRYPTION_FAILED, e);
            return null;
        }
    }

    private String decrypt(String key, String value) {
        if (StringExtensions.isNullOrBlank((String)key)) {
            throw new IllegalArgumentException("key is null or blank");
        }
        try {
            return this.getStorageHelper().decrypt(value);
        }
        catch (IOException | GeneralSecurityException e) {
            Logger.e(TAG, "Decryption failure. ", "", ADALError.DECRYPTION_FAILED, e);
            this.removeItem(key);
            return null;
        }
    }

    @Override
    public TokenCacheItem getItem(String key) {
        String json;
        String decrypted;
        if (key == null) {
            throw new IllegalArgumentException("The key is null.");
        }
        if (this.mPrefs.contains(key) && (decrypted = this.decrypt(key, json = null != (json = this.mPrefs.getString(key)) ? json : "")) != null) {
            try {
                return (TokenCacheItem)this.mGson.fromJson(decrypted, TokenCacheItem.class);
            }
            catch (JsonSyntaxException exception) {
                Logger.e(TAG, "Fail to parse Json. ", exception.getMessage(), ADALError.ARGUMENT_EXCEPTION, exception);
            }
        }
        return null;
    }

    @Override
    public void removeItem(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        if (this.mPrefs.contains(key)) {
            this.mPrefs.remove(key);
        }
    }

    @Override
    public void setItem(String key, TokenCacheItem item) {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        if (item == null) {
            throw new IllegalArgumentException("item");
        }
        String json = this.mGson.toJson((Object)item);
        String encrypted = this.encrypt(json);
        if (encrypted != null) {
            this.mPrefs.putString(key, encrypted);
        } else {
            Logger.e(TAG, "Encrypted output is null. ", "", ADALError.ENCRYPTION_FAILED);
        }
    }

    @Override
    public void removeAll() {
        this.mPrefs.clear();
    }

    @Override
    public Iterator<TokenCacheItem> getAll() {
        Map results = this.mPrefs.getAll();
        ArrayList<TokenCacheItem> tokens = new ArrayList<TokenCacheItem>(results.values().size());
        for (Map.Entry tokenEntry : results.entrySet()) {
            String tokenValue;
            String tokenKey = (String)tokenEntry.getKey();
            String decryptedValue = this.decrypt(tokenKey, tokenValue = (String)tokenEntry.getValue());
            if (decryptedValue == null) continue;
            try {
                TokenCacheItem tokenCacheItem = (TokenCacheItem)this.mGson.fromJson(decryptedValue, TokenCacheItem.class);
                tokens.add(tokenCacheItem);
            }
            catch (JsonSyntaxException exception) {
                Logger.e(TAG, "Fail to parse Json. ", exception.getMessage(), ADALError.ARGUMENT_EXCEPTION, exception);
            }
        }
        return tokens.iterator();
    }

    @Override
    public Set<String> getUniqueUsersWithTokenCache() {
        Iterator<TokenCacheItem> results = this.getAll();
        HashSet<String> users = new HashSet<String>();
        while (results.hasNext()) {
            TokenCacheItem tokenCacheItem = results.next();
            if (tokenCacheItem.getUserInfo() == null || users.contains(tokenCacheItem.getUserInfo().getUserId())) continue;
            users.add(tokenCacheItem.getUserInfo().getUserId());
        }
        return users;
    }

    @Override
    public List<TokenCacheItem> getTokensForResource(String resource) {
        Iterator<TokenCacheItem> results = this.getAll();
        ArrayList<TokenCacheItem> tokenItems = new ArrayList<TokenCacheItem>();
        while (results.hasNext()) {
            TokenCacheItem tokenCacheItem = results.next();
            if (!resource.equals(tokenCacheItem.getResource())) continue;
            tokenItems.add(tokenCacheItem);
        }
        return tokenItems;
    }

    @Override
    public List<TokenCacheItem> getTokensForUser(String userId) {
        Iterator<TokenCacheItem> results = this.getAll();
        ArrayList<TokenCacheItem> tokenItems = new ArrayList<TokenCacheItem>();
        while (results.hasNext()) {
            TokenCacheItem tokenCacheItem = results.next();
            if (tokenCacheItem.getUserInfo() == null || !tokenCacheItem.getUserInfo().getUserId().equalsIgnoreCase(userId)) continue;
            tokenItems.add(tokenCacheItem);
        }
        return tokenItems;
    }

    @Override
    public void clearTokensForUser(String userId) {
        List<TokenCacheItem> results = this.getTokensForUser(userId);
        for (TokenCacheItem item : results) {
            if (item.getUserInfo() == null || item.getUserInfo().getUserId() == null || !item.getUserInfo().getUserId().equalsIgnoreCase(userId)) continue;
            try {
                this.removeItem(CacheKey.createCacheKey(item));
            }
            catch (AuthenticationException exception) {
                Logger.e(TAG, "Fail to create cache key. ", "", exception.getCode(), exception);
            }
        }
    }

    @Override
    public List<TokenCacheItem> getTokensAboutToExpire() {
        Iterator<TokenCacheItem> results = this.getAll();
        ArrayList<TokenCacheItem> tokenItems = new ArrayList<TokenCacheItem>();
        while (results.hasNext()) {
            TokenCacheItem tokenCacheItem = results.next();
            if (!this.isAboutToExpire(tokenCacheItem.getExpiresOn())) continue;
            tokenItems.add(tokenCacheItem);
        }
        return tokenItems;
    }

    private void validateSecretKeySetting() {
        byte[] secretKeyData = AuthenticationSettings.INSTANCE.getSecretKeyData();
        if (secretKeyData == null && Build.VERSION.SDK_INT < 18) {
            throw new IllegalArgumentException("Secret key must be provided for API < 18. Use AuthenticationSettings.INSTANCE.setSecretKey()");
        }
    }

    private boolean isAboutToExpire(Date expires) {
        Date validity = DefaultTokenCacheStore.getTokenValidityTime().getTime();
        return expires != null && expires.before(validity);
    }

    private static Calendar getTokenValidityTime() {
        Calendar timeAhead = Calendar.getInstance();
        timeAhead.add(13, 10);
        return timeAhead;
    }

    @Override
    public boolean contains(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        return this.mPrefs.contains(key);
    }

    static {
        LOCK = new Object();
    }
}

