/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationServerProtocolException;
import com.microsoft.aad.adal.Logger;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.java.util.JWSBuilder;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class ChallengeResponseBuilder {
    private static final String TAG = "ChallengeResponseBuilder";
    private final JWSBuilder mJWSBuilder;

    ChallengeResponseBuilder(JWSBuilder jwsBuilder) {
        this.mJWSBuilder = jwsBuilder;
    }

    public ChallengeResponse getChallengeResponseFromUri(String redirectUri) throws AuthenticationException {
        ChallengeRequest request = this.getChallengeRequest(redirectUri);
        return this.getDeviceCertResponse(request);
    }

    public ChallengeResponse getChallengeResponseFromHeader(String challengeHeaderValue, String endpoint) throws UnsupportedEncodingException, AuthenticationException {
        ChallengeRequest request = this.getChallengeRequestFromHeader(challengeHeaderValue);
        request.mSubmitUrl = endpoint;
        return this.getDeviceCertResponse(request);
    }

    private ChallengeResponse getDeviceCertResponse(ChallengeRequest request) throws AuthenticationException {
        return this.getNoDeviceCertResponse(request);
    }

    private boolean isWorkplaceJoined() {
        return false;
    }

    private ChallengeResponse getNoDeviceCertResponse(ChallengeRequest request) {
        ChallengeResponse response = new ChallengeResponse();
        response.mSubmitUrl = request.mSubmitUrl;
        response.mAuthorizationHeaderValue = String.format("%s Context=\"%s\",Version=\"%s\"", "PKeyAuth", request.mContext, request.mVersion);
        return response;
    }

    private ChallengeRequest getChallengeRequestFromHeader(String headerValue) throws UnsupportedEncodingException, AuthenticationException {
        String methodName = ":getChallengeRequestFromHeader";
        if (StringExtensions.isNullOrBlank((String)headerValue)) {
            throw new AuthenticationServerProtocolException("headerValue");
        }
        if (!StringExtensions.hasPrefixInHeader((String)headerValue, (String)"PKeyAuth")) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, headerValue);
        }
        ChallengeRequest challenge = new ChallengeRequest();
        String authenticateHeader = headerValue.substring("PKeyAuth".length());
        ArrayList queryPairs = StringExtensions.splitWithQuotes((String)authenticateHeader, (char)',');
        HashMap<String, String> headerItems = new HashMap<String, String>();
        for (String queryPair : queryPairs) {
            ArrayList pair = StringExtensions.splitWithQuotes((String)queryPair, (char)'=');
            if (pair.size() == 2 && !StringExtensions.isNullOrBlank((String)((String)pair.get(0))) && !StringExtensions.isNullOrBlank((String)((String)pair.get(1)))) {
                String key = (String)pair.get(0);
                String value = (String)pair.get(1);
                key = StringExtensions.urlFormDecode((String)key);
                value = StringExtensions.urlFormDecode((String)value);
                key = key.trim();
                value = StringExtensions.removeQuoteInHeaderValue((String)value.trim());
                headerItems.put(key, value);
                continue;
            }
            if (pair.size() == 1 && !StringExtensions.isNullOrBlank((String)((String)pair.get(0)))) {
                headerItems.put(StringExtensions.urlFormDecode((String)((String)pair.get(0))).trim(), StringExtensions.urlFormDecode((String)""));
                continue;
            }
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, authenticateHeader);
        }
        this.validateChallengeRequest(headerItems, false);
        challenge.mNonce = (String)headerItems.get(RequestField.Nonce.name());
        if (StringExtensions.isNullOrBlank((String)challenge.mNonce)) {
            challenge.mNonce = (String)headerItems.get(RequestField.Nonce.name().toLowerCase(Locale.US));
        }
        if (!this.isWorkplaceJoined()) {
            Logger.v("ChallengeResponseBuilder:getChallengeRequestFromHeader", "Device is not workplace joined. ");
        } else if (!StringExtensions.isNullOrBlank((String)((String)headerItems.get(RequestField.CertThumbprint.name())))) {
            Logger.v("ChallengeResponseBuilder:getChallengeRequestFromHeader", "CertThumbprint exists in the device auth challenge.");
            challenge.mThumbprint = (String)headerItems.get(RequestField.CertThumbprint.name());
        } else if (headerItems.containsKey(RequestField.CertAuthorities.name())) {
            Logger.v("ChallengeResponseBuilder:getChallengeRequestFromHeader", "CertAuthorities exists in the device auth challenge.");
            String authorities = (String)headerItems.get(RequestField.CertAuthorities.name());
            challenge.mCertAuthorities = StringExtensions.getStringTokens((String)authorities, (String)";");
        } else {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "Both certThumbprint and certauthorities are not present");
        }
        challenge.mVersion = (String)headerItems.get(RequestField.Version.name());
        challenge.mContext = (String)headerItems.get(RequestField.Context.name());
        return challenge;
    }

    private void validateChallengeRequest(Map<String, String> headerItems, boolean redirectFormat) throws AuthenticationException {
        if (!headerItems.containsKey(RequestField.Nonce.name()) && !headerItems.containsKey(RequestField.Nonce.name().toLowerCase(Locale.US))) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "Nonce");
        }
        if (!headerItems.containsKey(RequestField.Version.name())) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "Version");
        }
        if (redirectFormat && !headerItems.containsKey(RequestField.SubmitUrl.name())) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "SubmitUrl");
        }
        if (!headerItems.containsKey(RequestField.Context.name())) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "Context");
        }
        if (redirectFormat && !headerItems.containsKey(RequestField.CertAuthorities.name())) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "CertAuthorities");
        }
    }

    private ChallengeRequest getChallengeRequest(String redirectUri) throws AuthenticationException {
        String methodName = ":getChallengeRequest";
        if (StringExtensions.isNullOrBlank((String)redirectUri)) {
            throw new AuthenticationServerProtocolException("redirectUri");
        }
        ChallengeRequest challenge = new ChallengeRequest();
        HashMap parameters = StringExtensions.getUrlParameters((String)redirectUri);
        this.validateChallengeRequest(parameters, true);
        challenge.mNonce = (String)parameters.get(RequestField.Nonce.name());
        if (StringExtensions.isNullOrBlank((String)challenge.mNonce)) {
            challenge.mNonce = (String)parameters.get(RequestField.Nonce.name().toLowerCase(Locale.US));
        }
        String authorities = (String)parameters.get(RequestField.CertAuthorities.name());
        Logger.v("ChallengeResponseBuilder:getChallengeRequest", "Get cert authorities. ", "Authorities: " + authorities, null);
        challenge.mCertAuthorities = StringExtensions.getStringTokens((String)authorities, (String)";");
        challenge.mVersion = (String)parameters.get(RequestField.Version.name());
        challenge.mSubmitUrl = (String)parameters.get(RequestField.SubmitUrl.name());
        challenge.mContext = (String)parameters.get(RequestField.Context.name());
        return challenge;
    }

    class ChallengeRequest {
        private String mNonce = "";
        private String mContext = "";
        private List<String> mCertAuthorities;
        private String mThumbprint = "";
        private String mVersion = null;
        private String mSubmitUrl = "";

        ChallengeRequest() {
        }
    }

    static enum RequestField {
        Nonce,
        CertAuthorities,
        Version,
        SubmitUrl,
        Context,
        CertThumbprint;

    }

    class ChallengeResponse {
        private String mSubmitUrl;
        private String mAuthorizationHeaderValue;

        ChallengeResponse() {
        }

        String getSubmitUrl() {
            return this.mSubmitUrl;
        }

        void setSubmitUrl(String submitUrl) {
            this.mSubmitUrl = submitUrl;
        }

        String getAuthorizationHeaderValue() {
            return this.mAuthorizationHeaderValue;
        }

        void setAuthorizationHeaderValue(String authorizationHeaderValue) {
            this.mAuthorizationHeaderValue = authorizationHeaderValue;
        }
    }
}

