/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.net.Uri;
import android.util.Base64;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.HashMapExtensions;
import com.microsoft.aad.adal.Logger;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;

final class StringExtensions {
    public static final String ENCODING_UTF8 = "UTF_8";
    private static final String TAG = "StringExtensions";
    private static final String TOKEN_HASH_ALGORITHM = "SHA256";

    StringExtensions() {
    }

    static boolean IsNullOrBlank(String param) {
        return param == null || param.trim().length() == 0;
    }

    public static String createHash(String msg) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (!StringExtensions.IsNullOrBlank(msg)) {
            MessageDigest digester = MessageDigest.getInstance(TOKEN_HASH_ALGORITHM);
            byte[] msgInBytes = msg.getBytes(ENCODING_UTF8);
            String hash = new String(Base64.encode((byte[])digester.digest(msgInBytes), (int)2), ENCODING_UTF8);
            return hash;
        }
        return msg;
    }

    static final String URLFormEncode(String source) throws UnsupportedEncodingException {
        return URLEncoder.encode(source, ENCODING_UTF8);
    }

    static final String URLFormDecode(String source) throws UnsupportedEncodingException {
        return URLDecoder.decode(source, ENCODING_UTF8);
    }

    static final String encodeBase64URLSafeString(byte[] bytes) throws UnsupportedEncodingException {
        return new String(Base64.encode((byte[])bytes, (int)11), ENCODING_UTF8);
    }

    static final URL getUrl(String endpoint) {
        URL authority = null;
        try {
            authority = new URL(endpoint);
        }
        catch (MalformedURLException e1) {
            Logger.e(TAG, e1.getMessage(), "", ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL, e1);
        }
        return authority;
    }

    static final HashMap<String, String> getUrlParameters(String finalUrl) {
        Uri response = Uri.parse((String)finalUrl);
        String queryParameters = response.getEncodedQuery();
        HashMap<String, String> parameters = HashMapExtensions.URLFormDecode(queryParameters);
        return parameters;
    }

    static final List<String> getStringTokens(String items, String delimeter) {
        StringTokenizer st = new StringTokenizer(items, delimeter);
        ArrayList<String> itemList = new ArrayList<String>();
        if (st.hasMoreTokens()) {
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                if (StringExtensions.IsNullOrBlank(name)) continue;
                itemList.add(name);
            }
        }
        return itemList;
    }

    static ArrayList<String> splitWithQuotes(String input, char delimiter) {
        String item;
        ArrayList<String> items = new ArrayList<String>();
        int startIndex = 0;
        boolean insideString = false;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == delimiter && !insideString) {
                item = input.substring(startIndex, i);
                if (!StringExtensions.IsNullOrBlank(item.trim())) {
                    items.add(item);
                }
                startIndex = i + 1;
                continue;
            }
            if (input.charAt(i) != '\"') continue;
            insideString = !insideString;
        }
        item = input.substring(startIndex);
        if (!StringExtensions.IsNullOrBlank(item.trim())) {
            items.add(item);
        }
        return items;
    }

    static String removeQuoteInHeaderValue(String value) {
        if (!StringExtensions.IsNullOrBlank(value)) {
            return value.replace("\"", "");
        }
        return null;
    }

    static boolean hasPrefixInHeader(String value, String prefix) {
        return value.startsWith(prefix) && value.length() > prefix.length() + 2 && Character.isWhitespace(value.charAt(prefix.length()));
    }

    static Set<String> createSet(String[] items) {
        HashSet<String> scopes = new HashSet<String>();
        if (items != null && items.length != 0) {
            for (String item : items) {
                scopes.add(item.toLowerCase(Locale.US));
            }
        }
        return scopes;
    }

    static Set<String> createSet(String[] items, String[] items2) {
        HashSet<String> scopes = new HashSet<String>();
        if (items != null && items.length != 0) {
            for (String item : items) {
                if (StringExtensions.IsNullOrBlank(item)) continue;
                scopes.add(item);
            }
        }
        if (items2 != null && items2.length != 0) {
            for (String item : items2) {
                if (StringExtensions.IsNullOrBlank(item)) continue;
                scopes.add(item);
            }
        }
        return scopes;
    }

    static String createStringFromArray(String[] items, String delimiter) {
        if (items == null || items.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(items[0]);
        for (int i = 1; i < items.length; ++i) {
            sb.append(delimiter);
            sb.append(items[i]);
        }
        return sb.toString();
    }

    static String[] createArrayFromString(String itemDelimited, String delimiter) {
        if (StringExtensions.IsNullOrBlank(itemDelimited)) {
            return new String[0];
        }
        return itemDelimited.split(delimiter);
    }
}

