/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.accounts.AccountAuthenticatorResponse;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.BasicWebViewClient;
import com.microsoft.aad.adal.ExceptionExtensions;
import com.microsoft.aad.adal.IJWSBuilder;
import com.microsoft.aad.adal.IWebRequestHandler;
import com.microsoft.aad.adal.JWSBuilder;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.Oauth2;
import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.UserIdentifier;
import com.microsoft.aad.adal.WebRequestHandler;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.UUID;

@SuppressLint(value={"SetJavaScriptEnabled", "ClickableViewAccessibility"})
public class AuthenticationActivity
extends Activity {
    static final int BACK_PRESSED_CANCEL_DIALOG_STEPS = -2;
    private static final String TAG = "AuthenticationActivity";
    private boolean mRegisterReceiver = false;
    private WebView mWebView;
    private String mStartUrl;
    private ProgressDialog mSpinner;
    private String mRedirectUrl;
    private AuthenticationRequest mAuthRequest;
    private ActivityBroadcastReceiver mReceiver = null;
    private String mCallingPackage;
    private int mWaitingRequestId;
    private int mCallingUID;
    private AccountAuthenticatorResponse mAccountAuthenticatorResponse = null;
    private Bundle mAuthenticatorResultBundle = null;
    private IWebRequestHandler mWebRequestHandler = new WebRequestHandler();
    private IJWSBuilder mJWSBuilder = new JWSBuilder();
    private String mQueryParameters;
    private boolean mPkeyAuthRedirect = false;

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.getResources().getIdentifier("activity_authentication", "layout", this.getPackageName()));
        CookieSyncManager.createInstance((Context)this.getApplicationContext());
        CookieSyncManager.getInstance().sync();
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        this.mAuthRequest = this.getAuthenticationRequestFromIntent(this.getIntent());
        if (this.mAuthRequest == null) {
            Log.d((String)TAG, (String)"Request item is null, so it returns to caller");
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Invalid request");
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", "Intent does not have request details");
            this.returnToCaller(2002, resultIntent);
            return;
        }
        if (this.mAuthRequest.getAuthority() == null || this.mAuthRequest.getAuthority().isEmpty()) {
            this.returnError(ADALError.ARGUMENT_EXCEPTION, "account.authority");
            return;
        }
        if (this.mAuthRequest.getScope() == null || this.mAuthRequest.getScope().length == 0) {
            this.returnError(ADALError.ARGUMENT_EXCEPTION, "account.scope");
            return;
        }
        if (this.mAuthRequest.getClientId() == null || this.mAuthRequest.getClientId().isEmpty()) {
            this.returnError(ADALError.ARGUMENT_EXCEPTION, "account.clientid.key");
            return;
        }
        if (this.mAuthRequest.getRedirectUri() == null || this.mAuthRequest.getRedirectUri().isEmpty()) {
            this.returnError(ADALError.ARGUMENT_EXCEPTION, "account.redirect");
            return;
        }
        this.mRedirectUrl = this.mAuthRequest.getRedirectUri();
        Logger.v(TAG, "OnCreate redirectUrl:" + this.mRedirectUrl);
        this.mWebView = (WebView)this.findViewById(this.getResources().getIdentifier("webView1", "id", this.getPackageName()));
        Logger.v(TAG, "User agent:" + this.mWebView.getSettings().getUserAgentString());
        this.mStartUrl = "about:blank";
        try {
            Oauth2 oauth = new Oauth2(this.mAuthRequest);
            this.mStartUrl = oauth.getCodeRequestUrl();
            this.mQueryParameters = oauth.getAuthorizationEndpointQueryParameters();
        }
        catch (UnsupportedEncodingException e) {
            Log.d((String)TAG, (String)e.getMessage());
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mAuthRequest);
            this.returnToCaller(2002, resultIntent);
            return;
        }
        Logger.v(TAG, "Init broadcastReceiver with requestId:" + this.mAuthRequest.getRequestId() + " " + this.mAuthRequest.getLogInfo());
        this.mReceiver = new ActivityBroadcastReceiver();
        this.mReceiver.mWaitingRequestId = this.mAuthRequest.getRequestId();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.mReceiver, new IntentFilter("com.microsoft.aad.adal:BrowserCancel"));
        String userAgent = this.mWebView.getSettings().getUserAgentString();
        this.mWebView.getSettings().setUserAgentString(userAgent + " PKeyAuth/1.0");
        userAgent = this.mWebView.getSettings().getUserAgentString();
        Logger.v(TAG, "UserAgent:" + userAgent);
        this.mRegisterReceiver = false;
        final String postUrl = this.mStartUrl;
        Logger.i(TAG, "OnCreate startUrl:" + this.mStartUrl + " calling package:" + this.mCallingPackage, " device:" + Build.VERSION.RELEASE + " " + Build.MANUFACTURER + Build.MODEL);
        this.setupWebView(this.mRedirectUrl, this.mQueryParameters, this.mAuthRequest);
        if (savedInstanceState == null) {
            this.mWebView.post(new Runnable(){

                @Override
                public void run() {
                    AuthenticationActivity.this.mWebView.loadUrl("about:blank");
                    AuthenticationActivity.this.mWebView.loadUrl(postUrl);
                }
            });
        } else {
            Logger.v(TAG, "Reuse webview");
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mWebView.saveState(outState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.mWebView.restoreState(savedInstanceState);
    }

    private void setupWebView(String redirect, String queryParam, AuthenticationRequest request) {
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.requestFocus(130);
        this.mWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                int action = event.getAction();
                if (!(action != 0 && action != 1 || view.hasFocus())) {
                    view.requestFocus();
                }
                return false;
            }
        });
        this.mWebView.getSettings().setLoadWithOverviewMode(true);
        this.mWebView.getSettings().setDomStorageEnabled(true);
        this.mWebView.getSettings().setUseWideViewPort(true);
        this.mWebView.getSettings().setBuiltInZoomControls(true);
        this.mWebView.setWebViewClient((WebViewClient)new CustomWebViewClient());
        this.mWebView.setVisibility(4);
    }

    private AuthenticationRequest getAuthenticationRequestFromIntent(Intent callingIntent) {
        AuthenticationRequest authRequest = null;
        if (this.isBrokerRequest(callingIntent)) {
            Logger.v(TAG, "It is a broker request. Get request info from bundle extras.");
            String authority = callingIntent.getStringExtra("account.authority");
            String[] scope = callingIntent.getStringArrayExtra("account.scope");
            String[] additionalScope = callingIntent.getStringArrayExtra("account.additional.scope");
            String redirect = callingIntent.getStringExtra("account.redirect");
            String loginhint = callingIntent.getStringExtra("account.login.hint");
            String accountName = callingIntent.getStringExtra("account.name");
            String clientidKey = callingIntent.getStringExtra("account.clientid.key");
            String correlationId = callingIntent.getStringExtra("account.correlationid");
            String prompt = callingIntent.getStringExtra("account.prompt");
            UserIdentifier userId = UserIdentifier.createFromIntent(callingIntent);
            PromptBehavior promptBehavior = PromptBehavior.Auto;
            if (!StringExtensions.IsNullOrBlank(prompt)) {
                promptBehavior = PromptBehavior.valueOf(prompt);
            }
            this.mWaitingRequestId = callingIntent.getIntExtra("com.microsoft.aad.adal:RequestId", 0);
            UUID correlationIdParsed = null;
            if (!StringExtensions.IsNullOrBlank(correlationId)) {
                try {
                    correlationIdParsed = UUID.fromString(correlationId);
                }
                catch (IllegalArgumentException ex) {
                    correlationIdParsed = null;
                    Logger.e(TAG, "CorrelationId is malformed: " + correlationId, "", ADALError.CORRELATION_ID_FORMAT);
                }
            }
            authRequest = new AuthenticationRequest(authority, scope, clientidKey, redirect, userId, promptBehavior, "", correlationIdParsed);
            authRequest.setBrokerAccountName(accountName);
            authRequest.setPrompt(promptBehavior);
            authRequest.setAdditionalScope(additionalScope);
            authRequest.setRequestId(this.mWaitingRequestId);
        } else {
            Serializable request = callingIntent.getSerializableExtra("com.microsoft.aad.adal:BrowserRequestMessage");
            if (request instanceof AuthenticationRequest) {
                authRequest = (AuthenticationRequest)request;
            }
        }
        return authRequest;
    }

    private void returnError(ADALError errorCode, String argument) {
        Log.w((String)TAG, (String)("Argument error:" + argument));
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", errorCode.name());
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", argument);
        if (this.mAuthRequest != null) {
            resultIntent.putExtra("com.microsoft.aad.adal:RequestId", this.mWaitingRequestId);
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mAuthRequest);
        }
        this.setResult(2002, resultIntent);
        this.finish();
    }

    private void returnAuthenticationException(AuthenticationException e) {
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:AuthenticationException", (Serializable)e);
        if (this.mAuthRequest != null) {
            resultIntent.putExtra("com.microsoft.aad.adal:RequestId", this.mWaitingRequestId);
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mAuthRequest);
        }
        this.setResult(2005, resultIntent);
        this.finish();
    }

    private String getBrokerStartUrl(String loadUrl, String packageName, String signatureDigest) {
        if (!StringExtensions.IsNullOrBlank(packageName) && !StringExtensions.IsNullOrBlank(signatureDigest)) {
            try {
                return loadUrl + "&package_name=" + URLEncoder.encode(packageName, "UTF_8") + "&signature=" + URLEncoder.encode(signatureDigest, "UTF_8");
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)TAG, (String)"Encoding", (Throwable)e);
            }
        }
        return loadUrl;
    }

    private boolean isBrokerRequest(Intent callingIntent) {
        Logger.v(TAG, "Packagename:" + this.getPackageName() + " Broker packagename:" + AuthenticationSettings.INSTANCE.getBrokerPackageName() + " Calling packagename:" + this.getCallingPackage());
        return callingIntent != null && !StringExtensions.IsNullOrBlank(callingIntent.getStringExtra("com.microsoft.aadbroker.adal.broker.request"));
    }

    private void returnToCaller(int resultCode, Intent data) {
        Logger.v(TAG, "Return To Caller:" + resultCode);
        this.displaySpinner(false);
        if (data == null) {
            data = new Intent();
        }
        if (this.mAuthRequest != null) {
            Logger.v(TAG, "Return To Caller REQUEST_ID:" + this.mAuthRequest.getRequestId());
            data.putExtra("com.microsoft.aad.adal:RequestId", this.mAuthRequest.getRequestId());
        } else {
            Logger.w(TAG, "Request object is null", "", ADALError.ACTIVITY_REQUEST_INTENT_DATA_IS_NULL);
        }
        this.setResult(resultCode, data);
        this.finish();
    }

    protected void onPause() {
        Logger.v(TAG, "AuthenticationActivity onPause unregister receiver");
        super.onPause();
        if (this.mReceiver != null) {
            LocalBroadcastManager.getInstance((Context)this).unregisterReceiver((BroadcastReceiver)this.mReceiver);
        }
        this.mRegisterReceiver = true;
        if (this.mSpinner != null) {
            Logger.v(TAG, "Spinner at onPause will dismiss");
            this.mSpinner.dismiss();
        }
    }

    protected void onResume() {
        super.onResume();
        Logger.v(TAG, "onResume");
        if (this.mRegisterReceiver) {
            Logger.v(TAG, "Webview onResume will register receiver:" + this.mStartUrl);
            if (this.mReceiver != null) {
                Logger.v(TAG, "Webview onResume register broadcast receiver for requestId" + this.mReceiver.mWaitingRequestId);
                LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.mReceiver, new IntentFilter("com.microsoft.aad.adal:BrowserCancel"));
            }
        }
        this.mRegisterReceiver = false;
        this.mSpinner = new ProgressDialog((Context)this);
        this.mSpinner.requestWindowFeature(1);
        this.mSpinner.setMessage(this.getText(this.getResources().getIdentifier("app_loading", "string", this.getPackageName())));
    }

    protected void onRestart() {
        Logger.v(TAG, "AuthenticationActivity onRestart");
        super.onRestart();
        this.mRegisterReceiver = true;
    }

    public void onBackPressed() {
        Logger.v(TAG, "Back button is pressed");
        if (this.mPkeyAuthRedirect || !this.mWebView.canGoBackOrForward(-2)) {
            this.cancelRequest();
        } else {
            this.mWebView.goBack();
        }
    }

    private void cancelRequest() {
        Logger.v(TAG, "Sending intent to cancel authentication activity");
        Intent resultIntent = new Intent();
        this.returnToCaller(2001, resultIntent);
    }

    private void displaySpinner(boolean show) {
        if (!this.isFinishing() && !this.isChangingConfigurations() && this.mSpinner != null) {
            Logger.v(TAG, "displaySpinner:" + show + " showing:" + this.mSpinner.isShowing());
            if (show && !this.mSpinner.isShowing()) {
                this.mSpinner.show();
            }
            if (!show && this.mSpinner.isShowing()) {
                this.mSpinner.dismiss();
            }
        }
    }

    private void displaySpinnerWithMessage(CharSequence charSequence) {
        if (!this.isFinishing() && this.mSpinner != null) {
            this.mSpinner.show();
            this.mSpinner.setMessage(charSequence);
        }
    }

    private void returnResult(int resultcode, Intent intent) {
        this.setAccountAuthenticatorResult(intent.getExtras());
        this.setResult(resultcode, intent);
        this.finish();
    }

    public void finish() {
        if (this.isBrokerRequest(this.getIntent()) && this.mAccountAuthenticatorResponse != null) {
            Logger.v(TAG, "It is a broker request");
            if (this.mAuthenticatorResultBundle != null) {
                this.mAccountAuthenticatorResponse.onResult(this.mAuthenticatorResultBundle);
            } else {
                this.mAccountAuthenticatorResponse.onError(4, "canceled");
            }
            this.mAccountAuthenticatorResponse = null;
        }
        super.finish();
    }

    private final void setAccountAuthenticatorResult(Bundle result) {
        this.mAuthenticatorResultBundle = result;
    }

    class CustomWebViewClient
    extends BasicWebViewClient {
        public CustomWebViewClient() {
            super((Context)AuthenticationActivity.this, AuthenticationActivity.this.mRedirectUrl, AuthenticationActivity.this.mQueryParameters, AuthenticationActivity.this.mAuthRequest);
        }

        @Override
        public void processRedirectUrl(WebView view, String url) {
            Logger.i(AuthenticationActivity.TAG, "It is not a broker request", "");
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserFinalUrl", url);
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)AuthenticationActivity.this.mAuthRequest);
            AuthenticationActivity.this.returnToCaller(2003, resultIntent);
            view.stopLoading();
        }

        @Override
        public boolean processInvalidUrl(WebView view, String url) {
            if (AuthenticationActivity.this.isBrokerRequest(AuthenticationActivity.this.getIntent()) && url.startsWith("msauth")) {
                AuthenticationActivity.this.returnError(ADALError.DEVELOPER_REDIRECTURI_INVALID, String.format("The RedirectUri is not as expected. Received %s and expected %s", url, AuthenticationActivity.this.mRedirectUrl));
                view.stopLoading();
                return true;
            }
            return false;
        }

        @Override
        public void showSpinner(boolean status) {
            AuthenticationActivity.this.displaySpinner(status);
        }

        @Override
        public void sendResponse(int returnCode, Intent responseIntent) {
            AuthenticationActivity.this.returnToCaller(returnCode, responseIntent);
        }

        @Override
        public void cancelWebViewRequest() {
            AuthenticationActivity.this.cancelRequest();
        }

        @Override
        public void setPKeyAuthStatus(boolean status) {
            AuthenticationActivity.this.mPkeyAuthRedirect = status;
        }

        @Override
        public void postRunnable(Runnable item) {
            AuthenticationActivity.this.mWebView.post(item);
        }
    }

    private class ActivityBroadcastReceiver
    extends BroadcastReceiver {
        private int mWaitingRequestId = -1;

        private ActivityBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Logger.v(AuthenticationActivity.TAG, "ActivityBroadcastReceiver onReceive");
            if (intent.getAction().equalsIgnoreCase("com.microsoft.aad.adal:BrowserCancel")) {
                try {
                    Logger.v(AuthenticationActivity.TAG, "ActivityBroadcastReceiver onReceive action is for cancelling Authentication Activity");
                    int cancelRequestId = intent.getIntExtra("com.microsoft.aad.adal:RequestId", 0);
                    if (cancelRequestId == this.mWaitingRequestId) {
                        Logger.v(AuthenticationActivity.TAG, "Waiting requestId is same and cancelling this activity");
                        AuthenticationActivity.this.finish();
                    }
                }
                catch (Exception ex) {
                    Logger.e(AuthenticationActivity.TAG, "ActivityBroadcastReceiver onReceive exception", ExceptionExtensions.getExceptionMessage(ex), ADALError.BROADCAST_RECEIVER_ERROR);
                }
            }
        }
    }
}

