/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Intent;
import android.text.TextUtils;
import java.io.Serializable;

public class UserIdentifier
implements Serializable {
    private static final long serialVersionUID = 5739521222033787270L;
    private String mId;
    private UserIdentifierType mType;
    private static final String AnyUserId = "AnyUser";
    private static final UserIdentifier AnyUser = new UserIdentifier("AnyUser", UserIdentifierType.UniqueId);

    public UserIdentifier(String id2, UserIdentifierType userType) {
        this.mId = id2;
        this.mType = userType;
    }

    public String getId() {
        return this.mId;
    }

    public UserIdentifierType getType() {
        return this.mType;
    }

    public static UserIdentifier getAnyUser() {
        return AnyUser;
    }

    boolean anyUser() {
        if (this.mType == null || this.mId == null) {
            return false;
        }
        return this.mType.equals((Object)UserIdentifier.AnyUser.mType) && this.mId.equalsIgnoreCase(AnyUserId);
    }

    String getUniqueId() {
        return !this.anyUser() && this.mType.equals((Object)UserIdentifierType.UniqueId) ? this.mId : "";
    }

    String getDisplayableId() {
        return !this.anyUser() && (this.mType.equals((Object)UserIdentifierType.RequiredDisplayableId) || this.mType.equals((Object)UserIdentifierType.OptionalDisplayableId)) ? this.mId : "";
    }

    public static UserIdentifier createFromIntent(Intent callingIntent) {
        UserIdentifier userid = new UserIdentifier("", UserIdentifierType.OptionalDisplayableId);
        if (callingIntent != null && callingIntent.hasExtra("account.userid.type")) {
            String idType = callingIntent.getStringExtra("account.userid.type");
            userid.mId = callingIntent.getStringExtra("account.userid.id");
            if (!TextUtils.isEmpty((CharSequence)idType)) {
                userid.mType = UserIdentifierType.valueOf(idType);
            }
        }
        return userid;
    }

    public static enum UserIdentifierType {
        UniqueId,
        OptionalDisplayableId,
        RequiredDisplayableId;

    }
}

