/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import android.os.Debug;
import android.os.Process;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.Logger;
import com.microsoft.identity.common.adal.internal.net.DefaultConnectionService;
import com.microsoft.identity.common.adal.internal.net.HttpUrlConnectionFactory;
import com.microsoft.identity.common.adal.internal.net.HttpWebResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class HttpWebRequest {
    static final String REQUEST_METHOD_POST = "POST";
    static final String REQUEST_METHOD_GET = "GET";
    private static final String TAG = "HttpWebRequest";
    private static final int DEBUG_SIMULATE_DELAY = 0;
    private static final int CONNECT_TIME_OUT = AuthenticationSettings.INSTANCE.getConnectTimeOut();
    private static final int READ_TIME_OUT = AuthenticationSettings.INSTANCE.getReadTimeOut();
    private final String mRequestMethod;
    private final URL mUrl;
    private final byte[] mRequestContent;
    private final String mRequestContentType;
    private final Map<String, String> mRequestHeaders;

    HttpWebRequest(URL requestURL, String requestMethod, Map<String, String> headers) {
        this(requestURL, requestMethod, headers, null, null);
    }

    HttpWebRequest(URL requestURL, String requestMethod, Map<String, String> headers, byte[] requestContent, String requestContentType) {
        this.mUrl = requestURL;
        this.mRequestMethod = requestMethod;
        this.mRequestHeaders = new HashMap<String, String>();
        if (this.mUrl != null) {
            this.mRequestHeaders.put("Host", this.mUrl.getAuthority());
        }
        this.mRequestHeaders.putAll(headers);
        this.mRequestContent = requestContent;
        this.mRequestContentType = requestContentType;
    }

    private HttpURLConnection setupConnection() throws IOException {
        String methodName = ":setupConnection";
        Logger.v("HttpWebRequest:setupConnection", "HttpWebRequest setupConnection.", "Thread:" + Process.myTid(), null);
        if (this.mUrl == null) {
            throw new IllegalArgumentException("requestURL");
        }
        if (!this.mUrl.getProtocol().equalsIgnoreCase("http") && !this.mUrl.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("requestURL");
        }
        HttpURLConnection.setFollowRedirects(true);
        HttpURLConnection connection = HttpUrlConnectionFactory.createHttpUrlConnection((URL)this.mUrl);
        connection.setConnectTimeout(CONNECT_TIME_OUT);
        Set<Map.Entry<String, String>> headerEntries = this.mRequestHeaders.entrySet();
        for (Map.Entry<String, String> entry : headerEntries) {
            Logger.v("HttpWebRequest:setupConnection", "Setting header. ", "Header: " + entry.getKey(), null);
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        connection.setReadTimeout(READ_TIME_OUT);
        connection.setInstanceFollowRedirects(true);
        connection.setUseCaches(false);
        connection.setRequestMethod(this.mRequestMethod);
        connection.setDoInput(true);
        HttpWebRequest.setRequestBody(connection, this.mRequestContent, this.mRequestContentType);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpWebResponse send() throws IOException {
        HttpWebResponse response;
        String methodName = ":send";
        Logger.v("HttpWebRequest:send", "HttpWebRequest send. ", " Thread: " + Process.myTid(), null);
        HttpURLConnection connection = this.setupConnection();
        InputStream responseStream = null;
        try {
            block6: {
                try {
                    responseStream = connection.getInputStream();
                }
                catch (IOException ex) {
                    Logger.e("HttpWebRequest:send", "IOException is thrown when sending the request. ", ex.getMessage(), ADALError.SERVER_ERROR);
                    responseStream = connection.getErrorStream();
                    if (responseStream != null) break block6;
                    throw ex;
                }
            }
            int statusCode = connection.getResponseCode();
            String responseBody = HttpWebRequest.convertStreamToString(responseStream);
            if (Debug.isDebuggerConnected()) {
                // empty if block
            }
            Logger.v("HttpWebRequest:send", "Response is received.");
            response = new HttpWebResponse(statusCode, responseBody, connection.getHeaderFields());
        }
        finally {
            HttpWebRequest.safeCloseStream(responseStream);
        }
        return response;
    }

    static void throwIfNetworkNotAvailable(Context context) throws AuthenticationException {
        DefaultConnectionService connectionService = new DefaultConnectionService(context);
        if (!connectionService.isConnectionAvailable()) {
            if (connectionService.isNetworkDisabledFromOptimizations()) {
                AuthenticationException authenticationException = new AuthenticationException(ADALError.NO_NETWORK_CONNECTION_POWER_OPTIMIZATION, "Connection is not available to refresh token because power optimization is enabled. And the device is in doze mode or the app is standby" + ADALError.NO_NETWORK_CONNECTION_POWER_OPTIMIZATION.getDescription());
                Logger.w(TAG, "Connection is not available to refresh token because power optimization is enabled. And the device is in doze mode or the app is standby" + ADALError.NO_NETWORK_CONNECTION_POWER_OPTIMIZATION.getDescription(), "", ADALError.NO_NETWORK_CONNECTION_POWER_OPTIMIZATION);
                throw authenticationException;
            }
            AuthenticationException authenticationException = new AuthenticationException(ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE, "Connection is not available to refresh token");
            Logger.w(TAG, "Connection is not available to refresh token", "", ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE);
            throw authenticationException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    private static String convertStreamToString(InputStream inputStream) throws IOException {
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(line);
            }
            String string2 = sb.toString();
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setRequestBody(HttpURLConnection connection, byte[] contentRequest, String requestContentType) throws IOException {
        if (null != contentRequest) {
            connection.setDoOutput(true);
            if (null != requestContentType && !requestContentType.isEmpty()) {
                connection.setRequestProperty("Content-Type", requestContentType);
            }
            connection.setRequestProperty("Content-Length", Integer.toString(contentRequest.length));
            connection.setFixedLengthStreamingMode(contentRequest.length);
            OutputStream out = null;
            try {
                out = connection.getOutputStream();
                out.write(contentRequest);
            }
            finally {
                HttpWebRequest.safeCloseStream(out);
            }
        }
    }

    private static void safeCloseStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                Logger.e(TAG, "Failed to close the stream. ", "", ADALError.IO_EXCEPTION, e);
            }
        }
    }
}

