/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Looper;
import android.os.NetworkOnMainThreadException;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.SparseArray;
import com.googleblog.android_developers.PRNGFixes;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.APIEvent;
import com.microsoft.aad.adal.AcquireTokenRequest;
import com.microsoft.aad.adal.AuthenticationCallback;
import com.microsoft.aad.adal.AuthenticationCancelError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationRequestState;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.BrokerProxy;
import com.microsoft.aad.adal.CacheKey;
import com.microsoft.aad.adal.DefaultTokenCacheStore;
import com.microsoft.aad.adal.DeserializationAuthenticationException;
import com.microsoft.aad.adal.ITokenCacheStore;
import com.microsoft.aad.adal.IWindowComponent;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.PackageHelper;
import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.SSOStateSerializer;
import com.microsoft.aad.adal.Telemetry;
import com.microsoft.aad.adal.TokenCacheAccessor;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.UrlExtensions;
import com.microsoft.aad.adal.UsageAuthenticationException;
import com.microsoft.aad.adal.UserInfo;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthenticationContext {
    private static final int EXCLUDE_INDEX = 8;
    private static final String TAG = "AuthenticationContext";
    private static final String REQUEST_ID = "requestId:";
    private Context mContext;
    private String mAuthority;
    private boolean mValidateAuthority;
    private boolean mIsAuthorityValidated;
    private ITokenCacheStore mTokenCacheStore;
    private BrokerProxy mBrokerProxy = null;
    private boolean mExtendedLifetimeEnabled = false;
    private List<String> mClientCapabilites = null;
    private static final SparseArray<AuthenticationRequestState> DELEGATE_MAP = new SparseArray();
    private UUID mRequestCorrelationId = null;

    public AuthenticationContext(Context appContext, String authority, boolean validateAuthority) {
        PRNGFixes.apply();
        this.initialize(appContext, authority, new DefaultTokenCacheStore(appContext), validateAuthority, true);
    }

    public AuthenticationContext(Context appContext, String authority, boolean validateAuthority, ITokenCacheStore tokenCacheStore) {
        this.initialize(appContext, authority, tokenCacheStore, validateAuthority, false);
    }

    public AuthenticationContext(Context appContext, String authority, ITokenCacheStore tokenCacheStore) {
        this.initialize(appContext, authority, tokenCacheStore, true, false);
    }

    private void initialize(Context appContext, String authority, ITokenCacheStore tokenCacheStore, boolean validateAuthority, boolean defaultCache) {
        if (appContext == null) {
            throw new IllegalArgumentException("appContext");
        }
        if (authority == null) {
            throw new IllegalArgumentException("authority");
        }
        this.mBrokerProxy = new BrokerProxy(appContext);
        if (!defaultCache && !this.mBrokerProxy.canUseLocalCache(authority)) {
            throw new UnsupportedOperationException("Local cache is not supported for broker usage");
        }
        this.mContext = appContext;
        this.checkInternetPermission();
        this.mAuthority = AuthenticationContext.extractAuthority(authority);
        this.mValidateAuthority = validateAuthority;
        this.mTokenCacheStore = tokenCacheStore;
    }

    public ITokenCacheStore getCache() {
        return this.mTokenCacheStore;
    }

    public boolean getExtendedLifetimeEnabled() {
        return this.mExtendedLifetimeEnabled;
    }

    public void setExtendedLifetimeEnabled(boolean extendedLifetimeEnabled) {
        this.mExtendedLifetimeEnabled = extendedLifetimeEnabled;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public boolean getValidateAuthority() {
        return this.mValidateAuthority;
    }

    public String getBrokerUser() {
        if (this.mBrokerProxy != null) {
            return this.mBrokerProxy.getCurrentUser();
        }
        return null;
    }

    public UserInfo[] getBrokerUsers() throws OperationCanceledException, AuthenticatorException, IOException {
        return this.mBrokerProxy != null ? this.mBrokerProxy.getBrokerUsers() : null;
    }

    public String getRedirectUriForBroker() {
        String methodName = ":getRedirectUriForBroker";
        PackageHelper packageHelper = new PackageHelper(this.mContext);
        String packageName = this.mContext.getPackageName();
        String signatureDigest = packageHelper.getCurrentSignatureForPackage(packageName);
        String redirectUri = PackageHelper.getBrokerRedirectUrl(packageName, signatureDigest);
        Logger.v("AuthenticationContext:getRedirectUriForBroker", "Get expected redirect Uri. ", "Broker redirectUri:" + redirectUri + " packagename:" + packageName + " signatureDigest:" + signatureDigest, null);
        return redirectUri;
    }

    public void acquireToken(Activity activity, String resource, String clientId, @Nullable String redirectUri, @Nullable String loginHint, AuthenticationCallback<AuthenticationResult> callback) {
        this.acquireToken(resource, clientId, redirectUri, loginHint, PromptBehavior.Auto, null, null, callback, "100", this.wrapActivity(activity), false);
    }

    public void acquireToken(Activity activity, String resource, String clientId, @Nullable String redirectUri, @Nullable String loginHint, @Nullable String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        this.acquireToken(resource, clientId, redirectUri, loginHint, PromptBehavior.Auto, extraQueryParameters, null, callback, "104", this.wrapActivity(activity), false);
    }

    public void acquireToken(Activity activity, String resource, String clientId, @Nullable String redirectUri, @Nullable PromptBehavior prompt, AuthenticationCallback<AuthenticationResult> callback) {
        this.acquireToken(resource, clientId, redirectUri, null, prompt, null, null, callback, "108", this.wrapActivity(activity), false);
    }

    public void acquireToken(Activity activity, String resource, String clientId, @Nullable String redirectUri, @Nullable PromptBehavior prompt, @Nullable String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        this.acquireToken(resource, clientId, redirectUri, null, prompt, extraQueryParameters, null, callback, "111", this.wrapActivity(activity), false);
    }

    public void acquireToken(Activity activity, String resource, String clientId, @Nullable String redirectUri, @Nullable String loginHint, @Nullable PromptBehavior prompt, @Nullable String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        this.acquireToken(resource, clientId, redirectUri, loginHint, prompt, extraQueryParameters, null, callback, "115", this.wrapActivity(activity), false);
    }

    public void acquireToken(Activity activity, String resource, String clientId, @Nullable String redirectUri, @Nullable String loginHint, @Nullable PromptBehavior prompt, @Nullable String extraQueryParameters, @Nullable String claims, AuthenticationCallback<AuthenticationResult> callback) {
        this.acquireToken(resource, clientId, redirectUri, loginHint, prompt, extraQueryParameters, claims, callback, "118", this.wrapActivity(activity), false);
    }

    public void acquireToken(IWindowComponent fragment, String resource, String clientId, @Nullable String redirectUri, @Nullable String loginHint, @Nullable PromptBehavior prompt, @Nullable String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        this.acquireToken(resource, clientId, redirectUri, loginHint, prompt, extraQueryParameters, null, callback, "116", fragment, false);
    }

    public void acquireToken(IWindowComponent fragment, String resource, String clientId, @Nullable String redirectUri, @Nullable String loginHint, @Nullable PromptBehavior prompt, @Nullable String extraQueryParameters, @Nullable String claims, AuthenticationCallback<AuthenticationResult> callback) {
        this.acquireToken(resource, clientId, redirectUri, loginHint, prompt, extraQueryParameters, claims, callback, "119", fragment, false);
    }

    public void acquireToken(String resource, String clientId, @Nullable String redirectUri, @Nullable String loginHint, @Nullable PromptBehavior prompt, @Nullable String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        this.acquireToken(resource, clientId, redirectUri, loginHint, prompt, extraQueryParameters, null, callback, "117", null, true);
    }

    public void acquireToken(String resource, String clientId, @Nullable String redirectUri, @Nullable String loginHint, @Nullable PromptBehavior prompt, @Nullable String extraQueryParameters, @Nullable String claims, AuthenticationCallback<AuthenticationResult> callback) {
        this.acquireToken(resource, clientId, redirectUri, loginHint, prompt, extraQueryParameters, claims, callback, "120", null, false);
    }

    private void acquireToken(String resource, String clientId, @Nullable String redirectUri, @Nullable String loginHint, @Nullable PromptBehavior prompt, @Nullable String extraQueryParameters, @Nullable String claims, AuthenticationCallback<AuthenticationResult> callback, String apiEventString, IWindowComponent fragment, boolean useDialog) {
        this.throwIfClaimsInBothExtraQpAndClaimsParameter(claims, extraQueryParameters);
        try {
            this.validateClaims(claims);
        }
        catch (AuthenticationException e) {
            callback.onError(e);
            return;
        }
        if (this.checkPreRequirements(resource, clientId, callback) && this.checkADFSValidationRequirements(loginHint, callback)) {
            redirectUri = this.getRedirectUri(redirectUri);
            String requestId = Telemetry.registerNewRequest();
            APIEvent apiEvent = this.createApiEvent(this.mContext, clientId, requestId, apiEventString);
            apiEvent.setPromptBehavior(prompt);
            AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, loginHint, prompt, extraQueryParameters, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled(), claims);
            request.setTelemetryRequestId(requestId);
            this.setAppInfoToRequest(request);
            request.setClientCapabilities(this.mClientCapabilites);
            if (!StringExtensions.isNullOrBlank((String)loginHint)) {
                apiEvent.setLoginHint(loginHint);
                request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.LoginHint);
            }
            this.createAcquireTokenRequest(apiEvent).acquireToken(fragment, useDialog, request, callback);
        }
    }

    public AuthenticationResult acquireTokenSilentSync(String resource, String clientId, String userId) throws AuthenticationException, InterruptedException {
        return this.acquireTokenSilentSync(resource, clientId, userId, false, null, "1");
    }

    public AuthenticationResult acquireTokenSilentSync(String resource, String clientId, String userId, @Nullable String claims) throws AuthenticationException, InterruptedException {
        return this.acquireTokenSilentSync(resource, clientId, userId, false, claims, "15");
    }

    public AuthenticationResult acquireTokenSilentSync(String resource, String clientId, String userId, boolean forceRefresh) throws AuthenticationException, InterruptedException {
        return this.acquireTokenSilentSync(resource, clientId, userId, forceRefresh, null, "13");
    }

    private AuthenticationResult acquireTokenSilentSync(String resource, String clientId, String userId, boolean forceRefresh, String claims, String apiEventString) throws AuthenticationException, InterruptedException {
        String methodName = ":acquireTokenSilentSync";
        this.validateClaims(claims);
        this.checkPreRequirements(resource, clientId);
        this.checkADFSValidationRequirements(null);
        final AtomicReference authenticationResult = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        String requestId = Telemetry.registerNewRequest();
        APIEvent apiEvent = this.createApiEvent(this.mContext, clientId, requestId, apiEventString);
        apiEvent.setPromptBehavior(PromptBehavior.Auto.toString());
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, userId, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled(), forceRefresh, claims);
        request.setSilent(true);
        request.setPrompt(PromptBehavior.Auto);
        request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.UniqueId);
        request.setTelemetryRequestId(requestId);
        request.setClientCapabilities(this.mClientCapabilites);
        this.setAppInfoToRequest(request);
        Looper currentLooper = Looper.myLooper();
        if (currentLooper != null && currentLooper == this.mContext.getMainLooper()) {
            Logger.e("AuthenticationContext:acquireTokenSilentSync", "Sync network calls must not be invoked in main thread. This method will throw android.os.NetworkOnMainThreadException in next major release", (Throwable)new NetworkOnMainThreadException());
        }
        this.createAcquireTokenRequest(apiEvent).acquireToken(null, false, request, new AuthenticationCallback<AuthenticationResult>(){

            @Override
            public void onSuccess(AuthenticationResult result) {
                authenticationResult.set(result);
                latch.countDown();
            }

            @Override
            public void onError(Exception exc) {
                exception.set(exc);
                latch.countDown();
            }
        });
        latch.await();
        Exception e = (Exception)exception.get();
        if (e != null) {
            if (e instanceof AuthenticationException) {
                throw (AuthenticationException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e.getCause() != null) {
                if (e.getCause() instanceof AuthenticationException) {
                    throw (AuthenticationException)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new AuthenticationException(ADALError.ERROR_SILENT_REQUEST, e.getCause().getMessage(), e.getCause());
            }
            throw new AuthenticationException(ADALError.ERROR_SILENT_REQUEST, e.getMessage(), e);
        }
        return (AuthenticationResult)authenticationResult.get();
    }

    @Deprecated
    public Future<AuthenticationResult> acquireTokenSilent(String resource, String clientId, String userId, final AuthenticationCallback<AuthenticationResult> callback) {
        final SettableFuture<AuthenticationResult> futureTask = new SettableFuture<AuthenticationResult>();
        try {
            this.checkPreRequirements(resource, clientId);
            this.checkADFSValidationRequirements(null);
        }
        catch (AuthenticationException e) {
            callback.onError(e);
            futureTask.setException(e);
            return futureTask;
        }
        String requestId = Telemetry.registerNewRequest();
        final APIEvent apiEvent = this.createApiEvent(this.mContext, clientId, requestId, "2");
        apiEvent.setIsDeprecated(true);
        final AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, userId, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled());
        request.setSilent(true);
        request.setPrompt(PromptBehavior.Auto);
        request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.UniqueId);
        request.setTelemetryRequestId(requestId);
        this.setAppInfoToRequest(request);
        this.createAcquireTokenRequest(apiEvent).acquireToken(null, false, request, new AuthenticationCallback<AuthenticationResult>(){

            @Override
            public void onSuccess(AuthenticationResult result) {
                apiEvent.setWasApiCallSuccessful(true, null);
                apiEvent.setCorrelationId(request.getCorrelationId().toString());
                apiEvent.setIdToken(result.getIdToken());
                apiEvent.stopTelemetryAndFlush();
                if (callback != null) {
                    callback.onSuccess(result);
                }
                futureTask.set(result);
            }

            @Override
            public void onError(Exception exc) {
                apiEvent.setWasApiCallSuccessful(false, exc);
                apiEvent.setCorrelationId(request.getCorrelationId().toString());
                apiEvent.stopTelemetryAndFlush();
                if (callback != null) {
                    callback.onError(exc);
                }
                futureTask.setException(exc);
            }
        });
        return futureTask;
    }

    public void acquireTokenSilentAsync(String resource, String clientId, String userId, AuthenticationCallback<AuthenticationResult> callback) {
        this.acquireTokenSilentAsync(resource, clientId, userId, false, null, "3", callback);
    }

    public void acquireTokenSilentAsync(String resource, String clientId, String userId, boolean forceRefresh, AuthenticationCallback<AuthenticationResult> callback) {
        this.acquireTokenSilentAsync(resource, clientId, userId, forceRefresh, null, "14", callback);
    }

    public void acquireTokenSilentAsync(String resource, String clientId, String userId, @Nullable String claims, AuthenticationCallback<AuthenticationResult> callback) {
        this.acquireTokenSilentAsync(resource, clientId, userId, false, claims, "16", callback);
    }

    private void acquireTokenSilentAsync(String resource, String clientId, String userId, boolean forceRefresh, String claims, String apiEventString, AuthenticationCallback<AuthenticationResult> callback) {
        if (!this.checkPreRequirements(resource, clientId, callback) || !this.checkADFSValidationRequirements(null, callback)) {
            return;
        }
        try {
            this.validateClaims(claims);
        }
        catch (AuthenticationException e) {
            callback.onError(e);
            return;
        }
        String requestId = Telemetry.registerNewRequest();
        APIEvent apiEvent = this.createApiEvent(this.mContext, clientId, requestId, apiEventString);
        apiEvent.setPromptBehavior(PromptBehavior.Auto.toString());
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, userId, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled(), forceRefresh, claims);
        request.setSilent(true);
        request.setPrompt(PromptBehavior.Auto);
        request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.UniqueId);
        request.setClientCapabilities(this.mClientCapabilites);
        this.setAppInfoToRequest(request);
        request.setTelemetryRequestId(requestId);
        this.createAcquireTokenRequest(apiEvent).acquireToken(null, false, request, callback);
    }

    @Deprecated
    public void acquireTokenByRefreshToken(String refreshToken, String clientId, AuthenticationCallback<AuthenticationResult> callback) {
        if (!this.checkADFSValidationRequirements(null, callback)) {
            return;
        }
        if (StringExtensions.isNullOrBlank((String)refreshToken)) {
            throw new IllegalArgumentException("Refresh token is not provided");
        }
        if (StringExtensions.isNullOrBlank((String)clientId)) {
            throw new IllegalArgumentException("ClientId is not provided");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback is not provided");
        }
        String requestId = Telemetry.registerNewRequest();
        APIEvent apiEvent = this.createApiEvent(this.mContext, clientId, requestId, "4");
        apiEvent.setPromptBehavior(PromptBehavior.Auto.toString());
        apiEvent.setIsDeprecated(true);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, null, clientId, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled());
        request.setSilent(true);
        request.setTelemetryRequestId(requestId);
        this.createAcquireTokenRequest(apiEvent).refreshTokenWithoutCache(refreshToken, request, callback);
    }

    @Deprecated
    public void acquireTokenByRefreshToken(String refreshToken, String clientId, String resource, AuthenticationCallback<AuthenticationResult> callback) {
        if (!this.checkADFSValidationRequirements(null, callback)) {
            return;
        }
        if (StringExtensions.isNullOrBlank((String)refreshToken)) {
            throw new IllegalArgumentException("Refresh token is not provided");
        }
        if (StringExtensions.isNullOrBlank((String)clientId)) {
            throw new IllegalArgumentException("ClientId is not provided");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback is not provided");
        }
        String requestId = Telemetry.registerNewRequest();
        APIEvent apiEvent = this.createApiEvent(this.mContext, clientId, requestId, "5");
        apiEvent.setPromptBehavior(PromptBehavior.Auto.toString());
        apiEvent.setIsDeprecated(true);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled());
        request.setTelemetryRequestId(requestId);
        request.setSilent(true);
        this.createAcquireTokenRequest(apiEvent).refreshTokenWithoutCache(refreshToken, request, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        String methodName = ":onActivityResult";
        if (requestCode == 1001) {
            AuthenticationRequestState waitingRequest;
            if (data == null) {
                Logger.e("AuthenticationContext:onActivityResult", "onActivityResult BROWSER_FLOW data is null.", "", ADALError.ON_ACTIVITY_RESULT_INTENT_NULL);
                return;
            }
            Bundle extras = data.getExtras();
            int requestId = extras.getInt("com.microsoft.aad.adal:RequestId");
            SparseArray<AuthenticationRequestState> sparseArray = DELEGATE_MAP;
            synchronized (sparseArray) {
                waitingRequest = (AuthenticationRequestState)DELEGATE_MAP.get(requestId);
            }
            if (waitingRequest != null) {
                AcquireTokenRequest acquireTokenRequest = new AcquireTokenRequest(this.mContext, this, waitingRequest.getAPIEvent());
                acquireTokenRequest.onActivityResult(requestCode, resultCode, data);
            } else {
                Logger.e("AuthenticationContext:onActivityResult", "onActivityResult did not find the waiting request. requestId:" + requestId, null, ADALError.ON_ACTIVITY_RESULT_INTENT_NULL);
            }
        }
    }

    public boolean cancelAuthenticationActivity(int requestId) throws AuthenticationException {
        String methodName = ":cancelAuthenticationActivity";
        AuthenticationRequestState waitingRequest = this.getWaitingRequest(requestId);
        if (waitingRequest == null || waitingRequest.getDelegate() == null) {
            Logger.v("AuthenticationContext:cancelAuthenticationActivity", "Current callback is empty. There is not any active authentication.");
            return true;
        }
        String currentCorrelationInfo = waitingRequest.getRequest() != null ? String.format(" CorrelationId: %s", waitingRequest.getRequest().getCorrelationId().toString()) : "No correlation id associated with waiting request";
        Logger.v("AuthenticationContext:cancelAuthenticationActivity", "Current callback is not empty. There is an active authentication Activity." + currentCorrelationInfo);
        Intent intent = new Intent("com.microsoft.aad.adal:BrowserCancel");
        Bundle extras = new Bundle();
        intent.putExtras(extras);
        intent.putExtra("com.microsoft.aad.adal:RequestId", requestId);
        boolean cancelResult = LocalBroadcastManager.getInstance((Context)this.mContext).sendBroadcast(intent);
        if (cancelResult) {
            Logger.v("AuthenticationContext:cancelAuthenticationActivity", "Cancel broadcast message was successful." + currentCorrelationInfo);
            waitingRequest.setCancelled(true);
            waitingRequest.getDelegate().onError(new AuthenticationCancelError("Cancel broadcast message was successful."));
        } else {
            Logger.w("AuthenticationContext:cancelAuthenticationActivity", "Cancel broadcast message was not successful." + currentCorrelationInfo, "", ADALError.BROADCAST_CANCEL_NOT_SUCCESSFUL);
        }
        return cancelResult;
    }

    public UUID getRequestCorrelationId() {
        if (this.mRequestCorrelationId == null) {
            return UUID.randomUUID();
        }
        return this.mRequestCorrelationId;
    }

    public void setRequestCorrelationId(UUID requestCorrelationId) {
        this.mRequestCorrelationId = requestCorrelationId;
        Logger.setCorrelationId(requestCorrelationId);
    }

    private void setAppInfoToRequest(AuthenticationRequest request) {
        String packageName = this.mContext.getPackageName();
        request.setAppName(packageName);
        try {
            PackageInfo packageInfo = this.mContext.getPackageManager().getPackageInfo(packageName, 0);
            request.setAppVersion(packageInfo.versionName);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    private IWindowComponent wrapActivity(final Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("activity");
        }
        return new IWindowComponent(){
            private Activity mRefActivity;
            {
                this.mRefActivity = activity;
            }

            @Override
            public void startActivityForResult(Intent intent, int requestCode) {
                if (this.mRefActivity != null) {
                    this.mRefActivity.startActivityForResult(intent, requestCode);
                }
            }
        };
    }

    public static String mergeClaimsWithClientCapabilities(String claims, List<String> clientCapabilities) {
        String mergedClaims;
        if (clientCapabilities == null || clientCapabilities.isEmpty()) {
            return claims;
        }
        JSONArray capabilitiesArray = new JSONArray();
        for (String capability : clientCapabilities) {
            capabilitiesArray.put((Object)capability);
        }
        try {
            JSONObject capabilities = new JSONObject();
            JSONObject values = new JSONObject();
            values.put("values", (Object)capabilitiesArray);
            capabilities.put("xms_cc", (Object)values);
            if (!TextUtils.isEmpty((CharSequence)claims)) {
                JSONObject claimsJson = new JSONObject(claims);
                if (claimsJson.has("access_token")) {
                    JSONObject accessTokenClaim = claimsJson.getJSONObject("access_token");
                    accessTokenClaim.put("xms_cc", (Object)values);
                    claimsJson.put("access_token", (Object)accessTokenClaim);
                } else {
                    claimsJson.put("access_token", (Object)capabilities);
                }
                mergedClaims = claimsJson.toString();
            } else {
                JSONObject claimsObject = new JSONObject();
                claimsObject.put("access_token", (Object)capabilities);
                mergedClaims = claimsObject.toString();
            }
        }
        catch (JSONException e) {
            Logger.e(TAG, "Invalid json format for claims or Client capabilities ", e);
            return claims;
        }
        return mergedClaims;
    }

    private boolean checkPreRequirements(String resource, String clientId) throws AuthenticationException {
        if (this.mContext == null) {
            throw new IllegalArgumentException("context", new AuthenticationException(ADALError.DEVELOPER_CONTEXT_IS_NOT_PROVIDED));
        }
        if (AuthenticationSettings.INSTANCE.getUseBroker()) {
            this.mBrokerProxy.verifyBrokerPermissionsAPI22AndLess();
        }
        if (StringExtensions.isNullOrBlank((String)resource)) {
            throw new IllegalArgumentException("resource");
        }
        if (StringExtensions.isNullOrBlank((String)clientId)) {
            throw new IllegalArgumentException("clientId");
        }
        return true;
    }

    private boolean checkPreRequirements(String resource, String clientId, AuthenticationCallback<AuthenticationResult> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback");
        }
        try {
            return this.checkPreRequirements(resource, clientId);
        }
        catch (AuthenticationException exception) {
            callback.onError(exception);
            return false;
        }
    }

    private boolean checkADFSValidationRequirements(@Nullable String loginHint) throws AuthenticationException {
        URL authorityURL = StringExtensions.getUrl((String)this.mAuthority);
        if (this.mAuthority == null || authorityURL == null) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL);
        }
        if (UrlExtensions.isADFSAuthority(authorityURL) && this.mValidateAuthority && !this.mIsAuthorityValidated && loginHint == null) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_CAN_NOT_BE_VALIDED, "AD FS validation requires a loginHint be provided or an " + this.getClass().getSimpleName() + " in which the current authority has previously been validated.");
        }
        return true;
    }

    private boolean checkADFSValidationRequirements(@Nullable String loginHint, AuthenticationCallback<AuthenticationResult> callback) {
        try {
            return this.checkADFSValidationRequirements(loginHint);
        }
        catch (AuthenticationException e) {
            callback.onError(e);
            return false;
        }
    }

    private String getRedirectUri(String inputRedirectUri) {
        String redirectUri = StringExtensions.isNullOrBlank((String)inputRedirectUri) ? this.mContext.getApplicationContext().getPackageName() : inputRedirectUri;
        return redirectUri;
    }

    private AcquireTokenRequest createAcquireTokenRequest(APIEvent apiEvent) {
        return new AcquireTokenRequest(this.mContext, this, apiEvent);
    }

    private static String extractAuthority(String authority) {
        int fourthSlash;
        int thirdSlash;
        if (!(StringExtensions.isNullOrBlank((String)authority) || (thirdSlash = authority.indexOf(47, 8)) < 0 || thirdSlash == authority.length() - 1 || (fourthSlash = authority.indexOf("/", thirdSlash + 1)) >= 0 && fourthSlash <= thirdSlash + 1)) {
            if (fourthSlash >= 0) {
                return authority.substring(0, fourthSlash);
            }
            return authority;
        }
        throw new IllegalArgumentException("authority");
    }

    private void checkInternetPermission() {
        PackageManager pm = this.mContext.getPackageManager();
        if (0 != pm.checkPermission("android.permission.INTERNET", this.mContext.getPackageName())) {
            throw new IllegalStateException(new AuthenticationException(ADALError.DEVELOPER_INTERNET_PERMISSION_MISSING));
        }
    }

    String serialize(String uniqueUserId) throws AuthenticationException {
        TokenCacheItem tokenItem;
        String methodName = ":serialize";
        if (StringExtensions.isNullOrBlank((String)uniqueUserId)) {
            throw new IllegalArgumentException("uniqueUserId");
        }
        if (this.mBrokerProxy.canSwitchToBroker(this.mAuthority) != BrokerProxy.SwitchToBroker.CANNOT_SWITCH_TO_BROKER) {
            throw new UsageAuthenticationException(ADALError.FAIL_TO_EXPORT, "Failed to export the family refresh token cache item because broker is enabled.");
        }
        TokenCacheAccessor tokenCacheAccessor = new TokenCacheAccessor(this.mContext.getApplicationContext(), this.mTokenCacheStore, this.getAuthority(), Telemetry.registerNewRequest());
        try {
            tokenItem = tokenCacheAccessor.getFRTItem("1", uniqueUserId);
        }
        catch (MalformedURLException e) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL, e.getMessage(), e);
        }
        if (tokenItem == null) {
            Logger.i("AuthenticationContext:serialize", "Cannot find the family token cache item for this userID", "");
            throw new UsageAuthenticationException(ADALError.FAIL_TO_EXPORT, "Failed to export the FID because no family token cache item is found.");
        }
        if (StringExtensions.isNullOrBlank((String)tokenItem.getFamilyClientId())) {
            throw new UsageAuthenticationException(ADALError.FAIL_TO_EXPORT, "tokenItem does not contain family refresh token");
        }
        return SSOStateSerializer.serialize(tokenItem);
    }

    void deserialize(String serializedBlob) throws AuthenticationException {
        if (StringExtensions.isNullOrBlank((String)serializedBlob)) {
            throw new IllegalArgumentException("serializedBlob");
        }
        if (this.mBrokerProxy.canSwitchToBroker(this.mAuthority) != BrokerProxy.SwitchToBroker.CANNOT_SWITCH_TO_BROKER) {
            throw new UsageAuthenticationException(ADALError.FAIL_TO_IMPORT, "Failed to import the serialized blob because broker is enabled.");
        }
        TokenCacheItem tokenCacheItem = SSOStateSerializer.deserialize(serializedBlob);
        if (StringExtensions.isNullOrBlank((String)tokenCacheItem.getAuthority()) || StringExtensions.isNullOrBlank((String)tokenCacheItem.getClientId()) && StringExtensions.isNullOrBlank((String)tokenCacheItem.getFamilyClientId())) {
            throw new DeserializationAuthenticationException("Failed to deserialize the blob because authority or client id is null/empty.");
        }
        String cacheKey = CacheKey.createCacheKey(tokenCacheItem);
        this.getCache().setItem(cacheKey, tokenCacheItem);
    }

    void setIsAuthorityValidated(boolean isAuthorityValidated) {
        this.mIsAuthorityValidated = isAuthorityValidated;
    }

    boolean getIsAuthorityValidated() {
        return this.mIsAuthorityValidated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AuthenticationRequestState getWaitingRequest(int requestId) throws AuthenticationException {
        AuthenticationRequestState request;
        String methodName = ":getWaitingRequest";
        Logger.v("AuthenticationContext:getWaitingRequest", "Get waiting request. requestId:" + requestId);
        SparseArray<AuthenticationRequestState> sparseArray = DELEGATE_MAP;
        synchronized (sparseArray) {
            request = (AuthenticationRequestState)DELEGATE_MAP.get(requestId);
        }
        if (request == null) {
            Logger.e("AuthenticationContext:getWaitingRequest", "Request callback is not available. requestId:" + requestId, null, ADALError.CALLBACK_IS_NOT_FOUND);
            throw new AuthenticationException(ADALError.CALLBACK_IS_NOT_FOUND, "Request callback is not available for requestId:" + requestId);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putWaitingRequest(int requestId, AuthenticationRequestState requestState) {
        if (requestState == null) {
            return;
        }
        Logger.v(TAG, "Put waiting request. requestId:" + requestId + " " + this.getCorrelationInfoFromWaitingRequest(requestState));
        SparseArray<AuthenticationRequestState> sparseArray = DELEGATE_MAP;
        synchronized (sparseArray) {
            DELEGATE_MAP.put(requestId, (Object)requestState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWaitingRequest(int requestId) {
        Logger.v(TAG, "Remove waiting request. requestId:" + requestId);
        SparseArray<AuthenticationRequestState> sparseArray = DELEGATE_MAP;
        synchronized (sparseArray) {
            DELEGATE_MAP.remove(requestId);
        }
    }

    String getCorrelationInfoFromWaitingRequest(AuthenticationRequestState waitingRequest) {
        UUID requestCorrelationID = this.getRequestCorrelationId();
        if (waitingRequest.getRequest() != null) {
            requestCorrelationID = waitingRequest.getRequest().getCorrelationId();
        }
        return String.format(" CorrelationId: %s", requestCorrelationID.toString());
    }

    public static String getVersionName() {
        return "1.16.2";
    }

    public List<String> getClientCapabilites() {
        return this.mClientCapabilites;
    }

    public void setClientCapabilites(List<String> clientCapabilites) {
        this.mClientCapabilites = clientCapabilites;
    }

    private APIEvent createApiEvent(Context context, String clientId, String requestId, String apiId) {
        APIEvent apiEvent = new APIEvent("Microsoft.ADAL.api_event", context, clientId);
        apiEvent.setRequestId(requestId);
        apiEvent.setAPIId(apiId);
        apiEvent.setAuthority(this.getAuthority());
        Telemetry.getInstance().startEvent(requestId, apiEvent.getEventName());
        return apiEvent;
    }

    private void throwIfClaimsInBothExtraQpAndClaimsParameter(String claims, String extraQP) {
        if (!StringExtensions.isNullOrBlank((String)claims) && !StringExtensions.isNullOrBlank((String)extraQP) && extraQP.contains("claims")) {
            throw new IllegalArgumentException("claims cannot be sent in claims parameter and extra qp.");
        }
    }

    private void validateClaims(String claims) throws AuthenticationException {
        try {
            if (!TextUtils.isEmpty((CharSequence)claims)) {
                new JSONObject(claims);
            }
        }
        catch (JSONException e) {
            throw new AuthenticationException(ADALError.JSON_PARSE_ERROR, "Invalid claims request parameters", e);
        }
    }

    static final class SettableFuture<V>
    extends FutureTask<V> {
        SettableFuture() {
            super(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    return null;
                }
            });
        }

        @Override
        public void set(V v) {
            super.set(v);
        }

        @Override
        public void setException(Throwable t) {
            super.setException(t);
        }
    }
}

