/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.DateExtensions;
import com.microsoft.aad.adal.ExceptionExtensions;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.TelemetryUtils;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.UserInfo;
import com.microsoft.identity.common.adal.internal.net.HttpWebResponse;
import com.microsoft.identity.common.adal.internal.util.HashMapExtensions;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;

public class AuthenticationResult
implements Serializable {
    private static final long serialVersionUID = 2243372613182536368L;
    private ClientInfo mClientInfo;
    private String mResource;
    private String mCode;
    protected String mAccessToken;
    protected String mRefreshToken;
    private String mTokenType;
    protected Date mExpiresOn;
    private Long mExpiresIn;
    private Long mResponseReceived;
    protected String mErrorCode;
    protected String mErrorDescription;
    protected String mErrorCodes;
    protected boolean mIsMultiResourceRefreshToken;
    protected UserInfo mUserInfo;
    protected String mTenantId;
    protected String mIdToken;
    protected AuthenticationStatus mStatus = AuthenticationStatus.Failed;
    protected boolean mInitialRequest;
    protected String mFamilyClientId;
    protected boolean mIsExtendedLifeTimeToken = false;
    protected Date mExtendedExpiresOn;
    protected String mAuthority;
    protected TelemetryUtils.CliTelemInfo mCliTelemInfo;
    protected HashMap<String, String> mHttpResponseBody = null;
    protected int mServiceStatusCode = -1;
    protected HashMap<String, List<String>> mHttpResponseHeaders = null;
    private String mClientId;

    AuthenticationResult() {
        this.mCode = null;
    }

    AuthenticationResult(String clientId, String code) {
        this.mClientId = clientId;
        this.mCode = code;
        this.mStatus = AuthenticationStatus.Succeeded;
        this.mAccessToken = null;
        this.mRefreshToken = null;
    }

    AuthenticationResult(String accessToken, String refreshToken, Date expires, boolean isBroad, UserInfo userInfo, String tenantId, String idToken, Date extendedExpires, String clientId) {
        this.mCode = null;
        this.mAccessToken = accessToken;
        this.mRefreshToken = refreshToken;
        this.mExpiresOn = expires;
        this.mIsMultiResourceRefreshToken = isBroad;
        this.mStatus = AuthenticationStatus.Succeeded;
        this.mUserInfo = userInfo;
        this.mTenantId = tenantId;
        this.mIdToken = idToken;
        this.mExtendedExpiresOn = extendedExpires;
        this.mClientId = clientId;
    }

    AuthenticationResult(String errorCode, String errDescription, String errorCodes) {
        this.mErrorCode = errorCode;
        this.mErrorDescription = errDescription;
        this.mErrorCodes = errorCodes;
        this.mStatus = AuthenticationStatus.Failed;
    }

    static AuthenticationResult createResult(TokenCacheItem cacheItem) {
        if (cacheItem == null) {
            AuthenticationResult result = new AuthenticationResult();
            result.mStatus = AuthenticationStatus.Failed;
            return result;
        }
        AuthenticationResult result = new AuthenticationResult(cacheItem.getAccessToken(), cacheItem.getRefreshToken(), cacheItem.getExpiresOn(), cacheItem.getIsMultiResourceRefreshToken(), cacheItem.getUserInfo(), cacheItem.getTenantId(), cacheItem.getRawIdToken(), cacheItem.getExtendedExpiresOn(), cacheItem.getClientId());
        TelemetryUtils.CliTelemInfo cliTelemInfo = new TelemetryUtils.CliTelemInfo();
        cliTelemInfo.setSpeRing(cacheItem.getSpeRing());
        result.setCliTelemInfo(cliTelemInfo);
        return result;
    }

    static AuthenticationResult createResultForInitialRequest(String clientId) {
        AuthenticationResult result = new AuthenticationResult();
        result.mInitialRequest = true;
        result.mClientId = clientId;
        return result;
    }

    static AuthenticationResult createExtendedLifeTimeResult(TokenCacheItem accessTokenItem) {
        AuthenticationResult retryResult = AuthenticationResult.createResult(accessTokenItem);
        retryResult.setExpiresOn(retryResult.getExtendedExpiresOn());
        retryResult.setIsExtendedLifeTimeToken(true);
        return retryResult;
    }

    public String createAuthorizationHeader() {
        return "Bearer " + this.getAccessToken();
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public String getRefreshToken() {
        return this.mRefreshToken;
    }

    public String getAccessTokenType() {
        return this.mTokenType;
    }

    public Date getExpiresOn() {
        return DateExtensions.createCopy(this.mExpiresOn);
    }

    public Long getExpiresIn() {
        return this.mExpiresIn;
    }

    public void setExpiresIn(Long expiresIn) {
        this.mExpiresIn = expiresIn;
    }

    public Long getResponseReceived() {
        return this.mResponseReceived;
    }

    public void setResponseReceived(Long responseReceived) {
        this.mResponseReceived = responseReceived;
    }

    public boolean getIsMultiResourceRefreshToken() {
        return this.mIsMultiResourceRefreshToken;
    }

    public UserInfo getUserInfo() {
        return this.mUserInfo;
    }

    void setUserInfo(UserInfo userinfo) {
        this.mUserInfo = userinfo;
    }

    public String getTenantId() {
        return this.mTenantId;
    }

    public AuthenticationStatus getStatus() {
        return this.mStatus;
    }

    String getCode() {
        return this.mCode;
    }

    void setCode(String code) {
        this.mCode = code;
    }

    public String getErrorCode() {
        return this.mErrorCode;
    }

    public String getErrorDescription() {
        return this.mErrorDescription;
    }

    public String getErrorLogInfo() {
        return " ErrorCode:" + this.getErrorCode();
    }

    public boolean isExpired() {
        if (this.mIsExtendedLifeTimeToken) {
            return TokenCacheItem.isTokenExpired(this.getExtendedExpiresOn());
        }
        return TokenCacheItem.isTokenExpired(this.getExpiresOn());
    }

    public final String getAuthority() {
        return this.mAuthority;
    }

    String[] getErrorCodes() {
        return this.mErrorCodes != null ? this.mErrorCodes.replaceAll("[\\[\\]]", "").split("([^,]),") : null;
    }

    boolean isInitialRequest() {
        return this.mInitialRequest;
    }

    public String getIdToken() {
        return this.mIdToken;
    }

    public boolean isExtendedLifeTimeToken() {
        return this.mIsExtendedLifeTimeToken;
    }

    final void setIsExtendedLifeTimeToken(boolean isExtendedLifeTimeToken) {
        this.mIsExtendedLifeTimeToken = isExtendedLifeTimeToken;
    }

    final void setExtendedExpiresOn(Date extendedExpiresOn) {
        this.mExtendedExpiresOn = extendedExpiresOn;
    }

    final Date getExtendedExpiresOn() {
        return this.mExtendedExpiresOn;
    }

    final void setExpiresOn(Date expiresOn) {
        this.mExpiresOn = expiresOn;
    }

    void setIdToken(String idToken) {
        this.mIdToken = idToken;
    }

    void setTenantId(String tenantid) {
        this.mTenantId = tenantid;
    }

    void setRefreshToken(String refreshToken) {
        this.mRefreshToken = refreshToken;
    }

    final String getFamilyClientId() {
        return this.mFamilyClientId;
    }

    final void setFamilyClientId(String familyClientId) {
        this.mFamilyClientId = familyClientId;
    }

    public final void setAuthority(String authority) {
        if (!StringExtensions.isNullOrBlank(authority)) {
            this.mAuthority = authority;
        }
    }

    public final TelemetryUtils.CliTelemInfo getCliTelemInfo() {
        return this.mCliTelemInfo;
    }

    final void setCliTelemInfo(TelemetryUtils.CliTelemInfo cliTelemInfo) {
        this.mCliTelemInfo = cliTelemInfo;
    }

    void setHttpResponseBody(HashMap<String, String> body) {
        this.mHttpResponseBody = body;
    }

    public HashMap<String, String> getHttpResponseBody() {
        return this.mHttpResponseBody;
    }

    void setHttpResponseHeaders(HashMap<String, List<String>> headers) {
        this.mHttpResponseHeaders = headers;
    }

    public HashMap<String, List<String>> getHttpResponseHeaders() {
        return this.mHttpResponseHeaders;
    }

    void setServiceStatusCode(int statusCode) {
        this.mServiceStatusCode = statusCode;
    }

    public int getServiceStatusCode() {
        return this.mServiceStatusCode;
    }

    void setHttpResponse(HttpWebResponse response) {
        if (null != response) {
            this.mServiceStatusCode = response.getStatusCode();
            if (null != response.getResponseHeaders()) {
                this.mHttpResponseHeaders = new HashMap(response.getResponseHeaders());
            }
            if (null != response.getBody()) {
                try {
                    this.mHttpResponseBody = new HashMap(HashMapExtensions.getJsonResponse((HttpWebResponse)response));
                }
                catch (JSONException exception) {
                    Logger.e(AuthenticationException.class.getSimpleName(), "Json exception", ExceptionExtensions.getExceptionMessage((Exception)((Object)exception)), ADALError.SERVER_INVALID_JSON_RESPONSE);
                }
            }
        }
    }

    public String getClientId() {
        return this.mClientId;
    }

    public void setClientId(String clientId) {
        this.mClientId = clientId;
    }

    void setClientInfo(ClientInfo clientInfo) {
        this.mClientInfo = clientInfo;
    }

    public ClientInfo getClientInfo() {
        return this.mClientInfo;
    }

    void setResource(String resource) {
        this.mResource = resource;
    }

    public String getResource() {
        return this.mResource;
    }

    public static enum AuthenticationStatus {
        Cancelled,
        Failed,
        Succeeded;

    }
}

