/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.Link;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.WebFingerMetadata;
import java.net.URI;
import java.net.URISyntaxException;

final class ADFSWebFingerValidator {
    private static final String TAG = ADFSWebFingerValidator.class.getSimpleName();
    private static final URI TRUSTED_REALM_REL;

    private ADFSWebFingerValidator() {
    }

    static boolean realmIsTrusted(URI authority, WebFingerMetadata metadata) {
        String methodName = ":realmIsTrusted";
        if (authority == null) {
            throw new IllegalArgumentException("Authority cannot be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("WebFingerMetadata cannot be null");
        }
        Logger.v(TAG + ":realmIsTrusted", "Verifying trust authority. ", authority.toString() + metadata.toString(), null);
        if (metadata.getLinks() != null) {
            for (Link link : metadata.getLinks()) {
                try {
                    URI href = new URI(link.getHref());
                    URI rel = new URI(link.getRel());
                    if (!href.getScheme().equalsIgnoreCase(authority.getScheme()) || !href.getAuthority().equalsIgnoreCase(authority.getAuthority()) || !rel.equals(TRUSTED_REALM_REL)) continue;
                    return true;
                }
                catch (URISyntaxException e) {
                }
            }
        }
        return false;
    }

    static {
        try {
            TRUSTED_REALM_REL = new URI("http://schemas.microsoft.com/rel/trusted-realm");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

