/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.google.gson.JsonSyntaxException;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AbstractMetadataRequestor;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.DRSMetadata;
import com.microsoft.aad.adal.HttpWebResponse;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.WebFingerMetadata;
import com.microsoft.aad.adal.WebFingerMetadataRequestParameters;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

class WebFingerMetadataRequestor
extends AbstractMetadataRequestor<WebFingerMetadata, WebFingerMetadataRequestParameters> {
    private static final String TAG = WebFingerMetadataRequestor.class.getSimpleName();

    WebFingerMetadataRequestor() {
    }

    @Override
    WebFingerMetadata requestMetadata(WebFingerMetadataRequestParameters webFingerMetadataRequestParameters) throws AuthenticationException {
        URL domain = webFingerMetadataRequestParameters.getDomain();
        DRSMetadata drsMetadata = webFingerMetadataRequestParameters.getDrsMetadata();
        Logger.i(TAG, "Validating authority for auth endpoint. ", "Auth endpoint: " + domain.toString());
        try {
            URL webFingerUrl = WebFingerMetadataRequestor.buildWebFingerUrl(domain, drsMetadata);
            HttpWebResponse webResponse = this.getWebrequestHandler().sendGet(webFingerUrl, new HashMap<String, String>());
            int statusCode = webResponse.getStatusCode();
            if (200 != statusCode) {
                throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE);
            }
            return this.parseMetadata(webResponse);
        }
        catch (IOException e) {
            throw new AuthenticationException(ADALError.IO_EXCEPTION, "Unexpected error", e);
        }
    }

    @Override
    WebFingerMetadata parseMetadata(HttpWebResponse webResponse) throws AuthenticationException {
        Logger.v(TAG, "Parsing WebFinger response.");
        try {
            return (WebFingerMetadata)this.parser().fromJson(webResponse.getBody(), WebFingerMetadata.class);
        }
        catch (JsonSyntaxException e) {
            throw new AuthenticationException(ADALError.JSON_PARSE_ERROR);
        }
    }

    static URL buildWebFingerUrl(URL resource, DRSMetadata drsMetadata) throws MalformedURLException {
        URL passiveAuthEndpoint = new URL(drsMetadata.getIdentityProviderService().getPassiveAuthEndpoint());
        StringBuilder webFingerUrlBuilder = new StringBuilder("https://").append(passiveAuthEndpoint.getHost()).append("/.well-known/webfinger?resource=").append(resource.toString());
        String webFingerUrl = webFingerUrlBuilder.toString();
        Logger.i(TAG, "Validator will use WebFinger URL. ", "WebFinger URL: " + webFingerUrl);
        return new URL(webFingerUrl);
    }
}

