/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.text.TextUtils;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.HttpWebResponse;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class HashMapExtensions {
    private static final String TAG = "HashMapExtensions";

    private HashMapExtensions() {
    }

    static HashMap<String, String> urlFormDecode(String parameters) {
        return HashMapExtensions.urlFormDecodeData(parameters, "&");
    }

    static HashMap<String, String> urlFormDecodeData(String parameters, String delimiter) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (!StringExtensions.isNullOrBlank(parameters)) {
            StringTokenizer parameterTokenizer = new StringTokenizer(parameters, delimiter);
            while (parameterTokenizer.hasMoreTokens()) {
                String key;
                String value;
                block8: {
                    String pair = parameterTokenizer.nextToken();
                    String[] elements = pair.split("=");
                    value = null;
                    key = null;
                    if (elements.length == 2) {
                        try {
                            key = StringExtensions.urlFormDecode(elements[0].trim());
                            value = StringExtensions.urlFormDecode(elements[1].trim());
                            break block8;
                        }
                        catch (UnsupportedEncodingException e) {
                            Logger.i(TAG, ADALError.ENCODING_IS_NOT_SUPPORTED.getDescription(), e.getMessage(), null);
                            continue;
                        }
                    }
                    if (elements.length == 1) {
                        try {
                            key = StringExtensions.urlFormDecode(elements[0].trim());
                            value = "";
                        }
                        catch (UnsupportedEncodingException e) {
                            Logger.i(TAG, ADALError.ENCODING_IS_NOT_SUPPORTED.getDescription(), e.getMessage(), null);
                            continue;
                        }
                    }
                }
                if (StringExtensions.isNullOrBlank(key)) continue;
                result.put(key, value);
            }
        }
        return result;
    }

    static Map<String, String> getJsonResponse(HttpWebResponse webResponse) throws JSONException {
        HashMap<String, String> response = new HashMap<String, String>();
        if (webResponse != null && !TextUtils.isEmpty((CharSequence)webResponse.getBody())) {
            JSONObject jsonObject = new JSONObject(webResponse.getBody());
            Iterator i = jsonObject.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                response.put(key, jsonObject.getString(key));
            }
        }
        return response;
    }

    static HashMap<String, String> jsonStringAsMap(String jsonString) throws JSONException {
        HashMap<String, String> responseItems = new HashMap<String, String>();
        if (!StringExtensions.isNullOrBlank(jsonString)) {
            JSONObject jsonObject = new JSONObject(jsonString);
            Iterator i = jsonObject.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                responseItems.put(key, jsonObject.getString(key));
            }
        }
        return responseItems;
    }

    static HashMap<String, List<String>> jsonStringAsMapList(String jsonString) throws JSONException {
        HashMap<String, List<String>> responseItems = new HashMap<String, List<String>>();
        if (!StringExtensions.isNullOrBlank(jsonString)) {
            JSONObject jsonObject = new JSONObject(jsonString);
            Iterator i = jsonObject.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                ArrayList<String> list = new ArrayList<String>();
                JSONArray json = new JSONArray(jsonObject.getString(key));
                for (int index = 0; index < json.length(); ++index) {
                    list.add(json.get(index).toString());
                }
                responseItems.put(key, list);
            }
        }
        return responseItems;
    }
}

