/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.util.Pair;
import com.microsoft.aad.adal.DefaultEvent;
import com.microsoft.aad.adal.StringExtensions;
import java.util.List;
import java.util.Map;

final class CacheEvent
extends DefaultEvent {
    private final String mEventName;

    CacheEvent(String eventName) {
        this.mEventName = eventName;
        this.setProperty("Microsoft.ADAL.event_name", eventName);
    }

    void setSpeRing(String speRing) {
        if (!StringExtensions.isNullOrBlank(speRing)) {
            this.setProperty("Microsoft.ADAL.spe_info", speRing.trim());
        }
    }

    void setTokenType(String tokenType) {
        this.getEventList().add((Pair<String, String>)Pair.create((Object)"Microsoft.ADAL.token_type", (Object)tokenType));
    }

    void setTokenTypeRT(boolean tokenTypeRT) {
        this.setProperty("Microsoft.ADAL.is_rt", String.valueOf(tokenTypeRT));
    }

    void setTokenTypeMRRT(boolean tokenTypeMRRT) {
        this.setProperty("Microsoft.ADAL.is_mrrt", String.valueOf(tokenTypeMRRT));
    }

    void setTokenTypeFRT(boolean tokenTypeFRT) {
        this.setProperty("Microsoft.ADAL.is_frt", String.valueOf(tokenTypeFRT));
    }

    @Override
    public void processEvent(Map<String, String> dispatchMap) {
        if (this.mEventName != "Microsoft.ADAL.token_cache_lookup") {
            return;
        }
        List<Pair<String, String>> eventList = this.getEventList();
        String count = dispatchMap.get("Microsoft.ADAL.cache_event_count");
        if (count == null) {
            dispatchMap.put("Microsoft.ADAL.cache_event_count", "1");
        } else {
            dispatchMap.put("Microsoft.ADAL.cache_event_count", Integer.toString(Integer.parseInt(count) + 1));
        }
        dispatchMap.put("Microsoft.ADAL.is_frt", "");
        dispatchMap.put("Microsoft.ADAL.is_mrrt", "");
        dispatchMap.put("Microsoft.ADAL.is_rt", "");
        if (dispatchMap.containsKey("Microsoft.ADAL.spe_info")) {
            dispatchMap.remove("Microsoft.ADAL.spe_info");
        }
        for (Pair<String, String> eventPair : eventList) {
            String name = (String)eventPair.first;
            if (!name.equals("Microsoft.ADAL.is_frt") && !name.equals("Microsoft.ADAL.is_rt") && !name.equals("Microsoft.ADAL.is_mrrt") && !name.equals("Microsoft.ADAL.spe_info")) continue;
            dispatchMap.put(name, (String)eventPair.second);
        }
    }
}

