/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.InstanceDiscoveryMetadata;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class AuthorityValidationMetadataCache {
    private static final String TAG = AuthorityValidationMetadataCache.class.getSimpleName();
    static final String TENANT_DISCOVERY_ENDPOINT = "tenant_discovery_endpoint";
    static final String META_DATA = "metadata";
    private static final String PREFERRED_NETWORK = "preferred_network";
    private static final String PREFERRED_CACHE = "preferred_cache";
    private static final String ALIASES = "aliases";
    private static ConcurrentMap<String, InstanceDiscoveryMetadata> sAadAuthorityHostMetadata = new ConcurrentHashMap<String, InstanceDiscoveryMetadata>();

    private AuthorityValidationMetadataCache() {
    }

    static boolean containsAuthorityHost(URL authorityUrl) {
        return sAadAuthorityHostMetadata.containsKey(authorityUrl.getHost().toLowerCase(Locale.US));
    }

    static boolean isAuthorityValidated(URL authorityUrl) {
        return AuthorityValidationMetadataCache.containsAuthorityHost(authorityUrl) && AuthorityValidationMetadataCache.getCachedInstanceDiscoveryMetadata(authorityUrl).isValidated();
    }

    static InstanceDiscoveryMetadata getCachedInstanceDiscoveryMetadata(URL authorityUrl) {
        return (InstanceDiscoveryMetadata)sAadAuthorityHostMetadata.get(authorityUrl.getHost().toLowerCase(Locale.US));
    }

    static void processInstanceDiscoveryMetadata(URL authorityUrl, Map<String, String> discoveryResponse) throws JSONException {
        String methodName = ":processInstanceDiscoveryMetadata";
        boolean isTenantDiscoveryEndpointReturned = discoveryResponse.containsKey(TENANT_DISCOVERY_ENDPOINT);
        String metadata = discoveryResponse.get(META_DATA);
        String authorityHost = authorityUrl.getHost().toLowerCase(Locale.US);
        if (!isTenantDiscoveryEndpointReturned) {
            sAadAuthorityHostMetadata.put(authorityHost, new InstanceDiscoveryMetadata(false));
            return;
        }
        if (StringExtensions.isNullOrBlank(metadata)) {
            Logger.v(TAG + ":processInstanceDiscoveryMetadata", "No metadata returned from instance discovery.");
            sAadAuthorityHostMetadata.put(authorityHost, new InstanceDiscoveryMetadata(authorityHost, authorityHost));
            return;
        }
        AuthorityValidationMetadataCache.processInstanceDiscoveryResponse(metadata);
    }

    static void updateInstanceDiscoveryMap(String host, InstanceDiscoveryMetadata metadata) {
        sAadAuthorityHostMetadata.put(host.toLowerCase(Locale.US), metadata);
    }

    static Map<String, InstanceDiscoveryMetadata> getAuthorityValidationMetadataCache() {
        return Collections.unmodifiableMap(sAadAuthorityHostMetadata);
    }

    static void clearAuthorityValidationCache() {
        sAadAuthorityHostMetadata.clear();
    }

    private static void processInstanceDiscoveryResponse(String metadata) throws JSONException {
        JSONArray jsonArray = new JSONArray(metadata);
        for (int i = 0; i < jsonArray.length(); ++i) {
            InstanceDiscoveryMetadata instanceDiscoveryMetadata = AuthorityValidationMetadataCache.processSingleJsonArray(new JSONObject(jsonArray.get(i).toString()));
            List<String> aliases = instanceDiscoveryMetadata.getAliases();
            for (String alias : aliases) {
                sAadAuthorityHostMetadata.put(alias.toLowerCase(Locale.US), instanceDiscoveryMetadata);
            }
        }
    }

    private static InstanceDiscoveryMetadata processSingleJsonArray(JSONObject jsonObject) throws JSONException {
        String preferredNetwork = jsonObject.getString(PREFERRED_NETWORK);
        String preferredCache = jsonObject.getString(PREFERRED_CACHE);
        JSONArray aliasArray = jsonObject.getJSONArray(ALIASES);
        ArrayList<String> aliases = new ArrayList<String>();
        for (int i = 0; i < aliasArray.length(); ++i) {
            aliases.add(aliasArray.getString(i));
        }
        return new InstanceDiscoveryMetadata(preferredNetwork, preferredCache, aliases);
    }
}

