/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.ExceptionExtensions;
import com.microsoft.aad.adal.HashMapExtensions;
import com.microsoft.aad.adal.HttpWebResponse;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;

public class AuthenticationException
extends Exception {
    static final long serialVersionUID = 1L;
    private ADALError mCode;
    private HashMap<String, String> mHttpResponseBody = null;
    private int mServiceStatusCode = -1;
    private HashMap<String, List<String>> mHttpResponseHeaders = null;

    public AuthenticationException() {
    }

    public AuthenticationException(ADALError code) {
        this.mCode = code;
    }

    public AuthenticationException(ADALError code, String details) {
        super(details);
        this.mCode = code;
    }

    public AuthenticationException(ADALError code, String details, Throwable throwable) {
        super(details, throwable);
        this.mCode = code;
        if (null == throwable) {
            return;
        }
        if (throwable instanceof AuthenticationException) {
            this.mServiceStatusCode = ((AuthenticationException)throwable).getServiceStatusCode();
            if (null != ((AuthenticationException)throwable).getHttpResponseBody()) {
                this.mHttpResponseBody = new HashMap<String, String>(((AuthenticationException)throwable).getHttpResponseBody());
            }
            if (null != ((AuthenticationException)throwable).getHttpResponseHeaders()) {
                this.mHttpResponseHeaders = new HashMap<String, List<String>>(((AuthenticationException)throwable).getHttpResponseHeaders());
            }
        }
    }

    public AuthenticationException(ADALError code, String details, HttpWebResponse response) {
        super(details);
        this.mCode = code;
        this.setHttpResponse(response);
    }

    public AuthenticationException(ADALError code, String details, HttpWebResponse response, Throwable throwable) {
        this(code, details, throwable);
        this.setHttpResponse(response);
    }

    public ADALError getCode() {
        return this.mCode;
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage(null);
    }

    public int getServiceStatusCode() {
        return this.mServiceStatusCode;
    }

    public HashMap<String, String> getHttpResponseBody() {
        return this.mHttpResponseBody;
    }

    public HashMap<String, List<String>> getHttpResponseHeaders() {
        return this.mHttpResponseHeaders;
    }

    void setHttpResponseBody(HashMap<String, String> body) {
        this.mHttpResponseBody = body;
    }

    void setHttpResponseHeaders(HashMap<String, List<String>> headers) {
        this.mHttpResponseHeaders = headers;
    }

    void setServiceStatusCode(int statusCode) {
        this.mServiceStatusCode = statusCode;
    }

    void setHttpResponse(HttpWebResponse response) {
        if (null != response) {
            this.mServiceStatusCode = response.getStatusCode();
            if (null != response.getResponseHeaders()) {
                this.mHttpResponseHeaders = new HashMap<String, List<String>>(response.getResponseHeaders());
            }
            if (null != response.getBody()) {
                try {
                    this.mHttpResponseBody = new HashMap<String, String>(HashMapExtensions.getJsonResponse(response));
                }
                catch (JSONException exception) {
                    Logger.e(AuthenticationException.class.getSimpleName(), "Json exception", ExceptionExtensions.getExceptionMessage((Exception)((Object)exception)), ADALError.SERVER_INVALID_JSON_RESPONSE);
                }
            }
        }
    }

    void setHttpResponse(AuthenticationResult result) {
        if (null != result) {
            this.mHttpResponseBody = result.getHttpResponseBody();
            this.mHttpResponseHeaders = result.getHttpResponseHeaders();
            this.mServiceStatusCode = result.getServiceStatusCode();
        }
    }

    public String getLocalizedMessage(Context context) {
        if (!StringExtensions.isNullOrBlank(super.getMessage())) {
            return super.getMessage();
        }
        if (this.mCode != null) {
            return this.mCode.getLocalizedDescription(context);
        }
        return null;
    }
}

