/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.text.TextUtils;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.ApplicationReceiver;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationServerProtocolException;
import com.microsoft.aad.adal.ChallengeResponseBuilder;
import com.microsoft.aad.adal.HttpAuthDialog;
import com.microsoft.aad.adal.JWSBuilder;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.UIEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;

abstract class BasicWebViewClient
extends WebViewClient {
    private static final String TAG = "BasicWebViewClient";
    public static final String BLANK_PAGE = "about:blank";
    private final String mRedirect;
    private final AuthenticationRequest mRequest;
    private final Context mCallingContext;
    private final UIEvent mUIEvent;

    public BasicWebViewClient(Context appContext, String redirect, AuthenticationRequest request, UIEvent uiEvent) {
        this.mCallingContext = appContext;
        this.mRedirect = redirect;
        this.mRequest = request;
        this.mUIEvent = uiEvent;
    }

    public abstract void showSpinner(boolean var1);

    public abstract void sendResponse(int var1, Intent var2);

    public abstract void cancelWebViewRequest();

    public abstract void prepareForBrokerResumeRequest();

    public abstract void setPKeyAuthStatus(boolean var1);

    public abstract void postRunnable(Runnable var1);

    public void onReceivedHttpAuthRequest(WebView view, final HttpAuthHandler handler, String host, String realm) {
        Logger.i(TAG, "onReceivedHttpAuthRequest for host:" + host, "");
        this.mUIEvent.setNTLM(true);
        HttpAuthDialog authDialog = new HttpAuthDialog(this.mCallingContext, host, realm);
        authDialog.setOkListener(new HttpAuthDialog.OkListener(){

            @Override
            public void onOk(String host, String realm, String username, String password) {
                Logger.i(BasicWebViewClient.TAG, "onReceivedHttpAuthRequest: handler proceed" + host, "");
                handler.proceed(username, password);
            }
        });
        authDialog.setCancelListener(new HttpAuthDialog.CancelListener(){

            @Override
            public void onCancel() {
                Logger.i(BasicWebViewClient.TAG, "onReceivedHttpAuthRequest: handler cancelled", "");
                handler.cancel();
                BasicWebViewClient.this.cancelWebViewRequest();
            }
        });
        Logger.i(TAG, "onReceivedHttpAuthRequest: show dialog", "");
        authDialog.show();
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        this.showSpinner(false);
        Logger.e(TAG, "Webview received an error. Errorcode:" + errorCode + " " + description, "", ADALError.ERROR_WEBVIEW);
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Error Code:" + errorCode);
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", description);
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mRequest);
        this.sendResponse(2002, resultIntent);
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        super.onReceivedSslError(view, handler, error);
        this.showSpinner(false);
        handler.cancel();
        Logger.e(TAG, "Received ssl error", "", ADALError.ERROR_FAILED_SSL_HANDSHAKE);
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Code:-11");
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", error.toString());
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mRequest);
        this.sendResponse(2002, resultIntent);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        view.setVisibility(0);
        if (!url.startsWith(BLANK_PAGE)) {
            this.showSpinner(false);
        }
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        this.logPageStartLoadingUrl(url);
        super.onPageStarted(view, url, favicon);
        this.showSpinner(true);
    }

    private void logPageStartLoadingUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            Logger.v(TAG, "onPageStarted: Null url for page to load.");
            return;
        }
        Uri uri = Uri.parse((String)url);
        if (uri.isOpaque()) {
            Logger.v(TAG, "onPageStarted: Non-hierarchical loading uri: " + url);
            return;
        }
        if (StringExtensions.isNullOrBlank(uri.getQueryParameter("code"))) {
            Logger.v(TAG, "Webview starts loading: " + uri.getHost() + uri.getPath(), "Full loading url is: " + url, null);
        } else {
            Logger.v(TAG, "Webview starts loading: " + uri.getHost() + uri.getPath() + " Auth code is returned for the loading url.");
        }
    }

    public boolean shouldOverrideUrlLoading(final WebView view, String url) {
        Logger.v(TAG, "Navigation is detected");
        if (url.startsWith("urn:http-auth:PKeyAuth")) {
            Logger.v(TAG, "Webview detected request for pkeyauth challenge.");
            view.stopLoading();
            this.setPKeyAuthStatus(true);
            final String challengeUrl = url;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ChallengeResponseBuilder certHandler = new ChallengeResponseBuilder(new JWSBuilder());
                        final ChallengeResponseBuilder.ChallengeResponse challengeResponse = certHandler.getChallengeResponseFromUri(challengeUrl);
                        final HashMap<String, String> headers = new HashMap<String, String>();
                        headers.put("Authorization", challengeResponse.getAuthorizationHeaderValue());
                        BasicWebViewClient.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                String loadUrl = challengeResponse.getSubmitUrl();
                                Logger.v(BasicWebViewClient.TAG, "Respond to pkeyAuth challenge", "Challenge submit url:" + challengeResponse.getSubmitUrl(), null);
                                view.loadUrl(loadUrl, headers);
                            }
                        });
                    }
                    catch (AuthenticationServerProtocolException e) {
                        Logger.e(BasicWebViewClient.TAG, "Argument exception", e.getMessage(), ADALError.ARGUMENT_EXCEPTION, e);
                        Intent resultIntent = new Intent();
                        resultIntent.putExtra("com.microsoft.aad.adal:AuthenticationException", (Serializable)e);
                        if (BasicWebViewClient.this.mRequest != null) {
                            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)BasicWebViewClient.this.mRequest);
                        }
                        BasicWebViewClient.this.sendResponse(2005, resultIntent);
                    }
                    catch (AuthenticationException e) {
                        Logger.e(BasicWebViewClient.TAG, "It is failed to create device certificate response", e.getMessage(), ADALError.DEVICE_CERTIFICATE_RESPONSE_FAILED, e);
                        Intent resultIntent = new Intent();
                        resultIntent.putExtra("com.microsoft.aad.adal:AuthenticationException", (Serializable)e);
                        if (BasicWebViewClient.this.mRequest != null) {
                            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)BasicWebViewClient.this.mRequest);
                        }
                        BasicWebViewClient.this.sendResponse(2005, resultIntent);
                    }
                }
            }).start();
            return true;
        }
        if (url.toLowerCase(Locale.US).startsWith(this.mRedirect.toLowerCase(Locale.US))) {
            Logger.v(TAG, "Navigation starts with the redirect uri.");
            if (this.hasCancelError(url)) {
                Logger.i(TAG, "Sending intent to cancel authentication activity", "");
                view.stopLoading();
                this.cancelWebViewRequest();
                return true;
            }
            this.processRedirectUrl(view, url);
            return true;
        }
        if (url.startsWith("browser://")) {
            Logger.v(TAG, "It is an external website request");
            this.openLinkInBrowser(url);
            view.stopLoading();
            this.cancelWebViewRequest();
            return true;
        }
        if (url.startsWith("msauth://")) {
            Logger.v(TAG, "It is an install request");
            ApplicationReceiver.saveRequest(this.mCallingContext, this.mRequest, url);
            HashMap<String, String> parameters = StringExtensions.getUrlParameters(url);
            this.prepareForBrokerResumeRequest();
            int threadSleepForCallingActivity = 1000;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Logger.v("BasicWebViewClient:shouldOverrideUrlLoading", "Error occured when having thread sleeping for 1 second");
            }
            this.openLinkInBrowser(parameters.get("app_link"));
            view.stopLoading();
            return true;
        }
        return this.processInvalidUrl(view, url);
    }

    public abstract void processRedirectUrl(WebView var1, String var2);

    public abstract boolean processInvalidUrl(WebView var1, String var2);

    final Context getCallingContext() {
        return this.mCallingContext;
    }

    protected void openLinkInBrowser(String url) {
        String link = url.replace("browser://", "https://");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
        this.mCallingContext.startActivity(intent);
    }

    private boolean hasCancelError(String redirectUrl) {
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(redirectUrl);
        String error = (String)parameters.get("error");
        String errorDescription = (String)parameters.get("error_description");
        if (!StringExtensions.isNullOrBlank(error)) {
            Logger.w(TAG, "Cancel error:" + error, errorDescription, null);
            return true;
        }
        return false;
    }
}

