/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Process;
import com.google.gson.Gson;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.BrokerProxy;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ApplicationReceiver
extends BroadcastReceiver {
    private static final String TAG = ApplicationReceiver.class.getSimpleName() + ":";
    public static final String INSTALL_REQUEST_TRACK_FILE = "adal.broker.install.track";
    public static final String INSTALL_REQUEST_KEY = "adal.broker.install.request";
    public static final String INSTALL_REQUEST_TIMESTAMP_KEY = "adal.broker.install.request.timestamp";
    private static final String INSTALL_UPN_KEY = "username";
    public static final String INSTALL_URL_KEY = "app_link";
    private static final int BROKER_APP_INSTALLATION_TIME_OUT = 5;
    private BrokerProxy mBrokerProxy;

    public void onReceive(Context context, Intent intent) {
        String methodName = "onReceive";
        if (!intent.getAction().equals("android.intent.action.PACKAGE_ADDED") || intent.getData() == null) {
            return;
        }
        Logger.v(TAG + "onReceive", "Application install message is received");
        Logger.v(TAG + "onReceive", "ApplicationReceiver detectes the installation of " + intent.getData().toString());
        String receivedInstalledPackageName = intent.getData().toString();
        if (receivedInstalledPackageName.equalsIgnoreCase("package:com.azure.authenticator") || receivedInstalledPackageName.equalsIgnoreCase("package:" + AuthenticationSettings.INSTANCE.getBrokerPackageName())) {
            String request = ApplicationReceiver.getInstallRequestInthisApp(context);
            this.mBrokerProxy = new BrokerProxy(context);
            Date dateTimeForSavedRequest = new Date(this.getInstallRequestTimeStamp(context));
            if (!StringExtensions.isNullOrBlank(request) && this.mBrokerProxy.canSwitchToBroker("") == BrokerProxy.SwitchToBroker.CAN_SWITCH_TO_BROKER && this.isRequestTimestampValidForResume(dateTimeForSavedRequest)) {
                Logger.v(TAG + "onReceive", receivedInstalledPackageName + " is installed, start sending request to broker.");
                this.resumeRequestInBroker(context, request);
            } else {
                Logger.v(TAG + "onReceive", "No request saved in sharedpreferences or request already timeout, cannot resume broker request.");
            }
        }
    }

    public static void saveRequest(Context ctx, AuthenticationRequest request, String url) {
        String methodName = "saveRequest";
        Logger.v(TAG + "saveRequest", "ApplicationReceiver starts to save the request in shared preference.");
        SharedPreferences prefs = ctx.getSharedPreferences(INSTALL_REQUEST_TRACK_FILE, 0);
        if (prefs != null) {
            HashMap<String, String> parameters = StringExtensions.getUrlParameters(url);
            if (parameters != null && parameters.containsKey(INSTALL_UPN_KEY)) {
                Logger.v(TAG + "saveRequest", "Coming redirect contains the UPN, setting it on the request for both loginhint and broker account name.");
                request.setLoginHint(parameters.get(INSTALL_UPN_KEY));
                request.setBrokerAccountName(parameters.get(INSTALL_UPN_KEY));
            }
            SharedPreferences.Editor prefsEditor = prefs.edit();
            Gson gson = new Gson();
            String jsonRequest = gson.toJson((Object)request);
            prefsEditor.putString(INSTALL_REQUEST_KEY, jsonRequest);
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            prefsEditor.putLong(INSTALL_REQUEST_TIMESTAMP_KEY, calendar.getTimeInMillis());
            prefsEditor.apply();
        } else {
            Logger.v(TAG + "saveRequest", "SharedPreference is null, nothing saved.");
        }
    }

    public static String getUserName(Context ctx) {
        Gson gson;
        AuthenticationRequest pendingRequest;
        Logger.v(TAG, "ApplicationReceiver:getUserName");
        String request = ApplicationReceiver.getInstallRequestInthisApp(ctx);
        if (!StringExtensions.isNullOrBlank(request) && (pendingRequest = (AuthenticationRequest)(gson = new Gson()).fromJson(request, AuthenticationRequest.class)) != null) {
            return pendingRequest.getBrokerAccountName();
        }
        return null;
    }

    public static String getInstallRequestInthisApp(Context context) {
        String methodName = "getInstallRequestInthisApp";
        Logger.v(TAG + "getInstallRequestInthisApp", "Retrieve saved request from shared preference.");
        SharedPreferences prefs = context.getSharedPreferences(INSTALL_REQUEST_TRACK_FILE, 0);
        if (prefs != null && prefs.contains(INSTALL_REQUEST_KEY)) {
            String request = prefs.getString(INSTALL_REQUEST_KEY, "");
            Logger.d(TAG + "getInstallRequestInthisApp", "Install request:" + request);
            return request;
        }
        Logger.v(TAG + "getInstallRequestInthisApp", "Unable to retrieve saved request from shared preference.");
        return "";
    }

    public static void clearUserName(Context ctx) {
        Logger.v(TAG, "ApplicationReceiver:clearUserName");
        SharedPreferences prefs = ctx.getSharedPreferences(INSTALL_REQUEST_TRACK_FILE, 0);
        if (prefs != null) {
            SharedPreferences.Editor prefsEditor = prefs.edit();
            prefsEditor.putString(INSTALL_REQUEST_KEY, "");
            prefsEditor.apply();
        }
    }

    private boolean isRequestTimestampValidForResume(Date savedRequestTimestamp) {
        String methodName = "isRequestTimestampValidForResume";
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        ((Calendar)calendar).add(12, -5);
        if (savedRequestTimestamp.compareTo(calendar.getTime()) >= 0) {
            Logger.v(TAG + "isRequestTimestampValidForResume", "Saved request is valid, not timeout yet.");
            return true;
        }
        Logger.v(TAG + "isRequestTimestampValidForResume", "Saved request is already timeout");
        return false;
    }

    private void resumeRequestInBroker(final Context context, String request) {
        String methodName = "resumeRequestInBroker";
        Logger.v(TAG + "resumeRequestInBroker", "Start resuming request in broker");
        Gson gson = new Gson();
        final AuthenticationRequest pendingRequest = (AuthenticationRequest)gson.fromJson(request, AuthenticationRequest.class);
        ExecutorService sThreadExecutor = Executors.newSingleThreadExecutor();
        sThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                boolean isIntentSafe;
                Logger.v(TAG + "resumeRequestInBroker", "Running task in thread:" + Process.myTid() + ", trying to get intent for broker activity.");
                Intent resumeIntent = ApplicationReceiver.this.mBrokerProxy.getIntentForBrokerActivity(pendingRequest);
                resumeIntent.setAction("android.intent.action.PICK");
                Logger.v(TAG + "resumeRequestInBroker", "Setting flag for broker resume request for calling package " + context.getPackageName());
                resumeIntent.putExtra("com.microsoft.aadbroker.adal.broker.request.resume", "com.microsoft.aadbroker.adal.broker.request.resume");
                resumeIntent.putExtra("caller.info.package", context.getPackageName());
                String brokerProtocolVersion = resumeIntent.getStringExtra("broker.version");
                if (StringExtensions.isNullOrBlank(brokerProtocolVersion)) {
                    Logger.v(TAG + "resumeRequestInBroker", "Broker request resume is not supported in the older version of broker.");
                    return;
                }
                PackageManager packageManager = context.getPackageManager();
                List activities = packageManager.queryIntentActivities(resumeIntent, 0);
                boolean bl = isIntentSafe = activities.size() > 0;
                if (isIntentSafe) {
                    Logger.v(TAG + "resumeRequestInBroker", "It's safe to start .ui.AccountChooserActivity.");
                    resumeIntent.setFlags(0x18000000);
                    context.startActivity(resumeIntent);
                } else {
                    Logger.v(TAG + "resumeRequestInBroker", "Unable to resolve .ui.AccountChooserActivity.");
                }
            }
        });
    }

    private long getInstallRequestTimeStamp(Context context) {
        String methodName = "getInstallRequestTimeStamp";
        Logger.v(TAG + "getInstallRequestTimeStamp", "Retrieve timestamp for saved request from shared preference.");
        SharedPreferences prefs = context.getSharedPreferences(INSTALL_REQUEST_TRACK_FILE, 0);
        if (prefs != null && prefs.contains(INSTALL_REQUEST_TIMESTAMP_KEY)) {
            long savedRequestTimeStamp = prefs.getLong(INSTALL_REQUEST_TIMESTAMP_KEY, 0L);
            Logger.v(TAG + "getInstallRequestTimeStamp", "Timestamp for saved request is: " + savedRequestTimeStamp);
            return savedRequestTimeStamp;
        }
        return 0L;
    }
}

