/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.ExceptionExtensions;
import com.microsoft.aad.adal.HttpWebRequest;
import com.microsoft.aad.adal.IWebRequestHandler;
import com.microsoft.aad.adal.JWSBuilder;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.Oauth2;
import com.microsoft.aad.adal.ServerRespondingWithRetryableException;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.TokenCacheAccessor;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.WebRequestHandler;
import java.io.IOException;

class AcquireTokenSilentHandler {
    private static final String TAG = AcquireTokenSilentHandler.class.getSimpleName();
    private final Context mContext;
    private final TokenCacheAccessor mTokenCacheAccessor;
    private final AuthenticationRequest mAuthRequest;
    private boolean mAttemptedWithMRRT = false;
    private TokenCacheItem mMrrtTokenCacheItem;
    private IWebRequestHandler mWebRequestHandler = null;

    AcquireTokenSilentHandler(Context context, AuthenticationRequest authRequest, TokenCacheAccessor tokenCacheAccessor) {
        if (context == null) {
            throw new IllegalArgumentException("context");
        }
        if (authRequest == null) {
            throw new IllegalArgumentException("authRequest");
        }
        this.mContext = context;
        this.mAuthRequest = authRequest;
        this.mTokenCacheAccessor = tokenCacheAccessor;
        this.mWebRequestHandler = new WebRequestHandler();
    }

    AuthenticationResult getAccessToken() throws AuthenticationException {
        if (this.mTokenCacheAccessor == null) {
            return null;
        }
        TokenCacheItem accessTokenItem = this.mTokenCacheAccessor.getATFromCache(this.mAuthRequest.getResource(), this.mAuthRequest.getClientId(), this.mAuthRequest.getUserFromRequest());
        if (accessTokenItem == null) {
            Logger.v(TAG, "No valid access token exists, try with refresh token.");
            return this.tryRT();
        }
        Logger.v(TAG, "Return AT from cache.");
        return AuthenticationResult.createResult(accessTokenItem);
    }

    AuthenticationResult acquireTokenWithRefreshToken(String refreshToken) throws AuthenticationException {
        AuthenticationResult result;
        Logger.v(TAG, "Try to get new access token with the found refresh token.", this.mAuthRequest.getLogInfo(), null);
        HttpWebRequest.throwIfNetworkNotAvaliable(this.mContext);
        try {
            JWSBuilder jwsBuilder = new JWSBuilder();
            Oauth2 oauthRequest = new Oauth2(this.mAuthRequest, this.mWebRequestHandler, jwsBuilder);
            result = oauthRequest.refreshToken(refreshToken);
            if (result != null && StringExtensions.isNullOrBlank(result.getRefreshToken())) {
                Logger.i(TAG, "Refresh token is not returned or empty", "");
                result.setRefreshToken(refreshToken);
            }
        }
        catch (ServerRespondingWithRetryableException exc) {
            Logger.i(TAG, "The server is not responding after the retry with error code: " + (Object)((Object)exc.getCode()), "");
            TokenCacheItem accessTokenItem = this.mTokenCacheAccessor.getStaleToken(this.mAuthRequest);
            if (accessTokenItem != null) {
                AuthenticationResult retryResult = AuthenticationResult.createExtendedLifeTimeResult(accessTokenItem);
                Logger.i(TAG, "The result with stale access token is returned.", "");
                return retryResult;
            }
            Logger.e(TAG, "Error in refresh token for request:" + this.mAuthRequest.getLogInfo(), ExceptionExtensions.getExceptionMessage(exc), ADALError.AUTH_FAILED_NO_TOKEN, new AuthenticationException(ADALError.SERVER_ERROR, exc.getMessage()));
            throw new AuthenticationException(ADALError.AUTH_FAILED_NO_TOKEN, ExceptionExtensions.getExceptionMessage(exc), new AuthenticationException(ADALError.SERVER_ERROR, exc.getMessage()));
        }
        catch (AuthenticationException | IOException exc) {
            Logger.e(TAG, "Error in refresh token for request:" + this.mAuthRequest.getLogInfo(), ExceptionExtensions.getExceptionMessage(exc), ADALError.AUTH_FAILED_NO_TOKEN, new AuthenticationException(ADALError.SERVER_ERROR, exc.getMessage()));
            throw new AuthenticationException(ADALError.AUTH_FAILED_NO_TOKEN, ExceptionExtensions.getExceptionMessage(exc), new AuthenticationException(ADALError.SERVER_ERROR, exc.getMessage()));
        }
        return result;
    }

    void setWebRequestHandler(IWebRequestHandler webRequestHandler) {
        this.mWebRequestHandler = webRequestHandler;
    }

    private AuthenticationResult tryRT() throws AuthenticationException {
        TokenCacheItem regularRTItem = this.mTokenCacheAccessor.getRegularRefreshTokenCacheItem(this.mAuthRequest.getResource(), this.mAuthRequest.getClientId(), this.mAuthRequest.getUserFromRequest());
        if (regularRTItem == null) {
            Logger.v(TAG, "Regular token cache entry does not exist, try with MRRT.");
            return this.tryMRRT();
        }
        if (regularRTItem.getIsMultiResourceRefreshToken() || this.isMRRTEntryExisted()) {
            String statusMessage = regularRTItem.getIsMultiResourceRefreshToken() ? "Found RT and it's also a MRRT, retry with MRRT" : "RT is found and there is a MRRT entry existed, try with MRRT";
            Logger.v(TAG, statusMessage);
            return this.tryMRRT();
        }
        Logger.v(TAG, "Send request to use regular RT for new AT.");
        return this.acquireTokenWithCachedItem(regularRTItem);
    }

    private AuthenticationResult tryMRRT() throws AuthenticationException {
        this.mMrrtTokenCacheItem = this.mTokenCacheAccessor.getMRRTItem(this.mAuthRequest.getClientId(), this.mAuthRequest.getUserFromRequest());
        if (this.mMrrtTokenCacheItem == null) {
            Logger.v(TAG, "MRRT token does not exist, try with FRT");
            return this.tryFRT("1", null);
        }
        if (this.mMrrtTokenCacheItem.isFamilyToken()) {
            Logger.v(TAG, "MRRT item exists but it's also a FRT, try with FRT.");
            return this.tryFRT(this.mMrrtTokenCacheItem.getFamilyClientId(), null);
        }
        AuthenticationResult mrrtResult = this.useMRRT();
        if (this.isTokenRequestFailed(mrrtResult)) {
            String familyClientId = StringExtensions.isNullOrBlank(this.mMrrtTokenCacheItem.getFamilyClientId()) ? "1" : this.mMrrtTokenCacheItem.getFamilyClientId();
            mrrtResult = this.tryFRT(familyClientId, mrrtResult);
        }
        return mrrtResult;
    }

    private AuthenticationResult tryFRT(String familyClientId, AuthenticationResult mrrtResult) throws AuthenticationException {
        TokenCacheItem frtTokenCacheItem = this.mTokenCacheAccessor.getFRTItem(familyClientId, this.mAuthRequest.getUserFromRequest());
        if (frtTokenCacheItem == null) {
            if (!this.mAttemptedWithMRRT) {
                Logger.v(TAG, "FRT cache item does not exist, fall back to try MRRT.");
                return this.useMRRT();
            }
            return mrrtResult;
        }
        Logger.v(TAG, "Send request to use FRT for new AT.");
        AuthenticationResult frtResult = this.acquireTokenWithCachedItem(frtTokenCacheItem);
        if (this.isTokenRequestFailed(frtResult) && !this.mAttemptedWithMRRT) {
            AuthenticationResult retryMrrtResult = this.useMRRT();
            frtResult = retryMrrtResult == null ? frtResult : retryMrrtResult;
        }
        return frtResult;
    }

    private AuthenticationResult useMRRT() throws AuthenticationException {
        Logger.v(TAG, "Send request to use MRRT for new AT.");
        this.mAttemptedWithMRRT = true;
        if (this.mMrrtTokenCacheItem == null) {
            Logger.v(TAG, "MRRT does not exist, cannot proceed with MRRT for new AT.");
            return null;
        }
        return this.acquireTokenWithCachedItem(this.mMrrtTokenCacheItem);
    }

    private AuthenticationResult acquireTokenWithCachedItem(TokenCacheItem cachedItem) throws AuthenticationException {
        if (StringExtensions.isNullOrBlank(cachedItem.getRefreshToken())) {
            Logger.v(TAG, "Token cache item contains empty refresh token, cannot continue refresh token request", this.mAuthRequest.getLogInfo(), null);
            return null;
        }
        AuthenticationResult result = this.acquireTokenWithRefreshToken(cachedItem.getRefreshToken());
        if (result != null && !result.isExtendedLifeTimeToken()) {
            this.mTokenCacheAccessor.updateCachedItemWithResult(this.mAuthRequest.getResource(), this.mAuthRequest.getClientId(), result, cachedItem);
        }
        return result;
    }

    private boolean isMRRTEntryExisted() {
        TokenCacheItem mrrtItem = this.mTokenCacheAccessor.getMRRTItem(this.mAuthRequest.getClientId(), this.mAuthRequest.getUserFromRequest());
        return mrrtItem != null && !StringExtensions.isNullOrBlank(mrrtItem.getRefreshToken());
    }

    private boolean isTokenRequestFailed(AuthenticationResult result) {
        return result != null && !StringExtensions.isNullOrBlank(result.getErrorCode());
    }
}

