/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.net.Uri;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.ClientMetrics;
import com.microsoft.aad.adal.HashMapExtensions;
import com.microsoft.aad.adal.HttpWebResponse;
import com.microsoft.aad.adal.IWebRequestHandler;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.UrlExtensions;
import com.microsoft.aad.adal.WebRequestHandler;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONException;

final class Discovery {
    private static final String TAG = "Discovery";
    private static final String API_VERSION_KEY = "api-version";
    private static final String API_VERSION_VALUE = "1.0";
    private static final String AUTHORIZATION_ENDPOINT_KEY = "authorization_endpoint";
    private static final String INSTANCE_DISCOVERY_SUFFIX = "common/discovery/instance";
    private static final String AUTHORIZATION_COMMON_ENDPOINT = "/common/oauth2/authorize";
    private static final String TENANT_DISCOVERY_ENDPOINT = "tenant_discovery_endpoint";
    private static final Set<String> VALID_HOSTS = Collections.synchronizedSet(new HashSet());
    private static final String TRUSTED_QUERY_INSTANCE = "login.windows.net";
    private UUID mCorrelationId;
    private final IWebRequestHandler mWebrequestHandler;

    public Discovery() {
        this.initValidList();
        this.mWebrequestHandler = new WebRequestHandler();
    }

    public void validateAuthority(URL authorizationEndpoint) throws AuthenticationException {
        if (authorizationEndpoint == null || StringExtensions.isNullOrBlank(authorizationEndpoint.getHost()) || !authorizationEndpoint.getProtocol().equals("https") || !StringExtensions.isNullOrBlank(authorizationEndpoint.getQuery()) || !StringExtensions.isNullOrBlank(authorizationEndpoint.getRef()) || StringExtensions.isNullOrBlank(authorizationEndpoint.getPath())) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE);
        }
        if (UrlExtensions.isADFSAuthority(authorizationEndpoint)) {
            Logger.e(TAG, "Instance validation returned error", "", ADALError.DEVELOPER_AUTHORITY_CAN_NOT_BE_VALIDED, new AuthenticationException(ADALError.DISCOVERY_NOT_SUPPORTED));
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE, "Cannot vaid ADFS authority", new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_CAN_NOT_BE_VALIDED));
        }
        if (!VALID_HOSTS.contains(authorizationEndpoint.getHost().toLowerCase(Locale.US))) {
            this.queryInstance(authorizationEndpoint);
        }
    }

    public void setCorrelationId(UUID requestCorrelationId) {
        this.mCorrelationId = requestCorrelationId;
    }

    private void initValidList() {
        if (VALID_HOSTS.isEmpty()) {
            VALID_HOSTS.add(TRUSTED_QUERY_INSTANCE);
            VALID_HOSTS.add("login.microsoftonline.com");
            VALID_HOSTS.add("login.chinacloudapi.cn");
            VALID_HOSTS.add("login.microsoftonline.de");
            VALID_HOSTS.add("login-us.microsoftonline.com");
        }
    }

    private void queryInstance(URL authorizationEndpointUrl) throws AuthenticationException {
        boolean result;
        try {
            URL queryUrl = this.buildQueryString(TRUSTED_QUERY_INSTANCE, this.getAuthorizationCommonEndpoint(authorizationEndpointUrl));
            result = this.sendRequest(queryUrl);
        }
        catch (IOException | JSONException e) {
            Logger.e(TAG, "Error when validating authority", "", ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL, e);
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE, e.getMessage(), e);
        }
        if (!result) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE);
        }
        this.addValidHostToList(authorizationEndpointUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendRequest(URL queryUrl) throws IOException, JSONException, AuthenticationException {
        Logger.v(TAG, "Sending discovery request to:" + queryUrl);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        if (this.mCorrelationId != null) {
            headers.put("client-request-id", this.mCorrelationId.toString());
            headers.put("return-client-request-id", "true");
        }
        try {
            ClientMetrics.INSTANCE.beginClientMetricsRecord(queryUrl, this.mCorrelationId, headers);
            HttpWebResponse webResponse = this.mWebrequestHandler.sendGet(queryUrl, headers);
            ClientMetrics.INSTANCE.setLastError(null);
            Map<String, String> discoveryResponse = this.parseResponse(webResponse);
            if (discoveryResponse.containsKey("error_codes")) {
                String errorCodes = discoveryResponse.get("error_codes");
                ClientMetrics.INSTANCE.setLastError(errorCodes);
                throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE, "Fail to valid authority with errors: " + errorCodes);
            }
            boolean bl = discoveryResponse.containsKey(TENANT_DISCOVERY_ENDPOINT);
            return bl;
        }
        finally {
            ClientMetrics.INSTANCE.endClientMetricsRecord("instance", this.mCorrelationId);
        }
    }

    private void addValidHostToList(URL validhost) {
        String validHost = validhost.getHost();
        if (!StringExtensions.isNullOrBlank(validHost)) {
            VALID_HOSTS.add(validHost.toLowerCase(Locale.US));
        }
    }

    private Map<String, String> parseResponse(HttpWebResponse webResponse) throws JSONException {
        return HashMapExtensions.getJsonResponse(webResponse);
    }

    private String getAuthorizationCommonEndpoint(URL authorizationEndpointUrl) {
        return new Uri.Builder().scheme("https").authority(authorizationEndpointUrl.getHost()).appendPath(AUTHORIZATION_COMMON_ENDPOINT).build().toString();
    }

    private URL buildQueryString(String instance, String authorizationEndpointUrl) throws MalformedURLException {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("https").authority(instance);
        builder.appendEncodedPath(INSTANCE_DISCOVERY_SUFFIX).appendQueryParameter(API_VERSION_KEY, API_VERSION_VALUE).appendQueryParameter(AUTHORIZATION_ENDPOINT_KEY, authorizationEndpointUrl);
        return new URL(builder.build().toString());
    }
}

