/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Handler;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AcquireTokenRequest;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.BasicWebViewClient;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.Oauth2;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

@SuppressLint(value={"InflateParams", "SetJavaScriptEnabled", "ClickableViewAccessibility"})
class AuthenticationDialog {
    protected static final String TAG = "AuthenticationDialog";
    private final Context mContext;
    private final AcquireTokenRequest mAcquireTokenRequest;
    private final AuthenticationRequest mRequest;
    private final Handler mHandlerInView;
    private Dialog mDialog;
    private WebView mWebView;

    public AuthenticationDialog(Handler handler, Context context, AcquireTokenRequest acquireTokenRequest, AuthenticationRequest request) {
        this.mHandlerInView = handler;
        this.mContext = context;
        this.mAcquireTokenRequest = acquireTokenRequest;
        this.mRequest = request;
    }

    private int getResourceId(String name, String type) {
        return this.mContext.getResources().getIdentifier(name, type, this.mContext.getPackageName());
    }

    public void show() {
        this.mHandlerInView.post(new Runnable(){

            @Override
            public void run() {
                LayoutInflater inflater = (LayoutInflater)AuthenticationDialog.this.mContext.getSystemService("layout_inflater");
                AlertDialog.Builder builder = new AlertDialog.Builder(AuthenticationDialog.this.mContext);
                View webviewInDialog = inflater.inflate(AuthenticationDialog.this.getResourceId("dialog_authentication", "layout"), null);
                AuthenticationDialog.this.mWebView = (WebView)webviewInDialog.findViewById(AuthenticationDialog.this.getResourceId("com_microsoft_aad_adal_webView1", "id"));
                if (AuthenticationDialog.this.mWebView == null) {
                    Logger.e(AuthenticationDialog.TAG, "Expected resource name for webview is com_microsoft_aad_adal_webView1. It is not in your layout file", "", ADALError.DEVELOPER_DIALOG_LAYOUT_INVALID);
                    Intent resultIntent = new Intent();
                    resultIntent.putExtra("com.microsoft.aad.adal:RequestId", AuthenticationDialog.this.mRequest.getRequestId());
                    AuthenticationDialog.this.mAcquireTokenRequest.onActivityResult(1001, 2001, resultIntent);
                    if (AuthenticationDialog.this.mHandlerInView != null) {
                        AuthenticationDialog.this.mHandlerInView.post(new Runnable(){

                            @Override
                            public void run() {
                                if (AuthenticationDialog.this.mDialog != null && AuthenticationDialog.this.mDialog.isShowing()) {
                                    AuthenticationDialog.this.mDialog.dismiss();
                                }
                            }
                        });
                    }
                    return;
                }
                if (!AuthenticationSettings.INSTANCE.getDisableWebViewHardwareAcceleration()) {
                    AuthenticationDialog.this.mWebView.setLayerType(1, null);
                    Log.d((String)AuthenticationDialog.TAG, (String)"Hardware acceleration is disabled in WebView");
                }
                AuthenticationDialog.this.mWebView.getSettings().setJavaScriptEnabled(true);
                AuthenticationDialog.this.mWebView.requestFocus(130);
                String userAgent = AuthenticationDialog.this.mWebView.getSettings().getUserAgentString();
                AuthenticationDialog.this.mWebView.getSettings().setUserAgentString(userAgent + " PKeyAuth/1.0");
                userAgent = AuthenticationDialog.this.mWebView.getSettings().getUserAgentString();
                Logger.v(AuthenticationDialog.TAG, "UserAgent:" + userAgent);
                AuthenticationDialog.this.mWebView.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View view, MotionEvent event) {
                        int action = event.getAction();
                        if (!(action != 0 && action != 1 || view.hasFocus())) {
                            view.requestFocus();
                        }
                        return false;
                    }
                });
                AuthenticationDialog.this.mWebView.getSettings().setLoadWithOverviewMode(true);
                AuthenticationDialog.this.mWebView.getSettings().setDomStorageEnabled(true);
                AuthenticationDialog.this.mWebView.getSettings().setUseWideViewPort(true);
                AuthenticationDialog.this.mWebView.getSettings().setBuiltInZoomControls(true);
                try {
                    Oauth2 oauth = new Oauth2(AuthenticationDialog.this.mRequest);
                    final String startUrl = oauth.getCodeRequestUrl();
                    String queryParameters = oauth.getAuthorizationEndpointQueryParameters();
                    String stopRedirect = AuthenticationDialog.this.mRequest.getRedirectUri();
                    AuthenticationDialog.this.mWebView.setWebViewClient((WebViewClient)new DialogWebViewClient(AuthenticationDialog.this.mContext, stopRedirect, queryParameters, AuthenticationDialog.this.mRequest));
                    AuthenticationDialog.this.mWebView.post(new Runnable(){

                        @Override
                        public void run() {
                            AuthenticationDialog.this.mWebView.loadUrl("about:blank");
                            AuthenticationDialog.this.mWebView.loadUrl(startUrl);
                        }
                    });
                }
                catch (UnsupportedEncodingException e) {
                    Logger.e(AuthenticationDialog.TAG, "Encoding error", "", ADALError.ENCODING_IS_NOT_SUPPORTED, e);
                }
                builder.setView(webviewInDialog).setCancelable(true);
                builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        AuthenticationDialog.this.cancelFlow();
                    }
                });
                AuthenticationDialog.this.mDialog = (Dialog)builder.create();
                Logger.i(AuthenticationDialog.TAG, "Showing authenticationDialog", "");
                AuthenticationDialog.this.mDialog.show();
            }
        });
    }

    private void cancelFlow() {
        Logger.i(TAG, "Cancelling dialog", "");
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:RequestId", this.mRequest.getRequestId());
        this.mAcquireTokenRequest.onActivityResult(1001, 2001, resultIntent);
        if (this.mHandlerInView != null) {
            this.mHandlerInView.post(new Runnable(){

                @Override
                public void run() {
                    if (AuthenticationDialog.this.mDialog != null && AuthenticationDialog.this.mDialog.isShowing()) {
                        AuthenticationDialog.this.mDialog.dismiss();
                    }
                }
            });
        }
    }

    class DialogWebViewClient
    extends BasicWebViewClient {
        public DialogWebViewClient(Context ctx, String stopRedirect, String queryParam, AuthenticationRequest request) {
            super(ctx, stopRedirect, queryParam, request);
        }

        @Override
        public void showSpinner(final boolean status) {
            if (AuthenticationDialog.this.mHandlerInView != null) {
                AuthenticationDialog.this.mHandlerInView.post(new Runnable(){

                    @Override
                    public void run() {
                        ProgressBar progressBar;
                        if (AuthenticationDialog.this.mDialog != null && AuthenticationDialog.this.mDialog.isShowing() && (progressBar = (ProgressBar)AuthenticationDialog.this.mDialog.findViewById(AuthenticationDialog.this.getResourceId("com_microsoft_aad_adal_progressBar", "id"))) != null) {
                            int showFlag = status ? 0 : 4;
                            progressBar.setVisibility(showFlag);
                        }
                    }
                });
            }
        }

        @Override
        public void sendResponse(int returnCode, Intent responseIntent) {
            AuthenticationDialog.this.mDialog.dismiss();
            AuthenticationDialog.this.mAcquireTokenRequest.onActivityResult(1001, returnCode, responseIntent);
        }

        @Override
        public void postRunnable(Runnable item) {
            AuthenticationDialog.this.mHandlerInView.post(item);
        }

        @Override
        public void processRedirectUrl(WebView view, String url) {
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserFinalUrl", url);
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)AuthenticationDialog.this.mRequest);
            resultIntent.putExtra("com.microsoft.aad.adal:RequestId", AuthenticationDialog.this.mRequest.getRequestId());
            this.sendResponse(2003, resultIntent);
            view.stopLoading();
        }

        @Override
        public void cancelWebViewRequest() {
            AuthenticationDialog.this.cancelFlow();
        }

        @Override
        public void setPKeyAuthStatus(boolean status) {
        }

        @Override
        public boolean processInvalidUrl(WebView view, String url) {
            return false;
        }

        @Override
        public void prepareForBrokerResumeRequest() {
        }
    }
}

