/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Process;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationContext;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.IBrokerProxy;
import com.microsoft.aad.adal.IWindowComponent;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;

final class AcquireTokenWithBrokerRequest {
    private static final String TAG = AcquireTokenWithBrokerRequest.class.getSimpleName();
    private final AuthenticationRequest mAuthRequest;
    private final IBrokerProxy mBrokerProxy;

    AcquireTokenWithBrokerRequest(AuthenticationRequest authRequest, IBrokerProxy brokerProxy) {
        this.mAuthRequest = authRequest;
        this.mBrokerProxy = brokerProxy;
    }

    AuthenticationResult acquireTokenWithBrokerSilent() throws AuthenticationException {
        AuthenticationResult authenticationResult;
        this.mAuthRequest.setVersion(AuthenticationContext.getVersionName());
        this.mAuthRequest.setBrokerAccountName(this.mAuthRequest.getLoginHint());
        this.logBrokerVersion();
        if (!StringExtensions.isNullOrBlank(this.mAuthRequest.getBrokerAccountName()) || !StringExtensions.isNullOrBlank(this.mAuthRequest.getUserId())) {
            Logger.v(TAG, "User is specified for background(silent) token request, trying to acquire token silently.");
            authenticationResult = this.mBrokerProxy.getAuthTokenInBackground(this.mAuthRequest);
        } else {
            Logger.v(TAG, "User is not specified, skipping background(silent) token request");
            authenticationResult = null;
        }
        return authenticationResult;
    }

    void acquireTokenWithBrokerInteractively(IWindowComponent activity) throws AuthenticationException {
        Logger.v(TAG, "Launch activity for interactive authentication via broker.");
        this.logBrokerVersion();
        Intent brokerIntent = this.mBrokerProxy.getIntentForBrokerActivity(this.mAuthRequest);
        if (brokerIntent == null) {
            throw new AuthenticationException(ADALError.DEVELOPER_ACTIVITY_IS_NOT_RESOLVED);
        }
        Logger.v(TAG, "Calling activity pid:" + Process.myPid() + " tid:" + Process.myTid() + "uid:" + Process.myUid());
        activity.startActivityForResult(brokerIntent, 1001);
    }

    private void logBrokerVersion() {
        String brokerAppVersion;
        String currentActiveBrokerPackageName = this.mBrokerProxy.getCurrentActiveBrokerPackageName();
        if (StringExtensions.isNullOrBlank(currentActiveBrokerPackageName)) {
            Logger.i(TAG, "Broker app package name is empty.", "");
            return;
        }
        try {
            brokerAppVersion = this.mBrokerProxy.getBrokerAppVersion(currentActiveBrokerPackageName);
        }
        catch (PackageManager.NameNotFoundException e) {
            brokerAppVersion = "N/A";
        }
        String brokerLogging = "Broker app is: " + currentActiveBrokerPackageName + ";Broker app version: " + brokerAppVersion;
        Logger.i(TAG, brokerLogging, "");
    }
}

