/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.IDeviceCertificate;
import com.microsoft.aad.adal.IJWSBuilder;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

class ChallangeResponseBuilder {
    private static final String TAG = "ChallangeResponseBuilder";
    private IJWSBuilder mJWSBuilder;

    ChallangeResponseBuilder(IJWSBuilder jwsBuilder) {
        this.mJWSBuilder = jwsBuilder;
    }

    public ChallangeResponse getChallangeResponseFromUri(String redirectUri) {
        ChallangeRequest request = this.getChallangeRequest(redirectUri);
        return this.getDeviceCertResponse(request);
    }

    public ChallangeResponse getChallangeResponseFromHeader(String challangeHeaderValue, String endpoint) throws UnsupportedEncodingException {
        ChallangeRequest request = this.getChallangeRequestFromHeader(challangeHeaderValue);
        request.mSubmitUrl = endpoint;
        return this.getDeviceCertResponse(request);
    }

    private ChallangeResponse getDeviceCertResponse(ChallangeRequest request) {
        IDeviceCertificate deviceCertProxy;
        ChallangeResponse response = this.getNoDeviceCertResponse(request);
        response.mSubmitUrl = request.mSubmitUrl;
        Class<IDeviceCertificate> certClazz = AuthenticationSettings.INSTANCE.getDeviceCertificateProxy();
        if (certClazz != null && ((deviceCertProxy = this.getWPJAPIInstance(certClazz)).isValidIssuer(request.mCertAuthorities) || deviceCertProxy.getThumbPrint() != null && deviceCertProxy.getThumbPrint().equalsIgnoreCase(request.mThumbprint))) {
            RSAPrivateKey privateKey = deviceCertProxy.getRSAPrivateKey();
            if (privateKey != null) {
                String jwt = this.mJWSBuilder.generateSignedJWT(request.mNonce, request.mSubmitUrl, privateKey, deviceCertProxy.getRSAPublicKey(), deviceCertProxy.getCertificate());
                response.mAuthorizationHeaderValue = String.format("%s AuthToken=\"%s\",Context=\"%s\",Version=\"%s\"", "PKeyAuth", jwt, request.mContext, request.mVersion);
                Logger.v(TAG, "Challange response:" + response.mAuthorizationHeaderValue);
            } else {
                throw new AuthenticationException(ADALError.KEY_CHAIN_PRIVATE_KEY_EXCEPTION);
            }
        }
        return response;
    }

    private IDeviceCertificate getWPJAPIInstance(Class<IDeviceCertificate> certClazz) {
        IDeviceCertificate deviceCertProxy = null;
        try {
            Constructor<IDeviceCertificate> constructor = certClazz.getDeclaredConstructor(new Class[0]);
            deviceCertProxy = constructor.newInstance(null);
        }
        catch (NoSuchMethodException e) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_API_EXCEPTION, "WPJ Api constructor is not defined", e);
        }
        catch (InstantiationException e) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_API_EXCEPTION, "WPJ Api constructor is not defined", e);
        }
        catch (IllegalAccessException e) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_API_EXCEPTION, "WPJ Api constructor is not defined", e);
        }
        catch (IllegalArgumentException e) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_API_EXCEPTION, "WPJ Api constructor is not defined", e);
        }
        catch (InvocationTargetException e) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_API_EXCEPTION, "WPJ Api constructor is not defined", e);
        }
        return deviceCertProxy;
    }

    private ChallangeResponse getNoDeviceCertResponse(ChallangeRequest request) {
        ChallangeResponse response = new ChallangeResponse();
        response.mSubmitUrl = request.mSubmitUrl;
        response.mAuthorizationHeaderValue = String.format("%s Context=\"%s\",Version=\"%s\"", "PKeyAuth", request.mContext, request.mVersion);
        return response;
    }

    private ChallangeRequest getChallangeRequestFromHeader(String headerValue) throws UnsupportedEncodingException {
        if (StringExtensions.IsNullOrBlank(headerValue)) {
            throw new IllegalArgumentException("headerValue");
        }
        if (!StringExtensions.hasPrefixInHeader(headerValue, "PKeyAuth")) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, headerValue);
        }
        ChallangeRequest challange = new ChallangeRequest();
        String authenticateHeader = headerValue.substring("PKeyAuth".length());
        ArrayList<String> queryPairs = StringExtensions.splitWithQuotes(authenticateHeader, ',');
        HashMap<String, String> headerItems = new HashMap<String, String>();
        for (String queryPair : queryPairs) {
            ArrayList<String> pair = StringExtensions.splitWithQuotes(queryPair, '=');
            if (pair.size() == 2 && !StringExtensions.IsNullOrBlank(pair.get(0)) && !StringExtensions.IsNullOrBlank(pair.get(1))) {
                String key = pair.get(0);
                String value = pair.get(1);
                key = StringExtensions.URLFormDecode(key);
                value = StringExtensions.URLFormDecode(value);
                key = key.trim();
                value = StringExtensions.removeQuoteInHeaderValue(value.trim());
                headerItems.put(key, value);
                continue;
            }
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, authenticateHeader);
        }
        this.validateChallangeRequest(headerItems, false);
        challange.mNonce = headerItems.get(RequestField.Nonce.name());
        if (StringExtensions.IsNullOrBlank(challange.mNonce)) {
            challange.mNonce = headerItems.get(RequestField.Nonce.name().toLowerCase(Locale.US));
        }
        challange.mThumbprint = headerItems.get(RequestField.CertThumbprint.name());
        if (StringExtensions.IsNullOrBlank(challange.mThumbprint)) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "CertThumbprint is not present in the header");
        }
        challange.mVersion = headerItems.get(RequestField.Version.name());
        challange.mContext = headerItems.get(RequestField.Context.name());
        return challange;
    }

    private void validateChallangeRequest(HashMap<String, String> headerItems, boolean redirectFormat) {
        if (!headerItems.containsKey(RequestField.Nonce.name()) && !headerItems.containsKey(RequestField.Nonce.name().toLowerCase(Locale.US))) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "Nonce");
        }
        if (!headerItems.containsKey(RequestField.Version.name())) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "Version");
        }
        if (redirectFormat && !headerItems.containsKey(RequestField.SubmitUrl.name())) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "SubmitUrl");
        }
        if (!headerItems.containsKey(RequestField.Context.name())) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "Context");
        }
        if (redirectFormat && !headerItems.containsKey(RequestField.CertAuthorities.name())) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "CertAuthorities");
        }
    }

    private ChallangeRequest getChallangeRequest(String redirectUri) {
        if (StringExtensions.IsNullOrBlank(redirectUri)) {
            throw new IllegalArgumentException("redirectUri");
        }
        ChallangeRequest challange = new ChallangeRequest();
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(redirectUri);
        this.validateChallangeRequest(parameters, true);
        challange.mNonce = parameters.get(RequestField.Nonce.name());
        if (StringExtensions.IsNullOrBlank(challange.mNonce)) {
            challange.mNonce = parameters.get(RequestField.Nonce.name().toLowerCase(Locale.US));
        }
        String authorities = parameters.get(RequestField.CertAuthorities.name());
        Logger.v(TAG, "Cert authorities:" + authorities);
        challange.mCertAuthorities = StringExtensions.getStringTokens(authorities, ";");
        challange.mVersion = parameters.get(RequestField.Version.name());
        challange.mSubmitUrl = parameters.get(RequestField.SubmitUrl.name());
        challange.mContext = parameters.get(RequestField.Context.name());
        return challange;
    }

    class ChallangeRequest {
        String mNonce = "";
        String mContext = "";
        List<String> mCertAuthorities;
        String mThumbprint = "";
        String mVersion = null;
        String mSubmitUrl = "";

        ChallangeRequest() {
        }
    }

    static enum RequestField {
        Nonce,
        CertAuthorities,
        Version,
        SubmitUrl,
        Context,
        CertThumbprint;

    }

    class ChallangeResponse {
        String mSubmitUrl;
        String mAuthorizationHeaderValue;

        ChallangeResponse() {
        }

        public String getSubmitUrl() {
            return this.mSubmitUrl;
        }

        public String getAuthorizationHeaderValue() {
            return this.mAuthorizationHeaderValue;
        }
    }
}

