/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.network.google;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.MultipartContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.hpe.adm.nga.sdk.Octane;
import com.hpe.adm.nga.sdk.authentication.Authentication;
import com.hpe.adm.nga.sdk.authentication.BasicAuthentication;
import com.hpe.adm.nga.sdk.authentication.JSONAuthentication;
import com.hpe.adm.nga.sdk.entities.OctaneCollection;
import com.hpe.adm.nga.sdk.exception.OctaneException;
import com.hpe.adm.nga.sdk.exception.OctanePartialException;
import com.hpe.adm.nga.sdk.model.EntityModel;
import com.hpe.adm.nga.sdk.model.ErrorModel;
import com.hpe.adm.nga.sdk.model.LongFieldModel;
import com.hpe.adm.nga.sdk.model.ModelParser;
import com.hpe.adm.nga.sdk.model.StringFieldModel;
import com.hpe.adm.nga.sdk.network.OctaneHttpClient;
import com.hpe.adm.nga.sdk.network.OctaneHttpRequest;
import com.hpe.adm.nga.sdk.network.OctaneHttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleHttpClient
implements OctaneHttpClient {
    private static final Logger logger = LoggerFactory.getLogger((String)GoogleHttpClient.class.getName());
    private static final String LOGGER_REQUEST_FORMAT = "Request: {} - {} - {}";
    private static final String LOGGER_RESPONSE_FORMAT = "Response: {} - {} - {}";
    private static final String SET_COOKIE = "set-cookie";
    private static final String HTTP_MEDIA_TYPE_MULTIPART_NAME = "multipart/form-data";
    private static final String HTTP_MULTIPART_BOUNDARY_NAME = "boundary";
    private static final String HTTP_MULTIPART_BOUNDARY_VALUE = "---------------------------92348603315617859231724135434";
    private static final String HTTP_MULTIPART_PART_DISPOSITION_NAME = "Content-Disposition";
    private static final String HTTP_MULTIPART_PART1_DISPOSITION_FORMAT = "form-data; name=\"%s\"; filename=\"blob\"";
    private static final String HTTP_MULTIPART_PART1_DISPOSITION_ENTITY_VALUE = "entity";
    private static final String HTTP_MULTIPART_PART2_DISPOSITION_FORMAT = "form-data; name=\"content\"; filename=\"%s\"";
    private static final String ERROR_CODE_TOKEN_EXPIRED = "VALIDATION_TOKEN_EXPIRED_IDLE_TIME_OUT";
    private static final String ERROR_CODE_GLOBAL_TOKEN_EXPIRED = "VALIDATION_TOKEN_EXPIRED_GLOBAL_TIME_OUT";
    private static final int HTTP_REQUEST_RETRY_COUNT = 1;
    protected HttpRequestFactory requestFactory;
    protected String lwssoValue = "";
    protected String octaneUserValue;
    protected final String urlDomain;
    protected Authentication lastUsedAuthentication;
    protected Date lastSuccessfulAuthTimestamp;
    private final Map<OctaneHttpRequest, OctaneHttpResponse> cachedRequestToResponse = new HashMap<OctaneHttpRequest, OctaneHttpResponse>();
    private final Map<OctaneHttpRequest, String> requestToEtagMap = new HashMap<OctaneHttpRequest, String>();
    private Consumer<HttpRequest> customRequestInitializer;
    private final Consumer<HttpRequest> defaultRequestInitializer;
    protected HttpRequestInitializer requestInitializer;

    public GoogleHttpClient(String urlDomain, Authentication authentication) {
        this.customRequestInitializer = request -> {};
        this.defaultRequestInitializer = request -> {
            request.setResponseInterceptor(response -> {
                HttpHeaders responseHeaders = response.getHeaders();
                this.updateLWSSOCookieValue(responseHeaders);
            });
            request.setUnsuccessfulResponseHandler((httpRequest, httpResponse, b) -> false);
            StringBuilder cookieBuilder = new StringBuilder();
            if (this.lwssoValue != null && !this.lwssoValue.isEmpty()) {
                cookieBuilder.append("LWSSO_COOKIE_KEY").append("=").append(this.lwssoValue);
            }
            if (this.octaneUserValue != null && !this.octaneUserValue.isEmpty()) {
                cookieBuilder.append(";").append("OCTANE_USER").append("=").append(this.octaneUserValue);
            }
            request.getHeaders().setCookie(cookieBuilder.toString());
            if (this.lastUsedAuthentication != null) {
                if (this.lastUsedAuthentication.isBasicAuthentication()) {
                    BasicAuthentication basicAuthentication = (BasicAuthentication)this.lastUsedAuthentication;
                    request.getHeaders().setBasicAuthentication(basicAuthentication.getAuthenticationId(), basicAuthentication.getAuthenticationSecret());
                }
                this.lastUsedAuthentication.getAPIMode().ifPresent(apiMode -> request.getHeaders().set(apiMode.getHeaderKey(), (Object)apiMode.getHeaderValue()));
            }
            request.setReadTimeout(60000);
        };
        this.requestInitializer = request -> this.defaultRequestInitializer.andThen(this.customRequestInitializer).accept(request);
        this.urlDomain = urlDomain;
        this.lastUsedAuthentication = authentication;
        this.logSystemProperties();
        this.requestFactory = this.buildRequestFactory();
    }

    public GoogleHttpClient(String urlDomain, Authentication authentication, Octane.OctaneCustomSettings settings) throws RuntimeException {
        this.customRequestInitializer = request -> {};
        this.defaultRequestInitializer = request -> {
            request.setResponseInterceptor(response -> {
                HttpHeaders responseHeaders = response.getHeaders();
                this.updateLWSSOCookieValue(responseHeaders);
            });
            request.setUnsuccessfulResponseHandler((httpRequest, httpResponse, b) -> false);
            StringBuilder cookieBuilder = new StringBuilder();
            if (this.lwssoValue != null && !this.lwssoValue.isEmpty()) {
                cookieBuilder.append("LWSSO_COOKIE_KEY").append("=").append(this.lwssoValue);
            }
            if (this.octaneUserValue != null && !this.octaneUserValue.isEmpty()) {
                cookieBuilder.append(";").append("OCTANE_USER").append("=").append(this.octaneUserValue);
            }
            request.getHeaders().setCookie(cookieBuilder.toString());
            if (this.lastUsedAuthentication != null) {
                if (this.lastUsedAuthentication.isBasicAuthentication()) {
                    BasicAuthentication basicAuthentication = (BasicAuthentication)this.lastUsedAuthentication;
                    request.getHeaders().setBasicAuthentication(basicAuthentication.getAuthenticationId(), basicAuthentication.getAuthenticationSecret());
                }
                this.lastUsedAuthentication.getAPIMode().ifPresent(apiMode -> request.getHeaders().set(apiMode.getHeaderKey(), (Object)apiMode.getHeaderValue()));
            }
            request.setReadTimeout(60000);
        };
        this.requestInitializer = request -> this.defaultRequestInitializer.andThen(this.customRequestInitializer).accept(request);
        this.urlDomain = urlDomain;
        this.logSystemProperties();
        this.lastUsedAuthentication = authentication;
        this.customRequestInitializer = request -> {
            request.setReadTimeout(((Integer)settings.get(Octane.OctaneCustomSettings.Setting.READ_TIMEOUT)).intValue());
            request.setConnectTimeout(((Integer)settings.get(Octane.OctaneCustomSettings.Setting.CONNECTION_TIMEOUT)).intValue());
        };
        HttpTransport httpTransport = (HttpTransport)settings.get(Octane.OctaneCustomSettings.Setting.SHARED_HTTP_TRANSPORT);
        boolean trustAllCerts = (Boolean)settings.get(Octane.OctaneCustomSettings.Setting.TRUST_ALL_CERTS);
        this.requestFactory = httpTransport != null ? httpTransport.createRequestFactory(this.requestInitializer) : (trustAllCerts ? this.buildPermissiveRequestFactory() : this.buildRequestFactory());
    }

    private HttpRequestFactory buildPermissiveRequestFactory() {
        NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
        try {
            builder.doNotValidateCertificate();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("A security exception occurred while disabling certificate validation", e);
        }
        NetHttpTransport httpTransport = builder.build();
        return httpTransport.createRequestFactory(this.requestInitializer);
    }

    private HttpRequestFactory buildRequestFactory() {
        NetHttpTransport httpTransport = new NetHttpTransport();
        return httpTransport.createRequestFactory(this.requestInitializer);
    }

    private void logSystemProperties() {
        GoogleHttpClient.logProxySystemProperties();
        GoogleHttpClient.logSystemProxyForUrlDomain(this.urlDomain);
    }

    @Override
    public synchronized boolean authenticate() {
        if (this.lastUsedAuthentication == null) {
            return false;
        }
        if (this.lastUsedAuthentication.isBasicAuthentication()) {
            return true;
        }
        this.lwssoValue = null;
        this.octaneUserValue = null;
        try {
            ByteArrayContent content = ByteArrayContent.fromString((String)"application/json", (String)((JSONAuthentication)this.lastUsedAuthentication).getAuthenticationString());
            HttpRequest httpRequest = this.requestFactory.buildPostRequest(new GenericUrl(this.urlDomain + "/authentication/sign_in"), (HttpContent)content);
            this.lastUsedAuthentication.getAPIMode().ifPresent(apiMode -> httpRequest.getHeaders().remove((Object)apiMode.getHeaderKey()));
            HttpResponse response = this.executeRequest(httpRequest);
            if (response.isSuccessStatusCode()) {
                this.lastSuccessfulAuthTimestamp = new Date();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void signOut() {
        GenericUrl genericUrl = new GenericUrl(this.urlDomain + "/authentication/sign_out");
        HttpRequest httpRequest = null;
        try {
            httpRequest = this.requestFactory.buildPostRequest(genericUrl, null);
            HttpResponse response = this.executeRequest(httpRequest);
            if (response.isSuccessStatusCode()) {
                HttpHeaders hdr1 = response.getHeaders();
                this.updateLWSSOCookieValue(hdr1);
                this.lastUsedAuthentication = null;
            }
        }
        catch (Exception e) {
            throw GoogleHttpClient.wrapException(e, httpRequest);
        }
    }

    protected HttpRequest convertOctaneRequestToGoogleHttpRequest(OctaneHttpRequest octaneHttpRequest) {
        HttpRequest httpRequest;
        try {
            switch (octaneHttpRequest.getOctaneRequestMethod()) {
                case GET: {
                    GenericUrl domain = new GenericUrl(octaneHttpRequest.getRequestUrl());
                    httpRequest = this.requestFactory.buildGetRequest(domain);
                    httpRequest.getHeaders().setAccept(((OctaneHttpRequest.GetOctaneHttpRequest)octaneHttpRequest).getAcceptType());
                    String eTagHeader = this.requestToEtagMap.get(octaneHttpRequest);
                    if (eTagHeader == null) break;
                    httpRequest.getHeaders().setETag(eTagHeader);
                    break;
                }
                case POST: {
                    OctaneHttpRequest.PostOctaneHttpRequest postOctaneHttpRequest = (OctaneHttpRequest.PostOctaneHttpRequest)octaneHttpRequest;
                    GenericUrl domain = new GenericUrl(octaneHttpRequest.getRequestUrl());
                    httpRequest = this.requestFactory.buildPostRequest(domain, (HttpContent)ByteArrayContent.fromString(null, (String)postOctaneHttpRequest.getContent()));
                    httpRequest.getHeaders().setAccept(postOctaneHttpRequest.getAcceptType());
                    httpRequest.getHeaders().setContentType(postOctaneHttpRequest.getContentType());
                    break;
                }
                case POST_BINARY: {
                    httpRequest = this.buildBinaryPostRequest((OctaneHttpRequest.PostBinaryOctaneHttpRequest)octaneHttpRequest);
                    break;
                }
                case PUT: {
                    OctaneHttpRequest.PutOctaneHttpRequest putHttpOctaneHttpRequest = (OctaneHttpRequest.PutOctaneHttpRequest)octaneHttpRequest;
                    GenericUrl domain = new GenericUrl(octaneHttpRequest.getRequestUrl());
                    httpRequest = this.requestFactory.buildPutRequest(domain, (HttpContent)ByteArrayContent.fromString(null, (String)putHttpOctaneHttpRequest.getContent()));
                    httpRequest.getHeaders().setAccept(putHttpOctaneHttpRequest.getAcceptType());
                    httpRequest.getHeaders().setContentType(putHttpOctaneHttpRequest.getContentType());
                    break;
                }
                case DELETE: {
                    GenericUrl domain = new GenericUrl(octaneHttpRequest.getRequestUrl());
                    httpRequest = this.requestFactory.buildDeleteRequest(domain);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Request method not known!");
                }
            }
            octaneHttpRequest.getHeaders().forEach(header -> httpRequest.getHeaders().set(header.getHeaderKey(), (Object)header.getHeaderValue()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return httpRequest;
    }

    protected OctaneHttpResponse convertHttpResponseToOctaneHttpResponse(HttpResponse httpResponse) {
        try {
            Charset charset = Objects.nonNull(httpResponse.getContentType()) && httpResponse.getContentType().equals("application/json") ? StandardCharsets.UTF_8 : httpResponse.getContentCharset();
            return new OctaneHttpResponse(httpResponse.getStatusCode(), httpResponse.getContent(), charset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public OctaneHttpResponse execute(OctaneHttpRequest octaneHttpRequest) {
        return this.execute(octaneHttpRequest, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OctaneHttpResponse execute(OctaneHttpRequest octaneHttpRequest, int retryCount) {
        HttpRequest httpRequest = this.convertOctaneRequestToGoogleHttpRequest(octaneHttpRequest);
        try {
            HttpResponse httpResponse = this.executeRequest(httpRequest);
            OctaneHttpResponse octaneHttpResponse = this.convertHttpResponseToOctaneHttpResponse(httpResponse);
            String eTag = httpResponse.getHeaders().getETag();
            if (eTag != null) {
                this.requestToEtagMap.put(octaneHttpRequest, eTag);
                this.cachedRequestToResponse.put(octaneHttpRequest, octaneHttpResponse);
            }
            return octaneHttpResponse;
        }
        catch (RuntimeException exception) {
            HttpResponseException httpResponseException;
            int statusCode;
            if (exception.getCause() instanceof HttpResponseException && (statusCode = (httpResponseException = (HttpResponseException)exception.getCause()).getStatusCode()) == 304) {
                return this.cachedRequestToResponse.get(octaneHttpRequest);
            }
            if (retryCount > 0 && exception instanceof OctaneException) {
                OctaneException octaneException = (OctaneException)exception;
                StringFieldModel errorCodeFieldModel = (StringFieldModel)octaneException.getError().getValue("errorCode");
                LongFieldModel httpStatusCode = (LongFieldModel)octaneException.getError().getValue("http_status_code");
                if (errorCodeFieldModel != null && httpStatusCode.getValue() == 401L && (ERROR_CODE_TOKEN_EXPIRED.equals(errorCodeFieldModel.getValue()) || ERROR_CODE_GLOBAL_TOKEN_EXPIRED.equals(errorCodeFieldModel.getValue())) && this.lastUsedAuthentication != null) {
                    Date currentTimestamp = new Date();
                    GoogleHttpClient googleHttpClient = this;
                    synchronized (googleHttpClient) {
                        if (this.lastSuccessfulAuthTimestamp.getTime() < currentTimestamp.getTime()) {
                            logger.debug("Auth token expired, trying to re-authenticate");
                            try {
                                this.authenticate();
                            }
                            catch (OctaneException ex) {
                                logger.debug("Exception while retrying authentication: {}", (Object)ex.getMessage());
                            }
                        } else {
                            logger.debug("Auth token expired, but re-authentication was handled by another thread, will not re-authenticate");
                        }
                        logger.debug("Retrying request, retries left: {}", (Object)retryCount);
                        return this.execute(octaneHttpRequest, --retryCount);
                    }
                }
            }
            throw exception;
        }
    }

    private HttpResponse executeRequest(HttpRequest httpRequest) {
        HttpResponse response;
        logger.debug(LOGGER_REQUEST_FORMAT, new Object[]{httpRequest.getRequestMethod(), httpRequest.getUrl().toString(), httpRequest.getHeaders().toString()});
        HttpContent content = httpRequest.getContent();
        if (content != null && logger.isDebugEnabled() && !httpRequest.getUrl().toString().contains("/authentication/sign_in")) {
            GoogleHttpClient.logHttpContent(content);
        }
        try {
            response = httpRequest.execute();
        }
        catch (Exception e) {
            throw GoogleHttpClient.wrapException(e, httpRequest);
        }
        logger.debug(LOGGER_RESPONSE_FORMAT, new Object[]{response.getStatusCode(), response.getStatusMessage(), response.getHeaders().toString()});
        return response;
    }

    private static RuntimeException wrapException(Exception exception, HttpRequest httpRequest) {
        if (exception instanceof HttpResponseException) {
            HttpResponseException httpResponseException = (HttpResponseException)exception;
            logger.debug(LOGGER_RESPONSE_FORMAT, new Object[]{httpResponseException.getStatusCode(), httpResponseException.getStatusMessage(), httpResponseException.getHeaders().toString()});
            if (httpResponseException.getStatusCode() == 401) {
                try {
                    String cookie = httpRequest.getHeaders().getCookie();
                    if (cookie != null) {
                        for (String splitCookie : cookie.split(";")) {
                            if (!splitCookie.startsWith("LWSSO_COOKIE_KEY")) continue;
                            LongFieldModel statusFieldModel = new LongFieldModel("http_status_code", Long.valueOf(httpResponseException.getStatusCode()));
                            ErrorModel errorModel = new ErrorModel(Collections.singleton(statusFieldModel));
                            errorModel.setValue(new StringFieldModel("errorCode", ERROR_CODE_TOKEN_EXPIRED));
                            return new OctaneException(errorModel);
                        }
                    }
                }
                catch (NullPointerException cookie) {
                    // empty catch block
                }
            }
            ArrayList<String> exceptionContentList = new ArrayList<String>();
            exceptionContentList.add(httpResponseException.getStatusMessage());
            exceptionContentList.add(httpResponseException.getContent());
            for (String exceptionContent : exceptionContentList) {
                try {
                    if (ModelParser.getInstance().hasErrorModels(exceptionContent)) {
                        Collection<ErrorModel> errorModels = ModelParser.getInstance().getErrorModels(exceptionContent);
                        OctaneCollection<EntityModel> entities = ModelParser.getInstance().getEntities(exceptionContent);
                        return new OctanePartialException(errorModels, entities);
                    }
                    if (ModelParser.getInstance().hasErrorModel(exceptionContent)) {
                        ErrorModel errorModel = ModelParser.getInstance().getErrorModelFromjson(exceptionContent);
                        errorModel.setValue(new LongFieldModel("http_status_code", Long.valueOf(httpResponseException.getStatusCode())));
                        return new OctaneException(errorModel);
                    }
                    if (!ModelParser.getInstance().hasServletError(exceptionContent)) continue;
                    ErrorModel errorModel = ModelParser.getInstance().getErrorModelFromServletJson(exceptionContent);
                    errorModel.setValue(new LongFieldModel("http_status_code", Long.valueOf(httpResponseException.getStatusCode())));
                    return new OctaneException(errorModel);
                }
                catch (Exception exception2) {
                }
            }
        }
        return new RuntimeException(exception);
    }

    private static void logHttpContent(HttpContent content) {
        if (content instanceof MultipartContent) {
            MultipartContent multipartContent = (MultipartContent)content;
            logger.debug("MultipartContent: {}", (Object)content.getType());
            multipartContent.getParts().forEach(part -> {
                logger.debug("Part: encoding: {}, headers: {}", (Object)part.getEncoding(), (Object)part.getHeaders());
                GoogleHttpClient.logHttpContent(part.getContent());
            });
        } else if (content instanceof InputStreamContent) {
            logger.debug("InputStreamContent: type: {}", (Object)content.getType());
        } else if (content instanceof FileContent) {
            logger.debug("FileContent: type: {}, filepath: {}", (Object)content.getType(), (Object)((FileContent)content).getFile().getAbsolutePath());
        } else {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                content.writeTo((OutputStream)byteArrayOutputStream);
                logger.debug("Content: type: {}, {}", (Object)content.getType(), (Object)byteArrayOutputStream.toString());
            }
            catch (IOException ex) {
                logger.error("Failed to log content of {} {}", (Object)content, (Object)ex);
            }
        }
    }

    private HttpRequest buildBinaryPostRequest(OctaneHttpRequest.PostBinaryOctaneHttpRequest octaneHttpRequest) throws IOException {
        GenericUrl domain = new GenericUrl(octaneHttpRequest.getRequestUrl());
        HttpRequest httpRequest = this.requestFactory.buildPostRequest(domain, (HttpContent)this.generateMultiPartContent(octaneHttpRequest));
        httpRequest.getHeaders().setAccept(octaneHttpRequest.getAcceptType());
        return httpRequest;
    }

    private MultipartContent generateMultiPartContent(OctaneHttpRequest.PostBinaryOctaneHttpRequest octaneHttpRequest) {
        MultipartContent content = new MultipartContent().setMediaType(new HttpMediaType(HTTP_MEDIA_TYPE_MULTIPART_NAME).setParameter(HTTP_MULTIPART_BOUNDARY_NAME, HTTP_MULTIPART_BOUNDARY_VALUE));
        ByteArrayContent byteArrayContent = new ByteArrayContent("application/json", octaneHttpRequest.getContent().getBytes(StandardCharsets.UTF_8));
        MultipartContent.Part part1 = new MultipartContent.Part((HttpContent)byteArrayContent);
        String contentDisposition = String.format(HTTP_MULTIPART_PART1_DISPOSITION_FORMAT, HTTP_MULTIPART_PART1_DISPOSITION_ENTITY_VALUE);
        HttpHeaders httpHeaders = new HttpHeaders().set(HTTP_MULTIPART_PART_DISPOSITION_NAME, (Object)contentDisposition);
        part1.setHeaders(httpHeaders);
        content.addPart(part1);
        InputStreamContent inputStreamContent = new InputStreamContent(octaneHttpRequest.getBinaryContentType(), octaneHttpRequest.getBinaryInputStream());
        MultipartContent.Part part2 = new MultipartContent.Part((HttpContent)inputStreamContent);
        part2.setHeaders(new HttpHeaders().set(HTTP_MULTIPART_PART_DISPOSITION_NAME, (Object)String.format(HTTP_MULTIPART_PART2_DISPOSITION_FORMAT, octaneHttpRequest.getBinaryContentName())));
        content.addPart(part2);
        return content;
    }

    private boolean updateLWSSOCookieValue(HttpHeaders headers) {
        boolean renewed = false;
        List cookieHeaderValue = headers.getHeaderStringValues(SET_COOKIE);
        if (cookieHeaderValue.isEmpty()) {
            return false;
        }
        for (String strCookie : cookieHeaderValue) {
            List<HttpCookie> cookies;
            try {
                cookies = HttpCookie.parse(strCookie);
            }
            catch (Exception ex) {
                logger.error("Failed to parse SET_COOKIE header, issue with cookie: \"{}\", {}", (Object)strCookie, (Object)ex);
                continue;
            }
            Optional<HttpCookie> lwssoCookie = cookies.stream().filter(a -> a.getName().equals("LWSSO_COOKIE_KEY")).findFirst();
            if (lwssoCookie.isPresent()) {
                this.lwssoValue = lwssoCookie.get().getValue();
                renewed = true;
                continue;
            }
            cookies.stream().filter(cookie -> cookie.getName().equals("OCTANE_USER")).findAny().ifPresent(cookie -> {
                this.octaneUserValue = cookie.getValue();
            });
        }
        return renewed;
    }

    public static int getHttpRequestRetryCount() {
        return 1;
    }

    private static void logProxySystemProperties() {
        if (logger.isDebugEnabled()) {
            String[] proxySysProperties = new String[]{"java.net.useSystemProxies", "http.proxyHost", "http.proxyPort", "https.proxyHost", "https.proxyPort"};
            Arrays.stream(proxySysProperties).forEach(sysProp -> logger.debug("{}: {}", sysProp, (Object)System.getProperty(sysProp)));
        }
    }

    private static void logSystemProxyForUrlDomain(String urlDomain) {
        if (logger.isDebugEnabled()) {
            try {
                List<Proxy> proxies = ProxySelector.getDefault().select(URI.create(urlDomain));
                logger.debug("System proxies for {}: {}", (Object)urlDomain, (Object)proxies.toString());
            }
            catch (SecurityException ex) {
                logger.debug("SecurityException when trying to access system wide proxy selector: ", (Throwable)ex);
            }
        }
    }
}

