/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.network;

import com.hpe.adm.nga.sdk.APIMode;
import com.hpe.adm.nga.sdk.entities.OctaneCollection;
import com.hpe.adm.nga.sdk.model.EntityModel;
import com.hpe.adm.nga.sdk.model.ModelParser;
import com.hpe.adm.nga.sdk.network.OctaneHttpClient;
import com.hpe.adm.nga.sdk.network.OctaneHttpRequest;
import com.hpe.adm.nga.sdk.network.OctaneHttpResponse;
import com.hpe.adm.nga.sdk.network.OctaneUrl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OctaneRequest {
    private final Logger logger = LoggerFactory.getLogger((String)OctaneRequest.class.getName());
    private final OctaneUrl octaneUrl;
    protected final OctaneHttpClient octaneHttpClient;
    private final Set<APIMode> httpHeaders = new HashSet<APIMode>();
    private static final String LOGGER_RESPONSE_JSON_FORMAT = "Response_Json: {}";

    public OctaneRequest(OctaneHttpClient octaneHttpClient, String urlDomain) {
        this.octaneUrl = new OctaneUrl(urlDomain);
        this.octaneHttpClient = octaneHttpClient;
    }

    public OctaneRequest(OctaneHttpClient octaneHttpClient, String urlDomain, String entityId) {
        this(octaneHttpClient, urlDomain);
        this.octaneUrl.addPaths(entityId);
    }

    public void addHeader(APIMode header) {
        this.httpHeaders.add(header);
    }

    public void removeHeader(APIMode header) {
        this.httpHeaders.remove(header);
    }

    public Set<APIMode> getHeaders() {
        return Collections.unmodifiableSet(this.httpHeaders);
    }

    public final OctaneUrl getOctaneUrl() {
        return this.octaneUrl;
    }

    public final String getFinalRequestUrl() {
        return this.octaneUrl.toString();
    }

    public final OctaneCollection<EntityModel> getEntitiesResponse(OctaneHttpRequest octaneHttpRequest) {
        OctaneCollection<EntityModel> newEntityModels = null;
        OctaneHttpResponse response = this.octaneHttpClient.execute(octaneHttpRequest);
        String json = response.getContent();
        this.logger.debug(LOGGER_RESPONSE_JSON_FORMAT, (Object)json);
        if (response.isSuccessStatusCode() && json != null && !json.isEmpty()) {
            newEntityModels = ModelParser.getInstance().getEntities(json);
        }
        return newEntityModels;
    }

    public EntityModel getEntityResponse(OctaneHttpRequest octaneHttpRequest) {
        EntityModel newEntityModel = null;
        OctaneHttpResponse response = this.octaneHttpClient.execute(octaneHttpRequest);
        String json = response.getContent();
        this.logger.debug(LOGGER_RESPONSE_JSON_FORMAT, (Object)json);
        if (response.isSuccessStatusCode() && json != null && !json.isEmpty()) {
            JSONTokener tokener = new JSONTokener(json);
            JSONObject jsonObj = new JSONObject(tokener);
            newEntityModel = ModelParser.getInstance().getEntityModel(jsonObj);
        }
        return newEntityModel;
    }
}

