/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.network;

import com.google.api.client.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OctaneHttpResponse {
    private final int statusCode;
    private final byte[] content;
    private static final Logger logger = LoggerFactory.getLogger((String)OctaneHttpResponse.class.getName());
    private final Charset responseCharset;

    public OctaneHttpResponse(int statusCode, InputStream inputStream, Charset responseCharset) {
        this.statusCode = statusCode;
        this.responseCharset = responseCharset;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)out);
        }
        catch (IOException e) {
            logger.error("Cannot create output stream", (Throwable)e);
        }
        this.content = out.toByteArray();
    }

    public boolean isSuccessStatusCode() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    public String getContent() {
        return new String(this.content, this.responseCharset);
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.content);
    }
}

