/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.network;

import com.hpe.adm.nga.sdk.APIMode;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class OctaneHttpRequest {
    public static final String JSON_CONTENT_TYPE = "application/json";
    public static final String OCTET_STREAM_CONTENT_TYPE = "application/octet-stream";
    private final String requestUrl;
    private final OctaneRequestMethod octaneRequestMethod;
    private Set<APIMode> httpHeaders = new HashSet<APIMode>();

    private OctaneHttpRequest(String requestUrl, OctaneRequestMethod octaneRequestMethod) {
        this.requestUrl = requestUrl;
        this.octaneRequestMethod = octaneRequestMethod;
    }

    public final void setHeaders(Set<APIMode> headers) {
        this.httpHeaders = headers;
    }

    public Set<APIMode> getHeaders() {
        return this.httpHeaders;
    }

    public final String getRequestUrl() {
        return this.requestUrl;
    }

    public final OctaneRequestMethod getOctaneRequestMethod() {
        return this.octaneRequestMethod;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OctaneHttpRequest)) {
            return false;
        }
        OctaneHttpRequest that = (OctaneHttpRequest)obj;
        return this.octaneRequestMethod == that.octaneRequestMethod && this.requestUrl.equals(that.requestUrl);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.octaneRequestMethod, this.requestUrl});
    }

    public static class PostBinaryOctaneHttpRequest
    extends HasContentOctaneHttpRequest<PostBinaryOctaneHttpRequest> {
        private final InputStream binaryInputStream;
        private final String binaryContentName;
        private final String binaryContentType;

        public PostBinaryOctaneHttpRequest(String url, InputStream binaryInputStream, String content, String binaryContentName, String binaryContentType) {
            super(url, OctaneRequestMethod.POST_BINARY, OctaneHttpRequest.OCTET_STREAM_CONTENT_TYPE, content);
            this.binaryInputStream = binaryInputStream;
            this.binaryContentName = binaryContentName;
            this.binaryContentType = binaryContentType;
        }

        public InputStream getBinaryInputStream() {
            return this.binaryInputStream;
        }

        public String getBinaryContentName() {
            return this.binaryContentName;
        }

        public String getBinaryContentType() {
            return this.binaryContentType;
        }
    }

    public static class PostOctaneHttpRequest
    extends HasContentOctaneHttpRequest<PostOctaneHttpRequest> {
        public PostOctaneHttpRequest(String url, String contentType, String content) {
            super(url, OctaneRequestMethod.POST, contentType, content);
        }
    }

    public static class PutOctaneHttpRequest
    extends HasContentOctaneHttpRequest<PutOctaneHttpRequest> {
        public PutOctaneHttpRequest(String url, String contentType, String content) {
            super(url, OctaneRequestMethod.PUT, contentType, content);
        }
    }

    private static abstract class HasContentOctaneHttpRequest<F extends HasContentOctaneHttpRequest>
    extends HasAcceptOctaneHttpRequest<F> {
        private final String contentType;
        private final String content;

        private HasContentOctaneHttpRequest(String url, OctaneRequestMethod octaneRequestMethod, String contentType, String content) {
            super(url, octaneRequestMethod);
            this.contentType = contentType;
            this.content = content;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final String getContent() {
            return this.content;
        }
    }

    public static class GetOctaneHttpRequest
    extends HasAcceptOctaneHttpRequest<GetOctaneHttpRequest> {
        public GetOctaneHttpRequest(String url) {
            super(url, OctaneRequestMethod.GET);
        }
    }

    private static abstract class HasAcceptOctaneHttpRequest<E extends HasAcceptOctaneHttpRequest>
    extends OctaneHttpRequest {
        private String acceptType;

        private HasAcceptOctaneHttpRequest(String url, OctaneRequestMethod octaneRequestMethod) {
            super(url, octaneRequestMethod);
        }

        public E setAcceptType(String acceptType) {
            this.acceptType = acceptType;
            return (E)this;
        }

        public final String getAcceptType() {
            return this.acceptType;
        }
    }

    public static class DeleteOctaneHttpRequest
    extends OctaneHttpRequest {
        public DeleteOctaneHttpRequest(String url) {
            super(url, OctaneRequestMethod.DELETE);
        }
    }

    public static enum OctaneRequestMethod {
        GET,
        POST,
        PUT,
        DELETE,
        POST_BINARY;

    }
}

