/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.model;

import com.hpe.adm.nga.sdk.entities.OctaneCollection;
import com.hpe.adm.nga.sdk.model.BooleanFieldModel;
import com.hpe.adm.nga.sdk.model.DateFieldModel;
import com.hpe.adm.nga.sdk.model.EmptyFieldModel;
import com.hpe.adm.nga.sdk.model.EntityModel;
import com.hpe.adm.nga.sdk.model.ErrorModel;
import com.hpe.adm.nga.sdk.model.FieldModel;
import com.hpe.adm.nga.sdk.model.FloatFieldModel;
import com.hpe.adm.nga.sdk.model.LongFieldModel;
import com.hpe.adm.nga.sdk.model.MultiReferenceFieldModel;
import com.hpe.adm.nga.sdk.model.ObjectFieldModel;
import com.hpe.adm.nga.sdk.model.OctaneCollectionImpl;
import com.hpe.adm.nga.sdk.model.ReferenceErrorModel;
import com.hpe.adm.nga.sdk.model.ReferenceFieldModel;
import com.hpe.adm.nga.sdk.model.StringFieldModel;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelParser {
    private static final String JSON_DATA_NAME = "data";
    private static final String JSON_ERRORS_NAME = "errors";
    private static final String JSON_TOTAL_COUNT_NAME = "total_count";
    private static final String JSON_EXCEEDS_TOTAL_COUNT_NAME = "exceeds_total_count";
    private static final String REGEX_DATE_FORMAT = "\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}Z";
    private static final String LOGGER_INVALID_FIELD_SCHEME_FORMAT = "{} field scheme is invalid";
    private final Logger logger = LoggerFactory.getLogger((String)ModelParser.class.getName());
    private static ModelParser modelParser = new ModelParser();

    private ModelParser() {
    }

    public static ModelParser getInstance() {
        return modelParser;
    }

    public final JSONObject getEntityJSONObject(EntityModel entityModel) {
        return this.getEntityJSONObject(entityModel, false);
    }

    public final JSONObject getEntityJSONObject(EntityModel entityModel, boolean onlyDirty) {
        Collection<FieldModel> fieldModels = onlyDirty ? entityModel.getDirtyValues() : entityModel.getValues();
        JSONObject objField = new JSONObject();
        fieldModels.forEach(i -> objField.put(i.getName(), this.getFieldValue((FieldModel)i)));
        return objField;
    }

    public final JSONObject getEntitiesJSONObject(Collection<EntityModel> entitiesModels) {
        return this.getEntitiesJSONObject(entitiesModels, false);
    }

    public final JSONObject getEntitiesJSONObject(Collection<EntityModel> entitiesModels, boolean onlyDirty) {
        JSONObject objBase = new JSONObject();
        JSONArray objEntities = new JSONArray();
        objBase.put(JSON_DATA_NAME, (Object)objEntities);
        objBase.put(JSON_TOTAL_COUNT_NAME, entitiesModels.size());
        objBase.put(JSON_EXCEEDS_TOTAL_COUNT_NAME, false);
        entitiesModels.forEach(i -> objEntities.put((Object)this.getEntityJSONObject((EntityModel)i, onlyDirty)));
        return objBase;
    }

    private Object getFieldValue(FieldModel fieldModel) {
        Object fieldValue;
        if (fieldModel.getClass() == ReferenceFieldModel.class) {
            EntityModel fieldEntityModel = ((ReferenceFieldModel)fieldModel).getValue();
            fieldValue = JSONObject.NULL;
            if (fieldEntityModel != null) {
                fieldValue = this.getEntityJSONObject(fieldEntityModel, false);
            }
        } else if (fieldModel.getClass() == MultiReferenceFieldModel.class) {
            Object entities = ((MultiReferenceFieldModel)fieldModel).getValue();
            fieldValue = this.getEntitiesJSONObject((Collection<EntityModel>)entities, false);
        } else {
            fieldValue = fieldModel.getValue();
        }
        return fieldValue;
    }

    public EntityModel getEntityModel(JSONObject jsonEntityObj) {
        HashSet<FieldModel> fieldModels = new HashSet<FieldModel>();
        Iterator keys = jsonEntityObj.keys();
        while (keys.hasNext()) {
            FieldModel<Object> fldModel;
            String strKey = (String)keys.next();
            Object aObj = jsonEntityObj.get(strKey);
            if (aObj == JSONObject.NULL) {
                fldModel = new EmptyFieldModel(strKey);
            } else if (aObj instanceof Long || aObj instanceof Integer) {
                fldModel = new LongFieldModel(strKey, Long.parseLong(aObj.toString()));
            } else if (aObj instanceof Double || aObj instanceof Float) {
                fldModel = new FloatFieldModel(strKey, Float.valueOf(Float.parseFloat(aObj.toString())));
            } else if (aObj instanceof Boolean) {
                fldModel = new BooleanFieldModel(strKey, Boolean.parseBoolean(aObj.toString()));
            } else if (aObj instanceof JSONObject) {
                JSONObject fieldObject = jsonEntityObj.getJSONObject(strKey);
                if (!fieldObject.isNull(JSON_DATA_NAME)) {
                    OctaneCollection<EntityModel> entities = this.getEntities(aObj.toString());
                    fldModel = new MultiReferenceFieldModel(strKey, entities);
                } else if (!fieldObject.isNull("type") && !fieldObject.isNull("id")) {
                    EntityModel ref = this.getEntityModel(jsonEntityObj.getJSONObject(strKey));
                    fldModel = new ReferenceFieldModel(strKey, ref);
                } else {
                    fldModel = new ObjectFieldModel(strKey, aObj.toString());
                }
            } else if (aObj instanceof String) {
                boolean isMatch = aObj.toString().matches(REGEX_DATE_FORMAT);
                if (isMatch) {
                    ZonedDateTime zonedDateTime = ZonedDateTime.parse(aObj.toString());
                    fldModel = new DateFieldModel(strKey, zonedDateTime);
                } else {
                    fldModel = new StringFieldModel(strKey, aObj.toString());
                }
            } else {
                this.logger.debug(LOGGER_INVALID_FIELD_SCHEME_FORMAT, (Object)strKey);
                continue;
            }
            fieldModels.add(fldModel);
        }
        EntityModel entityModel = new EntityModel(fieldModels, EntityModel.EntityState.CLEAN);
        return entityModel;
    }

    public OctaneCollection<EntityModel> getEntities(String json) {
        OctaneCollectionImpl<EntityModel> entityModels;
        JSONTokener tokener = new JSONTokener(json);
        JSONObject jsonObj = new JSONObject(tokener);
        JSONArray jsonDataArr = jsonObj.getJSONArray(JSON_DATA_NAME);
        if (jsonObj.has(JSON_EXCEEDS_TOTAL_COUNT_NAME) && jsonObj.has(JSON_TOTAL_COUNT_NAME)) {
            boolean exceedsTotalAmount = jsonObj.getBoolean(JSON_EXCEEDS_TOTAL_COUNT_NAME);
            int totalCount = jsonObj.getInt(JSON_TOTAL_COUNT_NAME);
            entityModels = new OctaneCollectionImpl(totalCount, exceedsTotalAmount);
        } else {
            entityModels = new OctaneCollectionImpl<EntityModel>();
        }
        IntStream.range(0, jsonDataArr.length()).forEach(i -> entityModels.add(this.getEntityModel(jsonDataArr.getJSONObject(i))));
        return entityModels;
    }

    public boolean hasErrorModels(String json) {
        JSONTokener tokener = new JSONTokener(json);
        JSONObject jsonObj = new JSONObject(tokener);
        return jsonObj.has(JSON_ERRORS_NAME) && jsonObj.get(JSON_ERRORS_NAME) instanceof JSONArray;
    }

    public boolean hasErrorModel(String json) {
        JSONTokener tokener = new JSONTokener(json);
        JSONObject jsonObj = new JSONObject(tokener);
        return jsonObj.has("error_code") && jsonObj.get("error_code") instanceof String;
    }

    public boolean hasServletError(String json) {
        JSONTokener tokener = new JSONTokener(json);
        JSONObject jsonObj = new JSONObject(tokener);
        return jsonObj.has("message") && jsonObj.get("message") instanceof String;
    }

    public Collection<ErrorModel> getErrorModels(String json) {
        JSONTokener tokener = new JSONTokener(json);
        JSONObject jsonObj = new JSONObject(tokener);
        JSONArray jsonErrArr = jsonObj.getJSONArray(JSON_ERRORS_NAME);
        ArrayList<ErrorModel> ErrModels = new ArrayList<ErrorModel>();
        IntStream.range(0, jsonErrArr.length()).forEach(i -> ErrModels.add(this.getErrorModelFromjson(jsonErrArr.getJSONObject(i).toString())));
        return ErrModels;
    }

    public ErrorModel getErrorModelFromjson(String json) {
        JSONTokener tokener = new JSONTokener(json);
        JSONObject jsonErrObj = new JSONObject(tokener);
        HashSet<FieldModel> fieldModels = new HashSet<FieldModel>();
        Iterator keys = jsonErrObj.keys();
        while (keys.hasNext()) {
            FieldModel<ReferenceErrorModel.ReferenceError> fldModel;
            String strKey = (String)keys.next();
            Object aObj = jsonErrObj.get(strKey);
            if (aObj == JSONObject.NULL) {
                fldModel = new ReferenceErrorModel(strKey, null);
            } else if (aObj instanceof JSONObject) {
                EntityModel ref = this.getEntityModel(jsonErrObj.getJSONObject(strKey));
                fldModel = new ReferenceFieldModel(strKey, ref);
            } else {
                fldModel = new StringFieldModel(strKey, aObj.toString());
            }
            fieldModels.add(fldModel);
        }
        return new ErrorModel(fieldModels);
    }

    public ErrorModel getErrorModelFromServletJson(String json) {
        ErrorModel firstLevelModel = this.getErrorModelFromjson(json);
        String messageInJson = firstLevelModel.getValue("message").getValue().toString();
        ErrorModel errorModelFromjson = this.getErrorModelFromjson(messageInJson.replaceAll("&quot;", "\""));
        errorModelFromjson.getValues().forEach(firstLevelModel::setValue);
        return firstLevelModel;
    }
}

