/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.model;

import com.hpe.adm.nga.sdk.model.EntityModel;
import com.hpe.adm.nga.sdk.model.FieldModel;
import com.hpe.adm.nga.sdk.model.MultiReferenceFieldModel;
import com.hpe.adm.nga.sdk.model.ReferenceFieldModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class EntityUtil {
    public static boolean areEqualByIdAndType(EntityModel leftEntityModel, EntityModel rightEntityModel) {
        return Objects.equals(leftEntityModel.getType(), rightEntityModel.getType()) && Objects.equals(leftEntityModel.getId(), rightEntityModel.getId());
    }

    public static boolean areEqualByContent(EntityModel leftEntityModel, EntityModel rightEntityModel) {
        Set<FieldModel> leftFieldModels = leftEntityModel.getValues();
        Set<FieldModel> rightFieldModels = rightEntityModel.getValues();
        if (leftFieldModels.size() != rightFieldModels.size()) {
            return false;
        }
        for (FieldModel leftFieldModel : leftFieldModels) {
            FieldModel rightFieldModel = EntityUtil.findByFieldName(rightFieldModels, leftFieldModel.getName());
            if (rightFieldModel == null) {
                return false;
            }
            if (EntityUtil.areFieldModelsEqualByContent(leftFieldModel, rightFieldModel)) continue;
            return false;
        }
        return true;
    }

    public static boolean areFieldModelsEqualByContent(FieldModel leftFieldModel, FieldModel rightFieldModel) {
        if (!Objects.equals(leftFieldModel.getName(), rightFieldModel.getName())) {
            return false;
        }
        if (!leftFieldModel.getClass().equals(rightFieldModel.getClass())) {
            return false;
        }
        if (leftFieldModel instanceof ReferenceFieldModel && rightFieldModel instanceof ReferenceFieldModel) {
            EntityModel refLeftEntityModel = (EntityModel)leftFieldModel.getValue();
            EntityModel refRightEntityModel = (EntityModel)rightFieldModel.getValue();
            return EntityUtil.areEqualByContent(refLeftEntityModel, refRightEntityModel);
        }
        if (leftFieldModel instanceof MultiReferenceFieldModel && rightFieldModel instanceof MultiReferenceFieldModel) {
            Object refLeftEntityModel = ((MultiReferenceFieldModel)leftFieldModel).getValue();
            Object refRightEntityModel = ((MultiReferenceFieldModel)rightFieldModel).getValue();
            return EntityUtil.containsSameEntities((Collection<EntityModel>)refLeftEntityModel, (Collection<EntityModel>)refRightEntityModel, EntityUtil::areEqualByContent);
        }
        return Objects.equals(leftFieldModel.getValue(), rightFieldModel.getValue());
    }

    private static FieldModel findByFieldName(Collection<FieldModel> collection, String fieldName) {
        return collection.stream().filter(fieldModel -> fieldName.equals(fieldModel.getName())).findFirst().orElse(null);
    }

    public static boolean containsEntityModel(Collection<EntityModel> collection, EntityModel entityModel) {
        return EntityUtil.containsEntityModel(collection, entityModel, EntityUtil::areEqualByIdAndType);
    }

    public static boolean containsEntityModel(Collection<EntityModel> collection, EntityModel entityModel, EntityEquator entityEquator) {
        for (EntityModel em : collection) {
            if (!entityEquator.areEqual(em, entityModel)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllEntityModels(Collection<EntityModel> baseCollection, Collection<EntityModel> sourceCollection, EntityEquator entityEquator) {
        for (EntityModel em : sourceCollection) {
            if (EntityUtil.containsEntityModel(baseCollection, em, entityEquator)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsSameEntities(Collection<EntityModel> leftCollection, Collection<EntityModel> rightCollection, EntityEquator entityEquator) {
        return leftCollection.size() == rightCollection.size() && EntityUtil.containsAllEntityModels(leftCollection, rightCollection, entityEquator) && EntityUtil.containsAllEntityModels(rightCollection, leftCollection, entityEquator);
    }

    public static boolean removeEntityModel(Collection<EntityModel> collection, EntityModel entityModel) {
        return EntityUtil.removeEntityModel(collection, entityModel, EntityUtil::areEqualByIdAndType);
    }

    public static boolean removeEntityModel(Collection<EntityModel> collection, EntityModel entityModel, EntityEquator entityEquator) {
        ArrayList<EntityModel> toBeRemoved = new ArrayList<EntityModel>();
        for (EntityModel em : collection) {
            if (!entityEquator.areEqual(em, entityModel)) continue;
            toBeRemoved.add(em);
        }
        return collection.removeAll(toBeRemoved);
    }

    public static interface EntityEquator {
        public boolean areEqual(EntityModel var1, EntityModel var2);
    }
}

