/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.classfactory;

import com.hpe.adm.nga.sdk.Octane;
import com.hpe.adm.nga.sdk.classfactory.DefaultOctaneClassFactory;
import com.hpe.adm.nga.sdk.entities.EntityList;
import com.hpe.adm.nga.sdk.entities.TypedEntityList;
import com.hpe.adm.nga.sdk.network.OctaneHttpClient;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface OctaneClassFactory {
    public static final String OCTANE_CLASS_FACTORY_CLASS_NAME = "octaneClassFactoryClassName";
    public static final String DEFAULT_OCTANE_CLASS_FACTORY_CLASS_NAME = DefaultOctaneClassFactory.class.getName();

    public EntityList getEntityList(OctaneHttpClient var1, String var2, String var3);

    public <T extends TypedEntityList> T getEntityList(OctaneHttpClient var1, String var2, Class<T> var3);

    public static OctaneClassFactory getImplementation(String octaneClassFactoryClassName) {
        Logger logger = LoggerFactory.getLogger((String)Octane.class.getName());
        String string = octaneClassFactoryClassName = octaneClassFactoryClassName != null ? octaneClassFactoryClassName : System.getProperty(OCTANE_CLASS_FACTORY_CLASS_NAME);
        if (octaneClassFactoryClassName != null) {
            Class<?> clazz;
            logger.debug("Creating OctaneClassFactory using implementation {}", (Object)octaneClassFactoryClassName);
            try {
                clazz = Class.forName(octaneClassFactoryClassName);
            }
            catch (ClassNotFoundException e) {
                logger.error("Failed to instantiate OctaneClassFactory class from name: {}: {}", (Object)octaneClassFactoryClassName, (Object)e.getMessage());
                throw new RuntimeException("Failed to find class with name: " + octaneClassFactoryClassName, e);
            }
            try {
                Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
                return (OctaneClassFactory)method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                String message = "Failed to instantiate class {}, the class must be a singleton and have a static getInstance() method";
                logger.error(message, (Object)octaneClassFactoryClassName);
                throw new RuntimeException(message, e);
            }
        }
        return DefaultOctaneClassFactory.getInstance();
    }
}

