/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.attachments;

import com.hpe.adm.nga.sdk.Octane;
import com.hpe.adm.nga.sdk.attachments.CreateAttachment;
import com.hpe.adm.nga.sdk.attachments.GetBinaryAttachment;
import com.hpe.adm.nga.sdk.classfactory.OctaneClassFactory;
import com.hpe.adm.nga.sdk.entities.EntityList;
import com.hpe.adm.nga.sdk.entities.delete.DeleteEntities;
import com.hpe.adm.nga.sdk.entities.delete.DeleteEntity;
import com.hpe.adm.nga.sdk.entities.get.GetEntities;
import com.hpe.adm.nga.sdk.entities.get.GetEntity;
import com.hpe.adm.nga.sdk.entities.update.UpdateEntities;
import com.hpe.adm.nga.sdk.entities.update.UpdateEntity;
import com.hpe.adm.nga.sdk.network.OctaneHttpClient;

public class AttachmentList {
    private static final String ATTACHMENTS_URL = "attachments";
    private final EntityList entityList;
    private final OctaneHttpClient octaneHttpClient;
    private final String attachmentListDomain;

    public AttachmentList(Octane.OctaneInternalConfiguration octaneInternalConfiguration, String baseDomain) {
        this.octaneHttpClient = octaneInternalConfiguration.getOctaneHttpClient();
        this.attachmentListDomain = baseDomain + ATTACHMENTS_URL;
        this.entityList = OctaneClassFactory.getImplementation(octaneInternalConfiguration.getOctaneClassFactoryClassName()).getEntityList(this.octaneHttpClient, baseDomain, ATTACHMENTS_URL);
    }

    public GetEntities get() {
        return this.entityList.get();
    }

    public UpdateEntities update() {
        return this.entityList.update();
    }

    public CreateAttachment create() {
        return new CreateAttachment(this.octaneHttpClient, this.attachmentListDomain);
    }

    public DeleteEntities delete() {
        return this.entityList.delete();
    }

    public Attachments at(String entityId) {
        return new Attachments(entityId);
    }

    public class Attachments {
        private final String entityId;
        private final EntityList.Entities entities;

        private Attachments(String entityId) {
            this.entities = AttachmentList.this.entityList.at(entityId);
            this.entityId = entityId;
        }

        public GetEntity get() {
            return this.entities.get();
        }

        public UpdateEntity update() {
            return this.entities.update();
        }

        public DeleteEntity delete() {
            return this.entities.delete();
        }

        public GetBinaryAttachment getBinary() {
            return new GetBinaryAttachment(AttachmentList.this.octaneHttpClient, AttachmentList.this.attachmentListDomain, this.entityId);
        }
    }
}

