/*
 * Decompiled with CFR 0.152.
 */
package com.mickael.sportloadingview;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.mickael.sportloadingview.R;

public class SportLoadingView
extends FrameLayout {
    private float maxAlpha;
    private ImageView image;
    private View background;
    private FrameLayout translator;
    private int translateDuration;
    private int fadeInOutDuration;
    private int rotateDuration;
    private RotateAnimation rotate;

    public SportLoadingView(@NonNull Context context) {
        super(context);
        this.initialise(context, null);
    }

    public SportLoadingView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialise(context, attrs);
    }

    public SportLoadingView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialise(context, attrs);
    }

    private void initialise(Context context, AttributeSet attrs) {
        LayoutInflater.from((Context)context).inflate(R.layout.view_loader, (ViewGroup)this, true);
        this.image = (ImageView)this.findViewById(R.id.image_view_loader);
        this.background = this.findViewById(R.id.view_background);
        this.translator = (FrameLayout)this.findViewById(R.id.frame_layout_translator);
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SportLoadingView);
            int imageId = ta.getResourceId(R.styleable.SportLoadingView_image_loader, R.drawable.bowling_ball);
            this.image.setBackgroundResource(imageId);
            this.image.getLayoutParams().width = ta.getDimensionPixelSize(R.styleable.SportLoadingView_image_width, 100);
            this.image.getLayoutParams().height = ta.getDimensionPixelSize(R.styleable.SportLoadingView_image_height, 100);
            try {
                int colorId = ta.getColor(R.styleable.SportLoadingView_background_font, 31843);
                this.background.setBackgroundResource(colorId);
            }
            catch (Exception ignored) {
                int colorId = ta.getResourceId(R.styleable.SportLoadingView_background_font, R.color.color_loader);
                this.background.setBackgroundResource(colorId);
            }
            this.maxAlpha = ta.getFloat(R.styleable.SportLoadingView_background_alpha, 0.7f);
            this.rotateDuration = ta.getInt(R.styleable.SportLoadingView_rotate_duration, 700);
            this.translateDuration = ta.getInt(R.styleable.SportLoadingView_translate_duration, 900);
            this.fadeInOutDuration = ta.getInt(R.styleable.SportLoadingView_fadeInOut_duration, 500);
            ta.recycle();
        }
        this.setTranslationZ(50.0f);
        this.initialiseAnimations();
        this.translator.setVisibility(8);
        this.image.setVisibility(8);
        this.background.setVisibility(8);
    }

    private void initialiseAnimations() {
        this.rotate = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        this.rotate.setDuration((long)this.rotateDuration);
        this.rotate.setRepeatCount(-1);
        this.rotate.setInterpolator((Interpolator)new LinearInterpolator());
    }

    private void translateFromLeft() {
        ObjectAnimator animation = ObjectAnimator.ofFloat((Object)this.translator, (String)"translationX", (float[])new float[]{0.0f});
        animation.setDuration((long)this.translateDuration);
        animation.start();
    }

    private void translateToRight() {
        ObjectAnimator animation = ObjectAnimator.ofFloat((Object)this.translator, (String)"translationX", (float[])new float[]{this.translator.getWidth()});
        animation.setDuration((long)this.translateDuration);
        animation.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                SportLoadingView.this.translator.setVisibility(8);
                SportLoadingView.this.translator.setTranslationX(-1500.0f);
                SportLoadingView.this.image.setVisibility(8);
                SportLoadingView.this.image.setAnimation(null);
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animation.start();
    }

    public void fadeOutAnimation() {
        ObjectAnimator alphaAnimation = ObjectAnimator.ofFloat((Object)this.background, (Property)View.ALPHA, (float[])new float[]{this.maxAlpha, 0.0f});
        alphaAnimation.setDuration((long)this.fadeInOutDuration);
        alphaAnimation.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                SportLoadingView.this.background.setVisibility(8);
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        alphaAnimation.start();
    }

    private void fadeInAnimation() {
        ObjectAnimator alphaAnimation = ObjectAnimator.ofFloat((Object)this.background, (Property)View.ALPHA, (float[])new float[]{0.0f, this.maxAlpha});
        alphaAnimation.setDuration((long)this.fadeInOutDuration);
        alphaAnimation.start();
    }

    public void startLoading() {
        if (this.image.getAnimation() == null) {
            this.translator.setVisibility(0);
            this.image.setVisibility(0);
            this.background.setVisibility(0);
            this.image.setAnimation((Animation)this.rotate);
            this.fadeInAnimation();
            this.translateFromLeft();
        }
    }

    public void stopLoading() {
        if (this.image.getAnimation() != null) {
            this.translateToRight();
            this.fadeOutAnimation();
        }
    }

    public float getMaxAlpha() {
        return this.maxAlpha;
    }

    public void setMaxAlpha(float maxAlpha) {
        this.maxAlpha = maxAlpha;
    }

    public ImageView getImage() {
        return this.image;
    }

    public void setImage(Drawable image) {
        this.image.setBackground(image);
    }

    public View getBackgroundRes() {
        return this.background;
    }

    public void setBackground(Drawable background) {
        this.background.setBackground(background);
    }

    public void setBackground(int color2) {
        this.background.setBackgroundColor(color2);
    }

    public FrameLayout getTranslator() {
        return this.translator;
    }

    public int getTranslateDuration() {
        return this.translateDuration;
    }

    public void setTranslateDuration(int translateDuration) {
        this.translateDuration = translateDuration;
    }

    public int getFadeInOutDuration() {
        return this.fadeInOutDuration;
    }

    public void setFadeInOutDuration(int fadeInOutDuration) {
        this.fadeInOutDuration = fadeInOutDuration;
    }

    public int getRotateDuration() {
        return this.rotateDuration;
    }

    public void setRotateDuration(int rotateDuration) {
        this.rotateDuration = rotateDuration;
    }

    public RotateAnimation getRotate() {
        return this.rotate;
    }

    public void setRotate(RotateAnimation rotate) {
        this.rotate = rotate;
    }
}

