/*
 * Decompiled with CFR 0.152.
 */
package com.miaomaio.miaocameralibrary;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;
import com.google.android.cameraview.CameraView;
import com.miaomaio.miaocameralibrary.ConfirmImageActivity;
import com.miaomaio.miaocameralibrary.R;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TakePhotoActivity
extends AppCompatActivity
implements View.OnClickListener {
    private static final String TAG = "TakePhotoActivity";
    private ImageView mIvClose;
    private ImageView mIvConfirm;
    private CameraView mCameraView;
    private ImageView mIvChangeFlash;
    private Handler mBackgroundHandler;
    private static final int REQUEST_PERMISSION = 1;
    private static final int[] FLASH_ICONS = new int[]{R.drawable.ic_flash_auto, R.drawable.ic_flash_off, R.drawable.ic_flash_on};
    private static final int[] FLASH_OPTIONS = new int[]{3, 0, 1};
    private int mCurrentFlash;
    private CameraView.Callback mCallback = new CameraView.Callback(){

        public void onCameraOpened(CameraView cameraView) {
            Log.d((String)TakePhotoActivity.TAG, (String)"onCameraOpened");
        }

        public void onCameraClosed(CameraView cameraView) {
            Log.d((String)TakePhotoActivity.TAG, (String)"onCameraClosed");
        }

        public void onPictureTaken(CameraView cameraView, final byte[] data) {
            Log.d((String)TakePhotoActivity.TAG, (String)("onPictureTaken " + data.length));
            TakePhotoActivity.this.getBackgroundHandler().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    File file = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), String.format("%s.jpg", System.currentTimeMillis()));
                    FileOutputStream os = null;
                    try {
                        os = new FileOutputStream(file);
                        ((OutputStream)os).write(data);
                        ((OutputStream)os).close();
                        Message message = Message.obtain();
                        message.obj = file.getAbsolutePath();
                        message.what = 16;
                        TakePhotoActivity.this.mBackgroundHandler.sendMessage(message);
                    }
                    catch (IOException e) {
                        TakePhotoActivity.this.mBackgroundHandler.sendEmptyMessage(17);
                        Log.w((String)TakePhotoActivity.TAG, (String)("Cannot write to " + file), (Throwable)e);
                    }
                    finally {
                        if (os != null) {
                            try {
                                ((OutputStream)os).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            });
        }
    };
    private final int WHAT_SUCCESS = 16;
    private final int WHAT_FAILED = 17;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.getWindow().setFlags(1024, 1024);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_take_photo);
        this.mCameraView = (CameraView)this.findViewById(R.id.mCameraView);
        if (this.mCameraView != null) {
            this.mCameraView.addCallback(this.mCallback);
            this.mCameraView.setAutoFocus(true);
        }
        this.mIvClose = (ImageView)this.findViewById(R.id.mIvClose);
        this.mIvConfirm = (ImageView)this.findViewById(R.id.mIvConfirm);
        this.mIvChangeFlash = (ImageView)this.findViewById(R.id.mIvChangeFlash);
        this.mIvClose.setOnClickListener((View.OnClickListener)this);
        this.mIvConfirm.setOnClickListener((View.OnClickListener)this);
        this.mIvChangeFlash.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.mIvClose) {
            this.finish();
        } else if (id2 == R.id.mIvConfirm) {
            this.mIvConfirm.setEnabled(false);
            if (this.mCameraView != null) {
                this.mCameraView.takePicture();
            }
        } else if (id2 == R.id.mIvChangeFlash && this.mCameraView != null) {
            this.mCurrentFlash = (this.mCurrentFlash + 1) % FLASH_OPTIONS.length;
            this.mIvChangeFlash.setImageResource(FLASH_ICONS[this.mCurrentFlash]);
            this.mCameraView.setFlash(FLASH_OPTIONS[this.mCurrentFlash]);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 1: {
                if (permissions.length != 2 || grantResults.length != 2) {
                    throw new RuntimeException("Error on requesting  permission.");
                }
                if (grantResults[0] == 0 && grantResults[1] == 0) break;
                Toast.makeText((Context)this, (CharSequence)"cannot do anything without permission", (int)0).show();
            }
        }
    }

    private Handler getBackgroundHandler() {
        if (this.mBackgroundHandler == null) {
            HandlerThread thread = new HandlerThread("background");
            thread.start();
            this.mBackgroundHandler = new Handler(thread.getLooper()){

                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    switch (msg.what) {
                        case 16: {
                            Intent intent = new Intent((Context)TakePhotoActivity.this, ConfirmImageActivity.class);
                            intent.putExtra("imagePath", (String)msg.obj);
                            TakePhotoActivity.this.startActivityForResult(intent, 16);
                            break;
                        }
                        case 17: {
                            Intent errorIntent = new Intent();
                            TakePhotoActivity.this.setResult(-1, errorIntent);
                            TakePhotoActivity.this.finish();
                        }
                    }
                }
            };
        }
        return this.mBackgroundHandler;
    }

    protected void onResume() {
        super.onResume();
        this.mIvConfirm.setEnabled(true);
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") == 0 && ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            this.mCameraView.start();
        } else if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)"android.permission.CAMERA") || ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE")) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, (int)1);
        }
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 16 && resultCode == 16) {
            this.finish();
        } else if (requestCode == 16 && resultCode == 17) {
            this.setResult(-1, data);
            this.finish();
        } else if (requestCode != 16 || resultCode == 18) {
            // empty if block
        }
    }
}

