/*
 * Decompiled with CFR 0.152.
 */
package com.miaomaio.miaocameralibrary;

import android.app.Activity;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import com.miaomaio.miaocameralibrary.CameraRequest;
import java.lang.ref.WeakReference;

public class Camera {
    private final WeakReference<Activity> mContext;
    private final WeakReference<Fragment> mFragment;

    private Camera(Activity activity) {
        this(activity, null);
    }

    private Camera(Fragment fragment) {
        this((Activity)fragment.getActivity(), fragment);
    }

    private Camera(Activity activity, Fragment fragment) {
        this.mContext = new WeakReference<Activity>(activity);
        this.mFragment = new WeakReference<Fragment>(fragment);
    }

    public static Camera from(Activity activity) {
        return new Camera(activity);
    }

    public static Camera from(Fragment fragment) {
        return new Camera(fragment);
    }

    public CameraRequest request(int requestCode) {
        return new CameraRequest(this, requestCode);
    }

    @Nullable
    Activity getActivity() {
        return (Activity)this.mContext.get();
    }

    @Nullable
    Fragment getFragment() {
        return this.mFragment != null ? (Fragment)this.mFragment.get() : null;
    }

    public static String getImagePath(Intent intent) {
        return intent.getStringExtra("imagePath");
    }
}

