/*
 * Decompiled with CFR 0.152.
 */
package com.miaomaio.miaocameralibrary.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.Camera;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.miaomaio.miaocameralibrary.CameraHandlerThread;
import com.miaomaio.miaocameralibrary.CameraPreview;
import com.miaomaio.miaocameralibrary.CameraWrapper;
import com.miaomaio.miaocameralibrary.utils.BitmapUtils;
import com.miaomaio.miaocameralibrary.utils.CameraUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DisplayView
extends FrameLayout
implements Camera.PreviewCallback,
Camera.PictureCallback {
    private CameraWrapper mCameraWrapper;
    private CameraPreview mPreview;
    private CameraHandlerThread mCameraHandlerThread;
    private Boolean mFlashState;
    private String mImageFilePath = Environment.getExternalStorageDirectory() + "/DCIM/Camera/";
    private boolean mAutofocusState = true;
    private OnPictureListener mOnPictureListener;

    public DisplayView(@NonNull Context context) {
        this(context, null);
    }

    public DisplayView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DisplayView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void startCamera(int cameraId) {
        if (this.mCameraHandlerThread == null) {
            this.mCameraHandlerThread = new CameraHandlerThread(this);
        }
        this.mCameraHandlerThread.startCamera(cameraId);
    }

    public void setupCameraPreview(CameraWrapper cameraWrapper) {
        this.mCameraWrapper = cameraWrapper;
        if (this.mCameraWrapper != null) {
            this.setupLayout(this.mCameraWrapper);
            if (this.mFlashState != null) {
                this.setFlash(this.mFlashState);
            }
            this.setAutoFocus(this.mAutofocusState);
        }
    }

    public final void setupLayout(CameraWrapper cameraWrapper) {
        this.removeAllViews();
        this.mPreview = new CameraPreview(this.getContext(), cameraWrapper, this);
        this.mPreview.setAspectTolerance(0.0f);
        this.addView((View)this.mPreview);
    }

    public void startCamera() {
        this.startCamera(CameraUtils.getDefaultCameraId());
    }

    public void stopCamera() {
        if (this.mCameraWrapper != null) {
            this.mPreview.stopCameraPreview();
            this.mPreview.setCamera(null, null);
            this.mCameraWrapper.mCamera.release();
            this.mCameraWrapper = null;
        }
        if (this.mCameraHandlerThread != null) {
            this.mCameraHandlerThread.quit();
            this.mCameraHandlerThread = null;
        }
    }

    public void stopCameraPreview() {
        if (this.mPreview != null) {
            this.mPreview.stopCameraPreview();
        }
    }

    protected void resumeCameraPreview() {
        if (this.mPreview != null) {
            this.mPreview.showCameraPreview();
        }
    }

    public void setFlash(boolean flag) {
        this.mFlashState = flag;
        if (this.mCameraWrapper != null && CameraUtils.isFlashSupported(this.mCameraWrapper.mCamera)) {
            Camera.Parameters parameters = this.mCameraWrapper.mCamera.getParameters();
            if (flag) {
                if (parameters.getFlashMode().equals("torch")) {
                    return;
                }
                parameters.setFlashMode("torch");
            } else {
                if (parameters.getFlashMode().equals("off")) {
                    return;
                }
                parameters.setFlashMode("off");
            }
            this.mCameraWrapper.mCamera.setParameters(parameters);
        }
    }

    public boolean getFlash() {
        if (this.mCameraWrapper != null && CameraUtils.isFlashSupported(this.mCameraWrapper.mCamera)) {
            Camera.Parameters parameters = this.mCameraWrapper.mCamera.getParameters();
            return parameters.getFlashMode().equals("torch");
        }
        return false;
    }

    public void toggleFlash() {
        if (this.mCameraWrapper != null && CameraUtils.isFlashSupported(this.mCameraWrapper.mCamera)) {
            Camera.Parameters parameters = this.mCameraWrapper.mCamera.getParameters();
            if (parameters.getFlashMode().equals("torch")) {
                parameters.setFlashMode("off");
            } else {
                parameters.setFlashMode("torch");
            }
            this.mCameraWrapper.mCamera.setParameters(parameters);
        }
    }

    public void setFlash(String flashMode) {
        if (this.mCameraWrapper != null && CameraUtils.isFlashSupported(this.mCameraWrapper.mCamera)) {
            Camera.Parameters parameters = this.mCameraWrapper.mCamera.getParameters();
            parameters.setFlashMode(flashMode);
            this.mCameraWrapper.mCamera.setParameters(parameters);
        }
    }

    public String getFlashMode() {
        if (this.mCameraWrapper != null && CameraUtils.isFlashSupported(this.mCameraWrapper.mCamera)) {
            Camera.Parameters parameters = this.mCameraWrapper.mCamera.getParameters();
            return parameters.getFlashMode();
        }
        return "";
    }

    public void setAutoFocus(boolean state) {
        this.mAutofocusState = state;
        if (this.mPreview != null) {
            this.mPreview.setAutoFocus(state);
        }
    }

    public void takePhoto() {
        this.mCameraWrapper.mCamera.takePicture(null, null, (Camera.PictureCallback)this);
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPictureTaken(byte[] data, Camera camera) {
        FilterOutputStream bufferedOutputStream = null;
        try {
            File imageFile = new File(this.mImageFilePath, String.format("%d.jpg", System.currentTimeMillis()));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(imageFile));
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
            bitmap = BitmapUtils.rotateBitmapByDegree(bitmap, this.mPreview.getDisplayOrientation());
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bufferedOutputStream);
            ((BufferedOutputStream)bufferedOutputStream).flush();
            if (this.mOnPictureListener != null) {
                this.mOnPictureListener.onSuccess(imageFile, imageFile.getAbsolutePath(), bitmap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.mOnPictureListener != null) {
                this.mOnPictureListener.onFailed(e.getMessage());
            }
        }
        finally {
            try {
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setOnPictureListener(OnPictureListener onPictureListener) {
        this.mOnPictureListener = onPictureListener;
    }

    public static interface OnPictureListener {
        public void onSuccess(File var1, String var2, Bitmap var3);

        public void onFailed(String var1);
    }
}

