/*
 * Decompiled with CFR 0.152.
 */
package com.miaomaio.miaocameralibrary.utils;

import android.hardware.Camera;
import java.util.List;

public class CameraUtils {
    public static Camera getCameraInstance() {
        return CameraUtils.getCameraInstance(CameraUtils.getDefaultCameraId());
    }

    public static int getDefaultCameraId() {
        int numberOfCameras = Camera.getNumberOfCameras();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int defaultCameraId = -1;
        for (int i = 0; i < numberOfCameras; ++i) {
            defaultCameraId = i;
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != 0) continue;
            return i;
        }
        return defaultCameraId;
    }

    public static Camera getCameraInstance(int cameraId) {
        Camera c = null;
        try {
            c = cameraId == -1 ? Camera.open() : Camera.open((int)cameraId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }

    public static boolean isFlashSupported(Camera camera) {
        if (camera != null) {
            Camera.Parameters parameters = camera.getParameters();
            if (parameters.getFlashMode() == null) {
                return false;
            }
            List supportedFlashModes = parameters.getSupportedFlashModes();
            return supportedFlashModes != null && !supportedFlashModes.isEmpty() && (supportedFlashModes.size() != 1 || !((String)supportedFlashModes.get(0)).equals("off"));
        }
        return false;
    }
}

