/*
 * Decompiled with CFR 0.152.
 */
package com.mi.xserv;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import com.mi.xserv.Xserv;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class XservBase {
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private WeakReference<Xserv.OnXservEventListener> mDelegate = new WeakReference<Object>(null);

    public void setOnEventListener(Xserv.OnXservEventListener onEventListener) {
        this.mDelegate = new WeakReference<Xserv.OnXservEventListener>(onEventListener);
    }

    protected Handler getMainLooper() {
        return this.mHandler;
    }

    protected String urlEncodedJSON(JSONObject params) {
        String url_encode = "";
        if (params != null) {
            Iterator keys = params.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = "";
                try {
                    value = params.get(key).toString();
                }
                catch (JSONException ignored) {
                    // empty catch block
                }
                try {
                    if (url_encode.length() > 0) {
                        url_encode = url_encode + "&";
                    }
                    url_encode = url_encode + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException ignored) {}
            }
        }
        return url_encode;
    }

    protected String getDeviceID() {
        Xserv.OnXservEventListener delegate = (Xserv.OnXservEventListener)this.mDelegate.get();
        String deviceID = null;
        if (delegate != null) {
            try {
                deviceID = Settings.Secure.getString((ContentResolver)((Context)delegate).getContentResolver(), (String)"android_id");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (deviceID == null) {
            deviceID = UUID.randomUUID().toString();
        }
        return deviceID;
    }

    protected String getLanguage() {
        return Locale.getDefault().toString().replace("_", "-");
    }

    protected int getTimeZoneOffset() {
        TimeZone timezone = TimeZone.getDefault();
        int seconds = timezone.getOffset(15L) / 1000;
        double minutes = seconds / 60;
        double hours = minutes / 60.0;
        return (int)hours;
    }

    protected int getTimeZoneDst() {
        Date today = new Date();
        TimeZone timezone = TimeZone.getDefault();
        boolean isDST = timezone.inDaylightTime(today);
        return isDST ? 1 : 0;
    }

    protected void onOpenConnection() {
        final Xserv.OnXservEventListener delegate = (Xserv.OnXservEventListener)this.mDelegate.get();
        if (delegate != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    delegate.OnOpenConnection();
                }
            });
        }
    }

    protected void onCloseConnection(final Exception e) {
        final Xserv.OnXservEventListener delegate = (Xserv.OnXservEventListener)this.mDelegate.get();
        if (delegate != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    delegate.OnCloseConnection(e);
                }
            });
        }
    }

    protected void onErrorConnection(final Exception e) {
        final Xserv.OnXservEventListener delegate = (Xserv.OnXservEventListener)this.mDelegate.get();
        if (delegate != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    delegate.OnErrorConnection(e);
                }
            });
        }
    }

    protected void onReceiveMessages(final JSONObject json) {
        final Xserv.OnXservEventListener delegate = (Xserv.OnXservEventListener)this.mDelegate.get();
        if (delegate != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    delegate.OnReceiveMessages(json);
                }
            });
        }
    }

    protected void OnReceiveOperations(final JSONObject json) {
        final Xserv.OnXservEventListener delegate = (Xserv.OnXservEventListener)this.mDelegate.get();
        if (delegate != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    delegate.OnReceiveOperations(json);
                }
            });
        }
    }
}

