/*
 * Decompiled with CFR 0.152.
 */
package com.mi.xserv;

import android.net.Uri;
import android.os.Build;
import android.util.Base64;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.AsyncHttpResponse;
import com.koushikdutta.async.http.WebSocket;
import com.mi.xserv.XservBase;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Xserv
extends XservBase {
    public static final int OP_HANDSHAKE = 100;
    public static final int OP_PUBLISH = 200;
    public static final int OP_SUBSCRIBE = 201;
    public static final int OP_UNSUBSCRIBE = 202;
    public static final int OP_HISTORY = 203;
    public static final int OP_USERS = 204;
    public static final int OP_TOPICS = 205;
    public static final int OP_UPDATE = 300;
    public static final int OP_JOIN = 401;
    public static final int OP_LEAVE = 402;
    public static final int RC_OK = 1;
    public static final int RC_GENERIC_ERROR = 0;
    public static final int RC_ARGS_ERROR = -1;
    public static final int RC_ALREADY_SUBSCRIBED = -2;
    public static final int RC_UNAUTHORIZED = -3;
    public static final int RC_NO_TOPIC = -4;
    public static final int RC_NO_DATA = -5;
    public static final int RC_NOT_PRIVATE = -6;
    public static final int RC_LIMIT_MESSAGES = -7;
    public static final int RC_DB_ERROR = -8;
    private static final String TAG = "Xserv";
    private static final String VERSION = "1";
    private static final String HOST = "mobile-italia.com";
    private static final String PORT = "4332";
    private static final String TLS_PORT = "8332";
    private static final String URL = "ws%1$s://%2$s:%3$s/ws/%4$s?version=%5$s";
    private static final String DEFAULT_AUTH_URL = "http%1$s://%2$s:%3$s/1/user";
    private static final int DEFAULT_RI = 5000;
    private static HashMap<String, OnCompletionListener> mCallbacks;
    private String mAppId;
    private Future<WebSocket> mConn;
    private int mReconnectInterval;
    private boolean isAutoReconnect;
    private JSONObject mUserData;
    private boolean isConnected;
    private boolean isSecure;

    public Xserv(String app_id) {
        this.mAppId = app_id;
        this.mConn = null;
        this.mUserData = new JSONObject();
        this.mReconnectInterval = 5000;
        this.isAutoReconnect = false;
        this.isConnected = false;
        this.isSecure = true;
        mCallbacks = new HashMap();
    }

    public static boolean isPrivateTopic(String topic) {
        return topic.startsWith("@");
    }

    public void disableTLS() {
        this.isSecure = false;
    }

    public boolean isConnected() {
        return this.mConn != null && this.isConnected;
    }

    public void connect() {
        this.connect(false);
    }

    private void connect(boolean no_ar) {
        if (!no_ar) {
            this.isAutoReconnect = true;
        }
        if (!this.isConnected()) {
            String protocol = "";
            String port = PORT;
            if (this.isSecure) {
                protocol = "s";
                port = TLS_PORT;
            }
            mCallbacks.clear();
            AsyncHttpClient as = AsyncHttpClient.getDefaultInstance();
            this.mConn = as.websocket(String.format(URL, protocol, HOST, port, this.mAppId, VERSION), null, new AsyncHttpClient.WebSocketConnectCallback(){

                public void onCompleted(Exception e, WebSocket ws) {
                    if (e == null) {
                        Xserv.this.setOtherWsCallback(ws);
                        Xserv.this.handshake();
                    } else {
                        mCallbacks.clear();
                        Xserv.this.onErrorConnection(e);
                        Xserv.this.reConnect();
                    }
                }
            });
        }
    }

    private void setOtherWsCallback(WebSocket ws) {
        ws.setClosedCallback(new CompletedCallback(){

            public void onCompleted(Exception e) {
                Xserv.this.isConnected = false;
                mCallbacks.clear();
                Xserv.this.onCloseConnection(e);
                Xserv.this.reConnect();
            }
        });
        ws.setStringCallback(new WebSocket.StringCallback(){

            public void onStringAvailable(String event) {
                Xserv.this.manageMessage(event);
            }
        });
    }

    private void manageMessage(String event) {
        JSONObject json = null;
        try {
            json = new JSONObject(event);
        }
        catch (JSONException ignored) {
            // empty catch block
        }
        if (json != null) {
            int op = 0;
            try {
                op = json.getInt("op");
            }
            catch (JSONException ignored) {
                // empty catch block
            }
            if (op == 0) {
                this.onReceiveMessages(json);
            } else if (op > 0) {
                try {
                    String data = json.getString("data");
                    byte[] b = Base64.decode((String)data, (int)0);
                    json.put("data", (Object)new String(b, "UTF-8"));
                }
                catch (UnsupportedEncodingException | JSONException ignored) {
                    // empty catch block
                }
                JSONObject json_data = null;
                try {
                    String data = json.getString("data");
                    Object type = new JSONTokener(data).nextValue();
                    if (type instanceof JSONObject) {
                        json_data = new JSONObject(data);
                        json.put("data", (Object)json_data);
                    } else if (type instanceof JSONArray) {
                        json.put("data", (Object)new JSONArray(data));
                    }
                }
                catch (JSONException ignored) {
                    // empty catch block
                }
                try {
                    json.put("name", (Object)this.stringifyOp(op));
                }
                catch (JSONException ignored) {
                    // empty catch block
                }
                int rc = 0;
                String uuid = "";
                String topic = "";
                String descr = "";
                try {
                    rc = json.getInt("rc");
                    uuid = json.getString("uuid");
                    topic = json.getString("topic");
                    descr = json.getString("descr");
                }
                catch (JSONException ignored) {
                    // empty catch block
                }
                if (op == 100) {
                    if (rc == 1) {
                        if (json_data != null) {
                            this.setUserData(json_data);
                            this.isConnected = true;
                            this.onOpenConnection();
                        } else {
                            mCallbacks.clear();
                            this.onErrorConnection(new Exception(descr));
                        }
                    } else {
                        mCallbacks.clear();
                        this.onErrorConnection(new Exception(descr));
                    }
                } else {
                    if (op == 201 && Xserv.isPrivateTopic(topic) && rc == 1 && json_data != null) {
                        this.setUserData(json_data);
                    }
                    if (mCallbacks.get(uuid) != null) {
                        mCallbacks.get(uuid).onCompletion(json);
                        mCallbacks.remove(uuid);
                    } else {
                        this.OnReceiveOperations(json);
                    }
                }
            }
        }
    }

    private void reConnect() {
        if (this.isAutoReconnect && this.mReconnectInterval > 0) {
            this.getMainLooper().postDelayed(new Runnable(){

                @Override
                public void run() {
                    Xserv.this.connect(true);
                }
            }, (long)this.mReconnectInterval);
        }
    }

    public void disconnect() {
        this.isAutoReconnect = false;
        if (this.isConnected()) {
            try {
                this.mConn.get().close();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public Integer getReconnectInterval() {
        return this.mReconnectInterval;
    }

    public void setReconnectInterval(Integer milliseconds) {
        this.mReconnectInterval = milliseconds;
    }

    private void handshake() {
        JSONObject stat = new JSONObject();
        try {
            String model = Build.MODEL;
            if (model.length() > 45) {
                model = model.substring(0, 45);
            }
            stat.put("uuid", (Object)this.getDeviceID());
            stat.put("model", (Object)model);
            stat.put("os", (Object)("Android " + Build.VERSION.RELEASE));
            stat.put("tz_offset", this.getTimeZoneOffset());
            stat.put("tz_dst", this.getTimeZoneDst());
            stat.put("lang", (Object)this.getLanguage());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.wsSend(stat);
    }

    private void send(final JSONObject json) {
        if (!this.isConnected()) {
            return;
        }
        int op = 0;
        String topic = "";
        try {
            op = json.getInt("op");
            topic = json.getString("topic");
        }
        catch (JSONException ignored) {
            // empty catch block
        }
        if (op == 201 && Xserv.isPrivateTopic(topic)) {
            JSONObject auth = null;
            try {
                auth = json.getJSONObject("auth");
            }
            catch (JSONException ignored) {
                // empty catch block
            }
            if (auth != null) {
                String protocol = "";
                String port = PORT;
                if (this.isSecure) {
                    protocol = "s";
                    port = TLS_PORT;
                }
                String endpoint = String.format(DEFAULT_AUTH_URL, protocol, HOST, port);
                try {
                    endpoint = auth.getString("endpoint");
                }
                catch (JSONException ignored) {
                    // empty catch block
                }
                String user = "";
                String pass = "";
                JSONObject params = null;
                try {
                    params = auth.getJSONObject("params");
                }
                catch (JSONException ignored) {
                    // empty catch block
                }
                if (params != null) {
                    try {
                        user = params.getString("user");
                        params.remove("user");
                    }
                    catch (JSONException ignored) {
                        // empty catch block
                    }
                    try {
                        pass = params.getString("pass");
                        params.remove("pass");
                    }
                    catch (JSONException ignored) {
                        // empty catch block
                    }
                    try {
                        params.put("socket_id", (Object)this.getSocketId());
                        params.put("topic", (Object)topic);
                    }
                    catch (JSONException ignored) {
                        // empty catch block
                    }
                    endpoint = endpoint + "?" + this.urlEncodedJSON(params);
                }
                AsyncHttpRequest request = new AsyncHttpRequest(Uri.parse((String)endpoint), "GET");
                try {
                    JSONObject headers = auth.getJSONObject("headers");
                    Iterator keys = headers.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        request.setHeader(key, (String)headers.get(key));
                    }
                }
                catch (JSONException ignored) {
                    // empty catch block
                }
                request.setHeader("X-Xserv-AppId", this.mAppId);
                if (user.length() > 0 && pass.length() > 0) {
                    byte[] user_pass = (user + ":" + pass).getBytes();
                    request.setHeader("Authorization", "basic " + Base64.encodeToString((byte[])user_pass, (int)2));
                }
                final String userStatic = user;
                AsyncHttpClient as = AsyncHttpClient.getDefaultInstance();
                as.executeJSONObject(request, new AsyncHttpClient.JSONObjectCallback(){

                    public void onCompleted(Exception e, AsyncHttpResponse source, JSONObject result) {
                        if (e == null) {
                            json.remove("auth");
                            try {
                                json.put("arg1", (Object)userStatic);
                                json.put("arg2", (Object)result.getString("data"));
                                json.put("arg3", (Object)result.getString("sign"));
                            }
                            catch (JSONException ignored) {
                                // empty catch block
                            }
                            Xserv.this.wsSend(json);
                        } else {
                            json.remove("auth");
                            Xserv.this.wsSend(json);
                        }
                    }
                });
            } else {
                this.wsSend(json);
            }
        } else {
            this.wsSend(json);
        }
    }

    private void wsSend(JSONObject json) {
        try {
            this.mConn.get().send(json.toString());
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    public String getSocketId() {
        String socket_id = "";
        try {
            socket_id = this.mUserData.getString("socket_id");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return socket_id;
    }

    public JSONObject getUserData() {
        return this.mUserData;
    }

    private void setUserData(JSONObject json) {
        this.mUserData = json;
    }

    private String stringifyOp(int code) {
        switch (code) {
            case 201: {
                return "subscribe";
            }
            case 202: {
                return "unsubscribe";
            }
            case 203: {
                return "history";
            }
            case 204: {
                return "users";
            }
            case 401: {
                return "join";
            }
            case 402: {
                return "leave";
            }
            case 200: {
                return "publish";
            }
            case 100: {
                return "handshake";
            }
            case 205: {
                return "topics";
            }
            case 300: {
                return "update";
            }
        }
        return "";
    }

    public String publish(String topic, Object data) {
        return this.publish(topic, data, null);
    }

    public String publish(String topic, Object data, OnCompletionListener listener) {
        if (!this.isConnected()) {
            return "";
        }
        String uuid = UUID.randomUUID().toString();
        if (listener != null) {
            mCallbacks.put(uuid, listener);
        }
        JSONObject json = new JSONObject();
        try {
            json.put("uuid", (Object)uuid);
            json.put("op", 200);
            json.put("topic", (Object)topic);
            json.put("arg1", data);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.send(json);
        return uuid;
    }

    public String update(String topic, String object_id, Object data) {
        return this.update(topic, object_id, data, null);
    }

    public String update(String topic, String object_id, Object data, OnCompletionListener listener) {
        if (!this.isConnected()) {
            return "";
        }
        String uuid = UUID.randomUUID().toString();
        if (listener != null) {
            mCallbacks.put(uuid, listener);
        }
        JSONObject json = new JSONObject();
        try {
            json.put("uuid", (Object)uuid);
            json.put("op", 300);
            json.put("topic", (Object)topic);
            json.put("arg1", data);
            json.put("arg2", (Object)object_id);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.send(json);
        return uuid;
    }

    public String subscribe(String topic) {
        return this.subscribe(topic, null, null);
    }

    public String subscribe(String topic, OnCompletionListener listener) {
        return this.subscribe(topic, null, listener);
    }

    public String subscribe(String topic, JSONObject auth) {
        return this.subscribe(topic, auth, null);
    }

    public String subscribe(String topic, JSONObject auth, OnCompletionListener listener) {
        if (!this.isConnected()) {
            return "";
        }
        String uuid = UUID.randomUUID().toString();
        if (listener != null) {
            mCallbacks.put(uuid, listener);
        }
        JSONObject json = new JSONObject();
        try {
            json.put("uuid", (Object)uuid);
            json.put("op", 201);
            json.put("topic", (Object)topic);
            if (auth != null) {
                json.put("auth", (Object)auth);
            }
        }
        catch (JSONException e1) {
            e1.printStackTrace();
        }
        this.send(json);
        return uuid;
    }

    public String unsubscribe(String topic) {
        return this.unsubscribe(topic, null);
    }

    public String unsubscribe(String topic, OnCompletionListener listener) {
        if (!this.isConnected()) {
            return "";
        }
        String uuid = UUID.randomUUID().toString();
        if (listener != null) {
            mCallbacks.put(uuid, listener);
        }
        JSONObject json = new JSONObject();
        try {
            json.put("uuid", (Object)uuid);
            json.put("op", 202);
            json.put("topic", (Object)topic);
        }
        catch (JSONException e1) {
            e1.printStackTrace();
        }
        this.send(json);
        return uuid;
    }

    public String history(String topic, JSONObject params) {
        return this.history(topic, params, null);
    }

    public String history(String topic, JSONObject params, OnCompletionListener listener) {
        if (!this.isConnected()) {
            return "";
        }
        int offset = 0;
        int limit = 0;
        JSONObject query = null;
        if (params != null) {
            try {
                offset = params.getInt("offset");
            }
            catch (JSONException ignored) {
                // empty catch block
            }
            try {
                limit = params.getInt("limit");
            }
            catch (JSONException ignored) {
                // empty catch block
            }
            try {
                query = params.getJSONObject("query");
            }
            catch (JSONException ignored) {
                // empty catch block
            }
        }
        String uuid = UUID.randomUUID().toString();
        if (listener != null) {
            mCallbacks.put(uuid, listener);
        }
        JSONObject json = new JSONObject();
        try {
            json.put("uuid", (Object)uuid);
            json.put("op", 203);
            json.put("topic", (Object)topic);
            json.put("arg1", (Object)String.valueOf(offset));
            json.put("arg2", (Object)String.valueOf(limit));
            if (query != null) {
                json.put("arg3", (Object)query);
            } else {
                json.put("arg3", (Object)"");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.send(json);
        return uuid;
    }

    public String users(String topic) {
        return this.users(topic, null);
    }

    public String users(String topic, OnCompletionListener listener) {
        if (!this.isConnected()) {
            return "";
        }
        String uuid = UUID.randomUUID().toString();
        if (listener != null) {
            mCallbacks.put(uuid, listener);
        }
        JSONObject json = new JSONObject();
        try {
            json.put("uuid", (Object)uuid);
            json.put("op", 204);
            json.put("topic", (Object)topic);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.send(json);
        return uuid;
    }

    public String topics() {
        return this.topics(null);
    }

    public String topics(OnCompletionListener listener) {
        if (!this.isConnected()) {
            return "";
        }
        String uuid = UUID.randomUUID().toString();
        if (listener != null) {
            mCallbacks.put(uuid, listener);
        }
        JSONObject json = new JSONObject();
        try {
            json.put("uuid", (Object)uuid);
            json.put("op", 205);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.send(json);
        return uuid;
    }

    public static interface OnXservEventListener {
        public void OnOpenConnection();

        public void OnCloseConnection(Exception var1);

        public void OnErrorConnection(Exception var1);

        public void OnReceiveMessages(JSONObject var1);

        public void OnReceiveOperations(JSONObject var1);
    }

    public static interface OnCompletionListener {
        public void onCompletion(JSONObject var1);
    }
}

