/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.adapters;

import android.app.Activity;
import android.content.Context;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.facebook.ads.AudienceNetworkAds;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.AdapterErrorBuilder;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.CustomBannerEvent;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.AdLog;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class FacebookBanner
extends CustomBannerEvent
implements AdListener {
    private final String TAG = "FacebookBanner";
    private static final String PAY_LOAD = "pay_load";
    private AtomicBoolean mDidCallInit = new AtomicBoolean(false);
    private AdView adView;

    public void loadAd(Activity activity, Map<String, String> config) throws Throwable {
        super.loadAd(activity, config);
        if (!this.check(activity, config)) {
            return;
        }
        this.initSdk(activity);
        if (this.adView != null) {
            this.adView.loadAd();
            return;
        }
        AdSize adSize = this.getAdSize((Context)activity, config);
        this.adView = new AdView(activity.getApplicationContext(), this.mInstancesKey, adSize);
        AdView.AdViewLoadConfigBuilder loadConfigBuilder = this.adView.buildLoadAdConfig();
        if (config.containsKey(PAY_LOAD)) {
            loadConfigBuilder.withBid(config.get(PAY_LOAD));
        }
        loadConfigBuilder.withAdListener((AdListener)this);
        this.adView.loadAd(loadConfigBuilder.build());
    }

    public int getMediation() {
        return 3;
    }

    public void destroy(Activity activity) {
        if (this.adView != null) {
            this.adView.destroy();
            this.adView = null;
        }
        this.isDestroyed = true;
    }

    public void onError(Ad ad, AdError adError) {
        if (this.isDestroyed) {
            return;
        }
        this.onInsError(AdapterErrorBuilder.buildLoadError((String)"Banner", (String)this.mAdapterName, (int)adError.getErrorCode(), (String)adError.getErrorMessage()));
    }

    public void onAdLoaded(Ad ad) {
        if (this.isDestroyed) {
            return;
        }
        AdLog.getSingleton().LogD("FacebookBanner", "Facebook Banner ad load success ");
        this.onInsReady(this.adView);
    }

    public void onAdClicked(Ad ad) {
        if (this.isDestroyed) {
            return;
        }
        this.onInsClicked();
    }

    public void onLoggingImpression(Ad ad) {
    }

    private AdSize getAdSize(Context context, Map<String, String> config) {
        String bannerDesc;
        switch (bannerDesc = this.getBannerDesc(config)) {
            case "LEADERBOARD": {
                return AdSize.BANNER_HEIGHT_90;
            }
            case "RECTANGLE": {
                return AdSize.RECTANGLE_HEIGHT_250;
            }
            case "SMART": {
                if (FacebookBanner.isLargeScreen((Context)context)) {
                    return AdSize.BANNER_HEIGHT_90;
                }
                return AdSize.BANNER_HEIGHT_50;
            }
        }
        return AdSize.BANNER_HEIGHT_50;
    }

    private void initSdk(Activity activity) {
        AdSettings.setIntegrationErrorMode((AdSettings.IntegrationErrorMode)AdSettings.IntegrationErrorMode.INTEGRATION_ERROR_CALLBACK_MODE);
        if (this.mDidCallInit.compareAndSet(false, true)) {
            AudienceNetworkAds.buildInitSettings((Context)activity.getApplicationContext()).withInitListener(new AudienceNetworkAds.InitListener(){

                public void onInitialized(AudienceNetworkAds.InitResult result) {
                }
            }).initialize();
        }
    }
}

