/*
 * Decompiled with CFR 0.152.
 */
package com.mhy.socialcommon;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.service.quicksettings.TileService;
import androidx.annotation.DrawableRes;
import androidx.core.content.FileProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ShareUtil {
    Context mActivity;
    private static ShareUtil shareUtil;
    public static final String AliPay_Barcode = "alipayqr://platformapi/startapp?saId=20000056";
    public static final String AliPay_Paycode = "alipayqr://platformapi/startapp?saId=20000123";
    public static final String AliPay_Hongbao = "alipay://platformapi/startapp?saId=88886666";
    public static final String AliPay_Scan = "alipayqr://platformapi/startapp?saId=10000007";
    public static final String AliPay_Qr = "&qrcode=https%3a%2f%2fqr.alipay.com%2f";
    public static final String AliPay_Qr_Me = "&qrcode=https%3a%2f%2fqr.alipay.com%2ffkx19000ssxku6zeqdfnc1f";
    public static final String WX_Scan = "weixin://scanqrcode";
    public static final String WX = "weixin://";
    public static final String AliPay = "alipays://platformapi/startApp";

    public static ShareUtil getInstance(Context context) {
        if (shareUtil == null) {
            shareUtil = new ShareUtil(context);
        }
        return shareUtil;
    }

    private ShareUtil(Context act) {
        this.mActivity = act;
    }

    public void shareText(String content) {
        Intent textIntent = new Intent("android.intent.action.SEND");
        textIntent.setType("text/plain");
        textIntent.putExtra("android.intent.extra.TEXT", content);
        this.mActivity.startActivity(Intent.createChooser((Intent)textIntent, (CharSequence)"\u5206\u4eab"));
    }

    public void shareImg(int resImg) {
        String path = this.getResourcesUri(resImg);
        Intent imageIntent = new Intent("android.intent.action.SEND");
        imageIntent.setType("image/*");
        imageIntent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.parse((String)path));
        this.mActivity.startActivity(Intent.createChooser((Intent)imageIntent, (CharSequence)"\u5206\u4eab"));
    }

    public void shareImg(String path) {
        Intent imageIntent = new Intent("android.intent.action.SEND");
        imageIntent.setType("image/*");
        imageIntent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.parse((String)path));
        this.mActivity.startActivity(Intent.createChooser((Intent)imageIntent, (CharSequence)"\u5206\u4eab"));
    }

    public void shareMultPath(ArrayList<String> imagePaths) {
        ArrayList<Uri> imageUris = new ArrayList<Uri>();
        for (String imagePath : imagePaths) {
            Uri uri = Uri.parse((String)imagePath);
            imageUris.add(uri);
        }
        Intent mulIntent = new Intent("android.intent.action.SEND_MULTIPLE");
        mulIntent.putParcelableArrayListExtra("android.intent.extra.STREAM", imageUris);
        mulIntent.setType("image/*");
        this.mActivity.startActivity(Intent.createChooser((Intent)mulIntent, (CharSequence)"\u5206\u4eab"));
    }

    public void shareMultImg(ArrayList<Integer> imageRes) {
        ArrayList<Uri> imageUris = new ArrayList<Uri>();
        for (Integer imageRe : imageRes) {
            Uri uri1 = Uri.parse((String)this.getResourcesUri(imageRe));
            imageUris.add(uri1);
        }
        Intent mulIntent = new Intent("android.intent.action.SEND_MULTIPLE");
        mulIntent.putParcelableArrayListExtra("android.intent.extra.STREAM", imageUris);
        mulIntent.setType("image/*");
        this.mActivity.startActivity(Intent.createChooser((Intent)mulIntent, (CharSequence)"\u5206\u4eab"));
    }

    public void shareWx(String msg) {
        Intent wechatIntent = new Intent("android.intent.action.SEND");
        wechatIntent.setPackage("com.tencent.mm");
        wechatIntent.setType("text/plain");
        wechatIntent.putExtra("android.intent.extra.TEXT", msg);
        this.mActivity.startActivity(wechatIntent);
    }

    public void shareWb(String msg) {
        Intent weiboIntent = new Intent("android.intent.action.SEND");
        weiboIntent.setPackage("com.sina.weibo");
        weiboIntent.setType("text/plain");
        weiboIntent.putExtra("android.intent.extra.TEXT", msg);
        this.mActivity.startActivity(weiboIntent);
    }

    public void shareQq(String msg) {
        Intent qqIntent = new Intent("android.intent.action.SEND");
        qqIntent.setPackage("com.tencent.mobileqq");
        qqIntent.setType("text/plain");
        qqIntent.putExtra("android.intent.extra.TEXT", msg);
        this.mActivity.startActivity(qqIntent);
    }

    public void shareFile(String filePath) {
        File file = new File(filePath);
        if (null != file && file.exists()) {
            Intent share = new Intent("android.intent.action.SEND");
            Uri uri = null;
            if (Build.VERSION.SDK_INT >= 24) {
                uri = FileProvider.getUriForFile((Context)this.mActivity, (String)(this.mActivity.getPackageName() + ".com.fileprovider"), (File)file);
                share.addFlags(1);
            } else {
                uri = Uri.fromFile((File)file);
            }
            share.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
            share.setType(this.getMimeType(file.getAbsolutePath()));
            share.setFlags(0x10000000);
            share.addFlags(1);
            this.mActivity.startActivity(Intent.createChooser((Intent)share, (CharSequence)"\u5206\u4eab\u6587\u4ef6"));
        }
    }

    private String getMimeType(String filePath) {
        MediaMetadataRetriever mmr = new MediaMetadataRetriever();
        String mime = "*/*";
        if (filePath != null) {
            try {
                mmr.setDataSource(filePath);
                mime = mmr.extractMetadata(12);
            }
            catch (IllegalStateException e) {
                return mime;
            }
            catch (IllegalArgumentException e) {
                return mime;
            }
            catch (RuntimeException e) {
                return mime;
            }
        }
        return mime;
    }

    private String getResourcesUri(@DrawableRes int id) {
        Resources resources = this.mActivity.getResources();
        String uriPath = "android.resource://" + resources.getResourcePackageName(id) + "/" + resources.getResourceTypeName(id) + "/" + resources.getResourceEntryName(id);
        return uriPath;
    }

    public void sendEmail(String title, String content, String emails) {
        Uri uri = Uri.parse((String)("mailto:" + emails));
        Intent intent = new Intent("android.intent.action.SENDTO", uri);
        intent.putExtra("android.intent.extra.SUBJECT", title);
        intent.putExtra("android.intent.extra.TEXT", content);
        this.mActivity.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"\u8bf7\u9009\u62e9\u90ae\u4ef6\u7c7b\u5e94\u7528"));
    }

    public void sendEmailAccessory(String title, String content, String[] emails, String filePath) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.putExtra("android.intent.extra.EMAIL", emails);
        intent.putExtra("android.intent.extra.TEXT", content);
        intent.putExtra("android.intent.extra.SUBJECT", title);
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.parse((String)filePath));
        intent.setType("*/*");
        intent.setType("message/rfc882");
        Intent.createChooser((Intent)intent, (CharSequence)"\u8bf7\u9009\u62e9\u90ae\u4ef6\u7c7b\u5e94\u7528");
        this.mActivity.startActivity(intent);
    }

    public void sendEmailMultipleAccessory(String title, String content, String emails, List<String> filePaths) {
        Intent intent = new Intent("android.intent.action.SEND_MULTIPLE");
        intent.putExtra("android.intent.extra.EMAIL", emails);
        intent.putExtra("android.intent.extra.TEXT", content);
        intent.putExtra("android.intent.extra.SUBJECT", title);
        ArrayList<Uri> imageUris = new ArrayList<Uri>();
        for (String filePath : filePaths) {
            imageUris.add(Uri.parse((String)filePath));
        }
        intent.putParcelableArrayListExtra("android.intent.extra.STREAM", imageUris);
        intent.setType("*/*");
        intent.setType("message/rfc882");
        Intent.createChooser((Intent)intent, (CharSequence)"\u8bf7\u9009\u62e9\u90ae\u4ef6\u7c7b\u5e94\u7528");
        this.mActivity.startActivity(intent);
    }

    private String saveImage(int resId) {
        File file = new File(this.mActivity.getFilesDir().getAbsolutePath() + "/image/Image.png");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.mActivity.getResources(), (int)resId);
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fOut);
        try {
            fOut.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file.getPath();
    }

    public void openBrowser(String url) {
        Uri myBlogUri = Uri.parse((String)url);
        this.mActivity.startActivity(new Intent("android.intent.action.VIEW", myBlogUri));
    }

    public void openMap(String j, String w) {
        Uri mapUri = Uri.parse((String)("geo:" + j + "\uff0c" + w));
        this.mActivity.startActivity(new Intent("android.intent.action.VIEW", mapUri));
    }

    public void toCall(String phone) {
        Uri telUri = Uri.parse((String)("tel:" + phone));
        this.mActivity.startActivity(new Intent("android.intent.action.DIAL", telUri));
    }

    public void doCall(String phone) {
        Uri callUri = Uri.parse((String)("tel:" + phone));
        this.mActivity.startActivity(new Intent("android.intent.action.CALL", callUri));
    }

    public void unInstanll(String packname) {
        Uri uninstallUri = Uri.fromParts((String)"package", (String)packname, null);
        this.mActivity.startActivity(new Intent("android.intent.action.DELETE", uninstallUri));
    }

    public void instanll(String packname) {
        Uri installUri = Uri.fromParts((String)"package", (String)packname, null);
        this.mActivity.startActivity(new Intent("android.intent.action.PACKAGE_ADDED", installUri));
    }

    public void play(String path) {
        Uri playUri = Uri.parse((String)path);
        this.mActivity.startActivity(new Intent("android.intent.action.VIEW", playUri));
    }

    public void toSendSMS(String phone, String msg) {
        Uri smsUri = Uri.parse((String)("tel:" + phone));
        Intent intent = new Intent("android.intent.action.VIEW", smsUri);
        this.mActivity.startActivity(intent);
        intent.putExtra("sms_body", "yyyy");
        intent.setType("vnd.android-dir/mms-sms");
    }

    public void doSendSMS(String phone, String msg) {
        Uri smsToUri = Uri.parse((String)("smsto://" + phone));
        Intent intent = new Intent("android.intent.action.SENDTO", smsToUri);
        intent.putExtra("sms_body", msg);
        this.mActivity.startActivity(intent);
    }

    public void toSendColorSMS(String mediaPath, String phone, String msg) {
        Uri mmsUri = Uri.parse((String)mediaPath);
        Intent intent = new Intent("android.intent.action.SEND");
        intent.putExtra("sms_body", msg);
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)mmsUri);
        intent.setType("*/*");
        this.mActivity.startActivity(intent);
    }

    public boolean openUrl(String url) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addFlags(0x10000000);
            this.startIntent(intent);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void openOutMain(String packname, String className, Bundle bundle) {
        Intent intent = new Intent("android.intent.action.MAIN");
        ComponentName cmp = new ComponentName(packname, className);
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.addFlags(0x10000000);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        intent.setComponent(cmp);
        this.startIntent(intent);
    }

    public void openOutActivity(String packname, String className, Bundle bundle, int flag) {
        Intent intent = new Intent("android.intent.action.VIEW");
        ComponentName cmp = new ComponentName(packname, className);
        intent.addFlags(flag);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        intent.setComponent(cmp);
        this.startIntent(intent);
    }

    private void startIntent(Intent intent) {
        if (this.isActivityAvailable(intent)) {
            if (Build.VERSION.SDK_INT >= 24) {
                if (this.mActivity instanceof TileService) {
                    ((TileService)this.mActivity).startActivityAndCollapse(intent);
                } else {
                    this.mActivity.startActivity(intent);
                }
            } else {
                this.mActivity.startActivity(intent);
            }
        }
    }

    public void openWxScan() {
        Bundle bundle = new Bundle();
        bundle.putBoolean("LauncherUI.From.Scaner.Shortcut", true);
        this.openOutActivity("com.tencent.mm", "com.tencent.mm.ui.LauncherUI", bundle, 0x14000000);
    }

    public void openwx() {
        this.openOutMain("com.tencent.mm", "com.tencent.mm.ui.LauncherUI", null);
    }

    public void alipayMe(String urlCode) {
        this.openUrl("alipayqr://platformapi/startapp?saId=10000007&qrcode=https%3a%2f%2fqr.alipay.com%2f" + urlCode);
    }

    protected boolean hasInstall(String pack) {
        PackageManager pm = this.mActivity.getPackageManager();
        try {
            PackageInfo info = pm.getPackageInfo(pack, 0);
            return info != null;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean isActivityAvailable(Intent intent) {
        PackageManager pm = this.mActivity.getPackageManager();
        if (pm == null) {
            return false;
        }
        List list = pm.queryIntentActivities(intent, 65536);
        return list != null && list.size() > 0;
    }

    public boolean checkAliPayInstalled() {
        Uri uri = Uri.parse((String)AliPay);
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        ComponentName componentName = intent.resolveActivity(this.mActivity.getPackageManager());
        return componentName != null;
    }

    public boolean checkWxInstalled() {
        Uri uri = Uri.parse((String)WX);
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        ComponentName componentName = intent.resolveActivity(this.mActivity.getPackageManager());
        return componentName != null;
    }
}

