/*
 * Decompiled with CFR 0.152.
 */
package com.mhy.socialcommon;

import android.app.Activity;
import android.content.Intent;
import com.mhy.socialcommon.SocialType;

public abstract class AuthApi {
    protected Activity mActivity;
    protected static SocialType mAuthType;
    protected static OnAuthListener mOnAuthListener;

    public AuthApi(Activity act, OnAuthListener l) {
        this.mActivity = act;
        this.setAuthListener(l);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    public void setAuthListener(OnAuthListener l) {
        mOnAuthListener = l;
    }

    public static void setCompleteCallBack(Object user) {
        if (mOnAuthListener != null) {
            mOnAuthListener.onComplete(mAuthType, user);
        }
    }

    public static void setErrorCallBack(String error) {
        if (mOnAuthListener != null) {
            mOnAuthListener.onError(mAuthType, error);
        }
    }

    public static void setCancelCallBack() {
        if (mOnAuthListener != null) {
            mOnAuthListener.onCancel(mAuthType);
        }
    }

    public static void release() {
        mOnAuthListener = null;
    }

    public static interface OnAuthListener {
        public void onComplete(SocialType var1, Object var2);

        public void onError(SocialType var1, String var2);

        public void onCancel(SocialType var1);
    }
}

