/*
 * Decompiled with CFR 0.152.
 */
package com.mhy.socialcommon;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import androidx.annotation.DrawableRes;
import androidx.core.content.FileProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class ShareUtil {
    Activity mActivity;

    public ShareUtil(Activity act) {
        this.mActivity = act;
    }

    public void shareText(String content) {
        Intent textIntent = new Intent("android.intent.action.SEND");
        textIntent.setType("text/plain");
        textIntent.putExtra("android.intent.extra.TEXT", content);
        this.mActivity.startActivity(Intent.createChooser((Intent)textIntent, (CharSequence)"\u5206\u4eab"));
    }

    public void shareImg(int resImg) {
        String path = this.getResourcesUri(resImg);
        Intent imageIntent = new Intent("android.intent.action.SEND");
        imageIntent.setType("image/*");
        imageIntent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.parse((String)path));
        this.mActivity.startActivity(Intent.createChooser((Intent)imageIntent, (CharSequence)"\u5206\u4eab"));
    }

    public void shareImg(String path) {
        Intent imageIntent = new Intent("android.intent.action.SEND");
        imageIntent.setType("image/*");
        imageIntent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.parse((String)path));
        this.mActivity.startActivity(Intent.createChooser((Intent)imageIntent, (CharSequence)"\u5206\u4eab"));
    }

    public void shareMultPath(ArrayList<String> imagePaths) {
        ArrayList<Uri> imageUris = new ArrayList<Uri>();
        for (String imagePath : imagePaths) {
            Uri uri = Uri.parse((String)imagePath);
            imageUris.add(uri);
        }
        Intent mulIntent = new Intent("android.intent.action.SEND_MULTIPLE");
        mulIntent.putParcelableArrayListExtra("android.intent.extra.STREAM", imageUris);
        mulIntent.setType("image/*");
        this.mActivity.startActivity(Intent.createChooser((Intent)mulIntent, (CharSequence)"\u5206\u4eab"));
    }

    public void shareMultImg(ArrayList<Integer> imageRes) {
        ArrayList<Uri> imageUris = new ArrayList<Uri>();
        for (Integer imageRe : imageRes) {
            Uri uri1 = Uri.parse((String)this.getResourcesUri(imageRe));
            imageUris.add(uri1);
        }
        Intent mulIntent = new Intent("android.intent.action.SEND_MULTIPLE");
        mulIntent.putParcelableArrayListExtra("android.intent.extra.STREAM", imageUris);
        mulIntent.setType("image/*");
        this.mActivity.startActivity(Intent.createChooser((Intent)mulIntent, (CharSequence)"\u5206\u4eab"));
    }

    public void shareWx(String msg) {
        Intent wechatIntent = new Intent("android.intent.action.SEND");
        wechatIntent.setPackage("com.tencent.mm");
        wechatIntent.setType("text/plain");
        wechatIntent.putExtra("android.intent.extra.TEXT", msg);
        this.mActivity.startActivity(wechatIntent);
    }

    public void shareWb(String msg) {
        Intent weiboIntent = new Intent("android.intent.action.SEND");
        weiboIntent.setPackage("com.sina.weibo");
        weiboIntent.setType("text/plain");
        weiboIntent.putExtra("android.intent.extra.TEXT", msg);
        this.mActivity.startActivity(weiboIntent);
    }

    public void shareQq(String msg) {
        Intent qqIntent = new Intent("android.intent.action.SEND");
        qqIntent.setPackage("com.tencent.mobileqq");
        qqIntent.setType("text/plain");
        qqIntent.putExtra("android.intent.extra.TEXT", msg);
        this.mActivity.startActivity(qqIntent);
    }

    public void shareFile(String filePath) {
        File file = new File(filePath);
        if (null != file && file.exists()) {
            Intent share = new Intent("android.intent.action.SEND");
            Uri uri = null;
            if (Build.VERSION.SDK_INT >= 24) {
                uri = FileProvider.getUriForFile((Context)this.mActivity, (String)(this.mActivity.getPackageName() + ".com.fileprovider"), (File)file);
                share.addFlags(1);
            } else {
                uri = Uri.fromFile((File)file);
            }
            share.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
            share.setType(this.getMimeType(file.getAbsolutePath()));
            share.setFlags(0x10000000);
            share.addFlags(1);
            this.mActivity.startActivity(Intent.createChooser((Intent)share, (CharSequence)"\u5206\u4eab\u6587\u4ef6"));
        }
    }

    private String getMimeType(String filePath) {
        MediaMetadataRetriever mmr = new MediaMetadataRetriever();
        String mime = "*/*";
        if (filePath != null) {
            try {
                mmr.setDataSource(filePath);
                mime = mmr.extractMetadata(12);
            }
            catch (IllegalStateException e) {
                return mime;
            }
            catch (IllegalArgumentException e) {
                return mime;
            }
            catch (RuntimeException e) {
                return mime;
            }
        }
        return mime;
    }

    private String getResourcesUri(@DrawableRes int id) {
        Resources resources = this.mActivity.getResources();
        String uriPath = "android.resource://" + resources.getResourcePackageName(id) + "/" + resources.getResourceTypeName(id) + "/" + resources.getResourceEntryName(id);
        return uriPath;
    }

    public void sendEmail(String title, String content, String emails) {
        Uri uri = Uri.parse((String)("mailto:" + emails));
        Intent intent = new Intent("android.intent.action.SENDTO", uri);
        intent.putExtra("android.intent.extra.EMAIL", emails);
        intent.putExtra("android.intent.extra.CC", emails);
        intent.putExtra("android.intent.extra.SUBJECT", title);
        intent.putExtra("android.intent.extra.TEXT", content);
        this.mActivity.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"\u8bf7\u9009\u62e9\u90ae\u4ef6\u7c7b\u5e94\u7528"));
    }

    private String saveImage(int resId) {
        File file = new File(this.mActivity.getFilesDir().getAbsolutePath() + "/image/Image.png");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.mActivity.getResources(), (int)resId);
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fOut);
        try {
            fOut.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file.getPath();
    }
}

