/*
 * Decompiled with CFR 0.152.
 */
package com.mhy.socialcommon;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.service.quicksettings.TileService;
import android.widget.Toast;
import com.mhy.socialcommon.PayContent;
import java.util.List;

public abstract class PayApi {
    protected Activity mAct;
    protected static OnPayListener mPayResultListener;
    private static int mPayType;
    private String mOrderInfo;

    protected void setPayType(int authType) {
        mPayType = authType;
    }

    protected int getPayType() {
        return mPayType;
    }

    public PayApi(Activity act, OnPayListener l) {
        this.mAct = act;
        this.setOnPayListener(l);
    }

    public abstract void doPay(PayContent var1);

    public void setOrderInfo(String orderInfo) {
        this.mOrderInfo = orderInfo;
    }

    public String getOrderInfo() {
        return this.mOrderInfo;
    }

    public void setOnPayListener(OnPayListener l) {
        mPayResultListener = l;
    }

    public static void callbackPayOk() {
        if (mPayResultListener != null) {
            mPayResultListener.onPayOk();
        }
    }

    public static void callbackPayFail(String code, String msg) {
        if (mPayResultListener != null) {
            mPayResultListener.onPayFail(code, msg);
        }
    }

    public void alipayMe(String urlCode) {
        urlCode = "fkx19953nsokfrvlylqoy86";
        if (this.hasInstall("com.eg.android.AlipayGphone")) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("alipays://platformapi/startapp?saId=10000007&clientVersion=3.7.0.0718&qrcode=https%3A%2F%2Fqr.alipay.com%2F" + urlCode + "%3F_s%3Dweb-other")));
            intent.addFlags(0x10000000);
            this.mAct.startActivity(intent);
        }
    }

    protected boolean hasInstall(String pack) {
        PackageManager pm = this.mAct.getPackageManager();
        try {
            PackageInfo info = pm.getPackageInfo(pack, 0);
            return info != null;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void startWxScan() {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.tencent.mm", "com.tencent.mm.ui.LauncherUI"));
        intent.putExtra("LauncherUI.From.Scaner.Shortcut", true);
        intent.setFlags(0x14000000);
        intent.setAction("android.intent.action.VIEW");
        if (this.isActivityAvailable(intent)) {
            this.mAct.startActivity(intent);
        } else {
            Toast.makeText((Context)this.mAct, (CharSequence)"\u672a\u5b89\u88c5\u5fae\u4fe1\uff5e", (int)0).show();
        }
    }

    public static boolean openAlipayScan(Context context) {
        try {
            Uri uri = Uri.parse((String)"alipayqr://platformapi/startapp?saId=10000007");
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            if (Build.VERSION.SDK_INT >= 24) {
                if (context instanceof TileService) {
                    ((TileService)context).startActivityAndCollapse(intent);
                }
            } else {
                context.startActivity(intent);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean openAlipayBarcode(Context context) {
        try {
            Uri uri = Uri.parse((String)"alipayqr://platformapi/startapp?saId=20000056");
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            if (Build.VERSION.SDK_INT >= 24) {
                if (context instanceof TileService) {
                    ((TileService)context).startActivityAndCollapse(intent);
                }
            } else {
                context.startActivity(intent);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isActivityAvailable(Intent intent) {
        PackageManager pm = this.mAct.getPackageManager();
        if (pm == null) {
            return false;
        }
        List list = pm.queryIntentActivities(intent, 65536);
        return list != null && list.size() > 0;
    }

    public static interface OnPayListener {
        public void onPayOk();

        public void onPayFail(String var1, String var2);
    }
}

