/*
 * Decompiled with CFR 0.152.
 */
package com.mhy.socialcommon;

import android.app.Activity;
import android.content.Intent;

public abstract class AuthApi {
    protected Activity mActivity;
    private static int mAuthType;
    protected static OnAuthListener mOnAuthListener;

    public AuthApi(Activity act, OnAuthListener l) {
        this.mActivity = act;
        this.setAuthListener(l);
    }

    protected void setAuthType(int authType) {
        mAuthType = authType;
    }

    protected int getAuthType() {
        return mAuthType;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    public void setAuthListener(OnAuthListener l) {
        mOnAuthListener = l;
    }

    public static void setCompleteCallBack(Object user) {
        if (mOnAuthListener != null) {
            mOnAuthListener.onComplete(mAuthType, user);
        }
    }

    public static void setErrorCallBack(String error) {
        if (mOnAuthListener != null) {
            mOnAuthListener.onError(mAuthType, error);
        }
    }

    public static void setCancelCallBack() {
        if (mOnAuthListener != null) {
            mOnAuthListener.onCancel(mAuthType);
        }
    }

    public static void release() {
        mOnAuthListener = null;
    }

    public static interface OnAuthListener {
        public void onComplete(int var1, Object var2);

        public void onError(int var1, String var2);

        public void onCancel(int var1);
    }
}

