/*
 * Decompiled with CFR 0.152.
 */
package com.mhy.alilibrary.auth;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.alipay.sdk.app.AuthTask;
import com.mhy.alilibrary.bean.AuthResult;
import com.mhy.socialcommon.AuthApi;
import com.mhy.socialcommon.SocialType;
import java.util.Map;

public class AliAuth
extends AuthApi {
    @SuppressLint(value={"HandlerLeak"})
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 2) {
                AuthResult authResult = new AuthResult((Map)msg.obj, true);
                String resultStatus = authResult.getResultStatus();
                if (TextUtils.equals((CharSequence)resultStatus, (CharSequence)"9000") && TextUtils.equals((CharSequence)authResult.getResultCode(), (CharSequence)"200")) {
                    AuthApi.setCompleteCallBack((Object)authResult);
                } else {
                    AuthApi.setErrorCallBack((String)resultStatus);
                }
            }
        }
    };

    public AliAuth(Activity act, AuthApi.OnAuthListener l) {
        super(act, l);
        mAuthType = SocialType.ALIPAY_Auth;
    }

    public void doAuth(String orderInfo) {
        if (orderInfo.isEmpty()) {
            AliAuth.setErrorCallBack((String)"orderInfo\u662f\u7a7a");
            return;
        }
        this.authV2(orderInfo);
    }

    public void authV2(final String orderInfo) {
        Runnable authRunnable = new Runnable(){

            @Override
            public void run() {
                AuthTask authTask = new AuthTask(AliAuth.this.mActivity);
                Map result = authTask.authV2(orderInfo, true);
                Message msg = new Message();
                msg.what = 2;
                msg.obj = result;
                AliAuth.this.mHandler.sendMessage(msg);
            }
        };
        Thread authThread = new Thread(authRunnable);
        authThread.start();
    }
}

