/*
 * Decompiled with CFR 0.152.
 */
package com.methelas.utilities.securestore;

import android.content.Context;
import android.os.AsyncTask;
import com.methelas.utilities.securestore.Utils;
import com.methelas.utilities.securestore.exceptions.AlreadyDefinedAliasException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;

public class SecureStore {
    private static int BLOCK_SIZE_ENCRYPT = 100;
    private static int BLOCK_SIZE_DECRYPT = 128;

    public static void insertAsync(final Context ctx, final String alias, final int validity, final String data, final SecureStoreInsertListener listener) {
        new AsyncTask<Object, Object, Boolean>(){

            protected Boolean doInBackground(Object ... params) {
                try {
                    return SecureStore.insert(ctx, alias, validity, data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }

            protected void onPostExecute(Boolean aVoid) {
                if (listener != null) {
                    listener.onInsertFinished(aVoid);
                }
            }
        }.execute(new Object[0]);
    }

    public static boolean insert(Context ctx, String alias, int validity, String data) throws AlreadyDefinedAliasException {
        String directory = ctx.getFilesDir().getAbsolutePath() + File.separator + alias;
        try {
            KeyStore keyStore = KeyStore.getInstance("AndroidKeystore");
            keyStore.load(null);
            if (keyStore.containsAlias(alias)) {
                throw new AlreadyDefinedAliasException("Alias " + alias + " is already defined!");
            }
            Utils.generateKeyPair(ctx, alias, validity);
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, null);
            RSAPublicKey publicKey = (RSAPublicKey)privateKeyEntry.getCertificate().getPublicKey();
            Cipher outputCipher = Cipher.getInstance("RSA/NONE/PKCS1Padding");
            outputCipher.init(1, publicKey);
            byte[] dataAsBytes = data.getBytes("UTF-8");
            int fullBlocks = dataAsBytes.length / BLOCK_SIZE_ENCRYPT;
            byte[] dataEncrypted = new byte[]{};
            for (int i = 0; i < fullBlocks; ++i) {
                byte[] encryptedPart = outputCipher.doFinal(dataAsBytes, i * BLOCK_SIZE_ENCRYPT, BLOCK_SIZE_ENCRYPT);
                dataEncrypted = Utils.appendByteArrays(dataEncrypted, encryptedPart);
            }
            byte[] encryptedPart = outputCipher.doFinal(dataAsBytes, fullBlocks * BLOCK_SIZE_ENCRYPT, dataAsBytes.length - fullBlocks * BLOCK_SIZE_ENCRYPT);
            dataEncrypted = Utils.appendByteArrays(dataEncrypted, encryptedPart);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(directory)));
            bos.write(dataEncrypted);
            bos.flush();
            bos.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void extractAsync(final Context ctx, final String alias, final SecureStoreExtractListener listener) {
        new AsyncTask<Object, Object, String>(){

            protected String doInBackground(Object ... params) {
                try {
                    return SecureStore.extract(ctx, alias);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }

            protected void onPostExecute(String aVoid) {
                if (listener != null) {
                    listener.onExtractFinished(aVoid);
                }
            }
        }.execute(new Object[0]);
    }

    public static String extract(Context ctx, String alias) {
        String directory = ctx.getFilesDir().getAbsolutePath() + File.separator + alias;
        try {
            KeyStore keyStore = KeyStore.getInstance("AndroidKeystore");
            keyStore.load(null);
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, null);
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            Cipher inputCipher = Cipher.getInstance("RSA/NONE/PKCS1Padding");
            inputCipher.init(2, privateKey);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(directory)));
            byte[] buffer = new byte[BLOCK_SIZE_DECRYPT];
            String result = "";
            while (bis.read(buffer) != -1) {
                result = result + new String(inputCipher.doFinal(buffer), "UTF-8");
            }
            bis.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean delete(Context ctx, String alias) {
        String directory = ctx.getFilesDir().getAbsolutePath() + File.separator + alias;
        try {
            File f;
            KeyStore keyStore = KeyStore.getInstance("AndroidKeystore");
            keyStore.load(null);
            if (keyStore.containsAlias(alias)) {
                keyStore.deleteEntry(alias);
            }
            if ((f = new File(directory)).exists()) {
                f.delete();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static interface SecureStoreExtractListener {
        public void onExtractFinished(String var1);
    }

    public static interface SecureStoreInsertListener {
        public void onInsertFinished(boolean var1);
    }
}

