/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.metamx.metrics.AbstractMonitor;
import com.metamx.metrics.KeyedDiff;
import com.metamx.metrics.MonitorUtils;
import java.util.Map;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class JvmCpuMonitor
extends AbstractMonitor {
    private static final Logger log = new Logger(JvmCpuMonitor.class);
    private final Sigar sigar = new Sigar();
    private final KeyedDiff diff = new KeyedDiff();
    private Map<String, String[]> dimensions;

    public JvmCpuMonitor() {
        this((Map<String, String[]>)ImmutableMap.of());
    }

    public JvmCpuMonitor(Map<String, String[]> dimensions) {
        Preconditions.checkNotNull(dimensions);
        this.dimensions = ImmutableMap.copyOf(dimensions);
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        try {
            ProcCpu procCpu = this.sigar.getProcCpu(this.sigar.getPid());
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            Map<String, Long> procDiff = this.diff.to("proc/cpu", (Map<String, Long>)ImmutableMap.of((Object)"jvm/cpu/total", (Object)procCpu.getTotal(), (Object)"jvm/cpu/sys", (Object)procCpu.getSys(), (Object)"jvm/cpu/user", (Object)procCpu.getUser()));
            if (procDiff != null) {
                for (Map.Entry<String, Long> entry : procDiff.entrySet()) {
                    emitter.emit(builder.build(entry.getKey(), (Number)entry.getValue()));
                }
            }
            emitter.emit(builder.build("jvm/cpu/percent", (Number)procCpu.getPercent()));
        }
        catch (SigarException e) {
            log.error((Throwable)e, "Failed to get ProcCpu", new Object[0]);
        }
        return true;
    }
}

